/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.internal;

import io.hyperfoil.tools.parse.internal.DropString;
import java.util.BitSet;

public class SharedString
extends DropString
implements CharSequence {
    private BitSet bits;
    private int start;
    private int stop;
    private SharedString parent;

    public SharedString(String line) {
        this(line, new BitSet(line.length()), 0, line.length(), null, true);
    }

    public SharedString(String line, int start, int stop, SharedString parent) {
        this(line, new BitSet(stop - start), start, stop, parent, true);
    }

    private SharedString(String line, BitSet bits, int start, int stop, SharedString parent, boolean flip) {
        super(line);
        this.line = line;
        this.bits = bits;
        this.start = start;
        this.stop = stop;
        this.parent = parent;
        if (flip) {
            bits.flip(start, stop);
        }
    }

    @Override
    public String getLine() {
        return this.line;
    }

    public int getAbsoluteIndex(int index) {
        if (index > this.bits.cardinality()) {
            throw new IndexOutOfBoundsException(index + " > " + this.bits.cardinality());
        }
        int targetIndex = -1;
        int sum = -1;
        while (sum < index && ++targetIndex < this.line.length()) {
            if (!this.bits.get(targetIndex)) continue;
            ++sum;
        }
        return targetIndex;
    }

    public int getAbsoluteIndex2(int relativeIndex) {
        int currentIndex;
        for (currentIndex = 0; relativeIndex >= 0 && currentIndex < this.bits.length(); ++currentIndex) {
            if (!this.bits.get(currentIndex)) continue;
            --relativeIndex;
        }
        return --currentIndex + this.start;
    }

    public int getRelativeIndex(int absoluteIndex) {
        if (absoluteIndex < 0 || absoluteIndex >= this.line.length()) {
            throw new IndexOutOfBoundsException(absoluteIndex + " out of range [0," + this.line.length() + ")");
        }
        return this.bits.get(0, absoluteIndex).cardinality();
    }

    @Override
    public void drop(int start, int end) {
        int startIndex;
        int iterIndex;
        if (start > end || start < 0 || end > this.line.length()) {
            throw new IllegalArgumentException("Invalid drop range. [length=" + this.line.length() + " start=" + start + " end=" + end + "] line=" + this.toString());
        }
        int sum = end - start;
        for (iterIndex = startIndex = this.getAbsoluteIndex(start); iterIndex < this.line.length() && sum > 0; ++iterIndex) {
            if (!this.bits.get(iterIndex)) continue;
            --sum;
            this.bits.clear(iterIndex);
        }
        if (this.parent != null) {
            this.parent.childDropRange(startIndex, iterIndex);
        }
        this.updateReferences(start, end);
    }

    private void childDropRange(int start, int end) {
        int relativeStart = this.getRelativeIndex(start);
        int relativeEnd = this.getRelativeIndex(end);
        this.drop(relativeStart, relativeEnd);
    }

    public String debug() {
        StringBuffer chars = new StringBuffer();
        StringBuffer bits = new StringBuffer();
        StringBuffer indx = new StringBuffer();
        for (int i = 0; i < this.stop - this.start; ++i) {
            chars.append(String.format("%3s", "" + this.line.charAt(this.start + i)));
            bits.append(String.format("%3s", this.bits.get(i) ? " " : "x"));
            indx.append(String.format("%3d", i));
        }
        return indx.toString() + "\n" + chars.toString() + "\n" + bits.toString();
    }

    @Override
    public int length() {
        return this.bits.cardinality();
    }

    @Override
    public char charAt(int index) {
        return this.line.charAt(this.getAbsoluteIndex(index));
    }

    @Override
    public SharedString subSequence(int start, int end) {
        StringBuffer stringBuffer = new StringBuffer();
        int startIndex = this.getAbsoluteIndex(start);
        int endIndex = this.getAbsoluteIndex(end);
        return new SharedString(this.getLine(), startIndex, endIndex, this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int endIndex = this.line.length();
        int sum = this.length();
        for (int startIndex = 0; sum > 0 && startIndex < this.line.length(); ++startIndex) {
            if (!this.bits.get(startIndex)) continue;
            stringBuffer.append(this.line.charAt(startIndex));
            --sum;
        }
        return stringBuffer.toString();
    }
}

