/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.internal;

import io.hyperfoil.tools.parse.internal.IMatcher;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;

public class StringMatcher
implements IMatcher {
    private LinkedList<Matchable> matchers;
    private int regionStart;
    private int regionEnd;
    private int matchStart;
    private int matchEnd;
    private CharSequence input;
    private HashMap<String, String> matches;

    public StringMatcher(String pattern) {
        this.matchers = StringMatcher.parsePattern(pattern);
        this.matches = new HashMap();
    }

    @Override
    public void reset(CharSequence input) {
        this.input = input;
        this.regionStart = 0;
        this.regionEnd = input.length();
        this.matchStart = 0;
        this.matchEnd = -1;
    }

    @Override
    public boolean find() {
        int startIdx = this.matchEnd + 1;
        this.matches.clear();
        String str = this.input.toString();
        this.matchEnd = this.regionStart;
        this.matchStart = this.regionEnd;
        for (Matchable m : this.matchers) {
            int expectIdx;
            int prefixIdx = str.indexOf(m.prefix, startIdx);
            if (prefixIdx < 0 || m.forceStart && prefixIdx > 0) {
                return false;
            }
            int suffixIdx = prefixIdx + m.prefix.length();
            suffixIdx = m.lastSuffix ? str.lastIndexOf(m.suffix, this.regionEnd) : str.indexOf(m.suffix, suffixIdx);
            if (suffixIdx < 0 || suffixIdx + m.suffix.length() > this.regionEnd) {
                return false;
            }
            if (m.forceEnd && suffixIdx + m.suffix.length() != this.regionEnd) {
                return false;
            }
            if (m.expectString && ((expectIdx = str.indexOf(m.expected, prefixIdx + m.prefix.length())) < 0 || expectIdx + m.expected.length() != suffixIdx)) {
                return false;
            }
            this.matches.put(m.name, str.substring(prefixIdx + m.prefix.length(), suffixIdx));
            if (prefixIdx < this.matchStart) {
                this.matchStart = prefixIdx;
            }
            if (suffixIdx + m.suffix.length() > this.matchEnd) {
                this.matchEnd = suffixIdx + m.suffix.length();
            }
            startIdx = suffixIdx;
        }
        return this.matches.size() >= this.matchers.size();
    }

    @Override
    public boolean find(CharSequence input, int start, int end) {
        return false;
    }

    @Override
    public void region(int start, int end) {
        this.regionStart = start;
        this.regionEnd = end;
        this.matchStart = this.regionStart;
        this.matchEnd = this.regionStart - 1;
    }

    @Override
    public int start() {
        return this.matchStart;
    }

    @Override
    public int end() {
        return this.matchEnd;
    }

    @Override
    public Set<String> groups() {
        return this.matches.keySet();
    }

    @Override
    public String group(String name) {
        return this.matches.get(name);
    }

    public static boolean canMatch(String pattern) {
        return StringMatcher.parsePattern(pattern) != null;
    }

    private static LinkedList<Matchable> parsePattern(String pattern) {
        LinkedList<Matchable> rtrn = new LinkedList<Matchable>();
        int idx = 0;
        int startIdx = 0;
        int closeCarretIdx = 0;
        int closePatternIdx = 0;
        Matchable prev = null;
        while (idx < pattern.length() && (startIdx = pattern.indexOf("(?<", idx)) > -1) {
            closePatternIdx = closeCarretIdx = pattern.indexOf(">", startIdx);
            while ((closePatternIdx = pattern.indexOf(")", closePatternIdx + 1)) > -1 && pattern.charAt(closePatternIdx - 1) == '\\') {
            }
            Matchable next = new Matchable();
            if (startIdx <= idx) {
                return null;
            }
            next.prefix = pattern.substring(idx, startIdx);
            if (next.prefix.startsWith("^")) {
                next.forceStart = true;
                next.prefix = next.prefix.substring(1);
            }
            if (prev != null) {
                prev.suffix = next.prefix;
                if (prev.suffix.endsWith("$")) {
                    prev.forceEnd = true;
                    prev.suffix = prev.suffix.substring(0, prev.suffix.length() - 1);
                }
            }
            if (closeCarretIdx <= startIdx + 3) {
                return null;
            }
            next.name = pattern.substring(startIdx + 3, closeCarretIdx);
            String p = pattern.substring(closeCarretIdx + 1, closePatternIdx);
            if (p == ".*" || p == ".+") {
                next.lastSuffix = true;
            }
            if (!p.matches(".*(?<=\\\\)[dDsSwW].*") && !p.matches(".*(?<!\\\\)[\\.\\*].*")) {
                next.expected = p;
                next.expectString = true;
            }
            rtrn.add(next);
            prev = next;
            idx = closePatternIdx + 1;
        }
        if (closePatternIdx + 1 < pattern.length()) {
            prev.suffix = pattern.substring(closePatternIdx + 1);
            if (prev.suffix.endsWith("$")) {
                prev.forceEnd = true;
                prev.suffix = prev.suffix.substring(0, prev.suffix.length() - 1);
            }
        }
        LinkedList<String> l = new LinkedList<String>();
        l.add(pattern.substring(closePatternIdx + 1));
        return rtrn;
    }

    public static String pad(int i) {
        if (i <= 0) {
            return "";
        }
        return "                                                                                                                                                                                                              ".substring(0, i);
    }

    private static class Matchable {
        public String prefix = null;
        public String name = null;
        public String expected = null;
        public String suffix = null;
        public boolean lastSuffix = false;
        public boolean forceStart = false;
        public boolean expectString = false;
        public boolean forceEnd = false;

        private Matchable() {
        }
    }
}

