/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.json;

import io.hyperfoil.tools.yaup.json.Json;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class JsonBuilder {
    public static final String NAME_KEY = "_TARGET_NAME_" + System.currentTimeMillis();
    private Stack<Target> targets = new Stack();
    private Json closedJson = null;

    public JsonBuilder() {
        this.pushTarget(new Json());
    }

    public boolean close() {
        if (!this.wasClosed() && !this.getRoot().isEmpty()) {
            this.closedJson = this.getRoot();
            this.targets.clear();
            this.pushTarget(new Json());
            return true;
        }
        return false;
    }

    public boolean wasClosed() {
        return this.closedJson != null;
    }

    public Json takeClosed() {
        if (!this.wasClosed()) {
            return null;
        }
        Json rtrn = this.closedJson;
        this.closedJson = null;
        return rtrn;
    }

    public Json getRoot() {
        return ((Target)this.targets.get((int)0)).target;
    }

    public Json peekTarget(int ahead) {
        if (ahead > this.targets.size() - 1) {
            return null;
        }
        return ((Target)this.targets.get((int)(this.targets.size() - 1 - ahead))).target;
    }

    public Json getTarget() {
        return this.targets.peek().target;
    }

    public Json getTarget(String name) {
        Json rtrn = null;
        int index = this.namedTargetIndex(name);
        if (index >= 0) {
            rtrn = ((Target)this.targets.get((int)index)).target;
        }
        return rtrn;
    }

    public int pushTarget(Json json) {
        return this.pushTarget(json, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pushTarget(Json json, String name) {
        int rtrn = -1;
        JsonBuilder jsonBuilder = this;
        synchronized (jsonBuilder) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (name != null && !name.isEmpty()) {
                infoMap.put(NAME_KEY, name);
            }
            rtrn = this.targets.size();
            this.targets.push(new Target(json, infoMap));
        }
        return rtrn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Json popTargetIndex(int index) {
        JsonBuilder jsonBuilder = this;
        synchronized (jsonBuilder) {
            if (this.targets.size() > index && index > 0) {
                Target rtrn = (Target)this.targets.remove(index);
                return rtrn.target;
            }
        }
        return null;
    }

    public Json popTarget() {
        return this.popTarget(1);
    }

    public Json popTarget(String name) {
        int index = this.namedTargetIndex(name);
        Json rtrn = null;
        if (index >= 0) {
            rtrn = this.popTargetIndex(index);
        }
        return rtrn;
    }

    public int namedTargetIndex(String name) {
        String indexName;
        int index = this.targets.size() - 1;
        boolean found = false;
        while (!(found = name.equals(indexName = (String)((Target)this.targets.get((int)index)).info.get(NAME_KEY))) && --index >= 0) {
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Json popTarget(int count) {
        if (count >= this.targets.size() - 1) {
            // empty if block
        }
        Json rtrn = null;
        JsonBuilder jsonBuilder = this;
        synchronized (jsonBuilder) {
            for (int i = 0; i < count; ++i) {
                if (this.targets.size() <= 1) continue;
                rtrn = this.targets.pop().target;
            }
        }
        return rtrn;
    }

    public int size() {
        return this.targets.size();
    }

    public Json targetStackJson() {
        Json rtrn = new Json();
        for (int i = this.targets.size() - 1; i > 0; --i) {
            Json entry = new Json();
            entry.set((Object)"target", (Object)((Target)this.targets.get((int)i)).target);
            entry.set((Object)"info", (Object)Json.fromMap(((Target)this.targets.get((int)i)).info));
            if (entry.getJson((Object)"info").has((Object)NAME_KEY)) {
                entry.getJson((Object)"info").set((Object)"name", entry.getJson((Object)"info").get((Object)NAME_KEY));
                entry.getJson((Object)"info").remove((Object)NAME_KEY);
            }
            rtrn.add((Object)entry);
        }
        return rtrn;
    }

    public String debug(boolean recursive) {
        StringBuilder sb = new StringBuilder();
        int infoWidth = this.targets.stream().mapToInt(s -> s.info.toString().length()).max().orElse(2);
        int idxWidth = Math.max((int)Math.round(Math.ceil(Math.log10(this.targets.size()))), 1);
        int limit = recursive ? 0 : this.targets.size() - 1;
        for (int i = this.targets.size() - 1; i >= limit; --i) {
            if (i < this.targets.size() - 1) {
                sb.append("\n");
            }
            sb.append(String.format("%-" + infoWidth + "s %" + idxWidth + "d %s", ((Target)this.targets.get((int)i)).info, i, ((Target)this.targets.get((int)i)).target));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTargets() {
        JsonBuilder jsonBuilder = this;
        synchronized (jsonBuilder) {
            while (this.targets.size() > 1) {
                this.targets.pop();
            }
        }
    }

    public void clearTargets(String name) {
        int index = this.namedTargetIndex(name);
        if (index >= 0) {
            while (this.size() - 1 >= index) {
                this.popTarget();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        JsonBuilder jsonBuilder = this;
        synchronized (jsonBuilder) {
            this.targets.clear();
            Json root = new Json();
            this.targets.push(new Target(root, new HashMap<String, Object>()));
        }
    }

    public boolean hasContext(String key, boolean recursive) {
        boolean rtrn;
        int index = this.targets.size() - 1;
        while (!(rtrn = ((Target)this.targets.get((int)index)).info.containsKey(key)) && recursive && --index >= 0) {
        }
        return rtrn;
    }

    public void setRootContext(String key, Object value) {
        this.setContext(key, value, -1);
    }

    public void setContext(String key, Object value, int offset) {
        int index = this.targets.size() - 1;
        index = offset < 0 ? 0 : (index -= offset);
        if (index < 0) {
            index = 0;
        }
        ((Target)this.targets.get((int)index)).info.put(key, value);
    }

    public void setContext(String key, Object value) {
        this.targets.peek().info.put(key, value);
    }

    public Object getContext(String key, boolean recursive, Object defaultValue) {
        int index = this.targets.size() - 1;
        Object rtrn = defaultValue;
        boolean found = false;
        do {
            if (!((Target)this.targets.get((int)index)).info.containsKey(key)) continue;
            found = true;
            rtrn = ((Target)this.targets.get((int)index)).info.get(key);
        } while (!found && recursive && --index >= 0);
        return rtrn;
    }

    public String getContextString(String key, boolean recursive) {
        Object rtrn = this.getContext(key, recursive, "");
        return (String)rtrn;
    }

    public int getContextInteger(String key, boolean recursive) {
        Object rtrn = this.getContext(key, recursive, 0);
        return (Integer)rtrn;
    }

    public boolean getContextBoolean(String key, boolean recursive) {
        Object rtrn = this.getContext(key, recursive, false);
        return (Boolean)rtrn;
    }

    private class Target {
        Json target;
        Map<String, Object> info;

        public Target(Json target, Map<String, Object> info) {
            this.target = target;
            this.info = info;
        }
    }
}

