/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.reader;

import io.hyperfoil.tools.parse.Parser;
import io.hyperfoil.tools.yaup.HashedList;
import io.hyperfoil.tools.yaup.file.FileUtility;
import java.io.IOException;
import java.io.InputStream;

public abstract class AReader {
    private HashedList<Parser> parsers = new HashedList();

    protected abstract void processInputStream(InputStream var1);

    public void read(String path) {
        this.setup();
        try (InputStream inputStream = FileUtility.getInputStream((String)path);){
            this.processInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.close();
    }

    public void read(InputStream stream) {
        this.setup();
        this.processInputStream(stream);
        this.close();
    }

    public void addParser(Parser toAdd) {
        this.parsers.add((Object)toAdd);
    }

    public int parserCount() {
        return this.parsers.size();
    }

    public void onLine(String line) {
        for (int i = 0; i < this.parsers.size(); ++i) {
            ((Parser)this.parsers.get(i)).onLine(line);
        }
    }

    protected void setup() {
        for (int i = 0; i < this.parsers.size(); ++i) {
            ((Parser)this.parsers.get(i)).setup();
        }
    }

    protected void close() {
        for (int i = 0; i < this.parsers.size(); ++i) {
            ((Parser)this.parsers.get(i)).close();
        }
    }
}

