/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.reader;

import io.hyperfoil.tools.parse.JsonConsumer;
import io.hyperfoil.tools.parse.reader.AReader;
import io.hyperfoil.tools.yaup.json.Json;
import java.io.InputStream;
import java.util.LinkedList;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonArrayReader
extends AReader {
    JSONTokener tokener;
    private LinkedList<JsonConsumer> consumers = new LinkedList();

    public void add(JsonConsumer consumer) {
        this.consumers.add(consumer);
    }

    @Override
    protected void processInputStream(InputStream stream) {
        for (JsonConsumer c : this.consumers) {
            c.start();
        }
        this.tokener = new JSONTokener(stream);
        char ch = this.tokener.next();
        if (ch != '[') {
            throw new IllegalArgumentException("Expect stream to start with [ but encountered [" + ch + "]");
        }
        while (this.tokener.more()) {
            JSONObject obj = (JSONObject)this.tokener.nextValue();
            Json json = Json.fromJSONObject((JSONObject)obj);
            for (JsonConsumer jc : this.consumers) {
                jc.consume(json);
            }
            ch = this.tokener.next();
            if (ch == ',' || ch == ']') continue;
            throw new IllegalArgumentException("Expect trailing , or ] after each entry but encountered [" + ch + "]");
        }
        for (JsonConsumer c : this.consumers) {
            c.close();
        }
    }
}

