/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.reader;

import io.hyperfoil.tools.parse.JsonConsumer;
import io.hyperfoil.tools.parse.reader.AReader;
import io.hyperfoil.tools.yaup.json.Json;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.json.JSONObject;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReader
extends AReader {
    private Stack<String> nameStack = new Stack();
    private Stack<JSONObject> jsonStack = new Stack();
    private int qDepth = 0;
    private StringBuilder sb = new StringBuilder();
    private DefaultHandler handler;
    private Map<String, LinkedList<JsonConsumer>> consumers = new LinkedHashMap<String, LinkedList<JsonConsumer>>();

    public XmlReader() {
        this.handler = new DefaultHandler(){

            @Override
            public void startDocument() {
            }

            @Override
            public void endDocument() {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                ++XmlReader.this.qDepth;
                if (!XmlReader.this.jsonStack.isEmpty() || XmlReader.this.consumers.containsKey(qName)) {
                    JSONObject toPush = new JSONObject();
                    if (!XmlReader.this.jsonStack.isEmpty()) {
                        JSONObject peek = XmlReader.this.jsonStack.peek();
                        peek.accumulate(qName, (Object)toPush);
                    }
                    XmlReader.this.nameStack.push(qName);
                    XmlReader.this.jsonStack.push(toPush);
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                --XmlReader.this.qDepth;
                if (!XmlReader.this.jsonStack.isEmpty()) {
                    if (XmlReader.this.sb.length() > 0) {
                        XmlReader.this.jsonStack.pop();
                        XmlReader.this.jsonStack.peek().put(qName, (Object)XmlReader.this.sb.toString());
                    } else {
                        JSONObject pop = XmlReader.this.jsonStack.pop();
                        Json poped = Json.fromJSONObject((JSONObject)pop);
                        if (XmlReader.this.consumers.containsKey(qName)) {
                            for (JsonConsumer c : XmlReader.this.consumers.get(qName)) {
                                c.consume(poped);
                            }
                        }
                    }
                    XmlReader.this.nameStack.pop();
                    XmlReader.this.sb.setLength(0);
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                String characters;
                if (!XmlReader.this.jsonStack.isEmpty() && !(characters = new String(ch, start, length).trim()).isEmpty()) {
                    XmlReader.this.sb.append(characters);
                }
            }

            @Override
            public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            }
        };
    }

    public void add(String qName, JsonConsumer consumer) {
        LinkedList<JsonConsumer> list = this.consumers.get(qName);
        if (list == null) {
            list = new LinkedList();
            this.consumers.put(qName, list);
        }
        list.add(consumer);
    }

    @Override
    protected void processInputStream(InputStream stream) {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        for (List list : this.consumers.values()) {
            for (JsonConsumer c : list) {
                c.start();
            }
        }
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            saxParser.parse(stream, this.handler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (List list : this.consumers.values()) {
            for (JsonConsumer c : list) {
                c.close();
            }
        }
    }
}

