/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.yaml;

import io.hyperfoil.tools.parse.Eat;
import io.hyperfoil.tools.parse.Exp;
import io.hyperfoil.tools.parse.ExpMerge;
import io.hyperfoil.tools.parse.ExpRule;
import io.hyperfoil.tools.parse.MatchRange;
import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.json.Json;
import io.hyperfoil.tools.yaup.yaml.DeferableConstruct;
import io.hyperfoil.tools.yaup.yaml.Mapping;
import io.hyperfoil.tools.yaup.yaml.OverloadConstructor;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class ExpConstruct
extends DeferableConstruct {
    public static final Mapping<Exp> MAPPING = exp -> {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", exp.getName());
        map.put("pattern", exp.buildPattern());
        if (Eat.from(exp.getEat()).equals((Object)Eat.Width)) {
            map.put("eat", exp.getEat());
        } else if (!Eat.Match.equals((Object)Eat.from(exp.getEat()))) {
            map.put("eat", Eat.from(exp.getEat()).toString().toLowerCase());
        }
        if (!MatchRange.AfterParent.equals((Object)exp.getRange())) {
            map.put("range", exp.getRange().toString().toLowerCase());
        }
        if (!exp.getRequires().isEmpty()) {
            map.put("requires", exp.getRequires());
        }
        if (!exp.getEnables().isEmpty()) {
            map.put("enables", exp.getEnables());
        }
        if (!exp.getDisables().isEmpty()) {
            map.put("disables", exp.getDisables());
        }
        if (!exp.getWith().isEmpty()) {
            map.putIfAbsent("with", exp.getWith());
        }
        if (exp.isNested()) {
            map.putIfAbsent("nest", exp.getNest());
        }
        if (exp.hasRules()) {
            // empty if block
        }
        return map;
    };

    public Object construct(Node node) {
        BiConsumer<Exp, ScalarNode> ruleScalar = (e, n) -> {
            try {
                e.addRule((ExpRule)StringUtil.getEnum((String)n.getValue(), ExpRule.class, null));
            }
            catch (IllegalArgumentException iae) {
                throw new YAMLException("invalid rule value" + n.getStartMark());
            }
        };
        BiConsumer<Exp, MappingNode> ruleMap = (e, n) -> n.getValue().forEach(rule -> {
            if (!(rule.getKeyNode() instanceof ScalarNode)) {
                throw new YAMLException("rule mapping requires a scalar key" + rule.getKeyNode().getStartMark());
            }
            if (!(rule.getValueNode() instanceof ScalarNode)) {
                throw new YAMLException("rule mapping requires a scalar value" + rule.getValueNode().getStartMark());
            }
            String key = ((ScalarNode)rule.getKeyNode()).getValue();
            String value = ((ScalarNode)rule.getValueNode()).getValue();
            try {
                e.addRule((ExpRule)StringUtil.getEnum((String)key, ExpRule.class, null), value);
            }
            catch (IllegalArgumentException iae) {
                throw new YAMLException("invalid rule mapping key" + rule.getKeyNode().getStartMark());
            }
        });
        if (node instanceof ScalarNode) {
            String pattern = ((ScalarNode)node).getValue();
            return new Exp(pattern);
        }
        if (node instanceof MappingNode) {
            MappingNode mappingNode = (MappingNode)node;
            Json json = OverloadConstructor.json((Node)node);
            Exp rtrn = null;
            if (!json.has((Object)"name") || !json.has((Object)"pattern")) {
                throw new YAMLException("Exp requires Name and pattern" + node.getStartMark());
            }
            rtrn = new Exp(json.getString((Object)"name"), json.getString((Object)"pattern"));
            if (rtrn != null) {
                Exp exp = rtrn;
                mappingNode.getValue().forEach(nodeTuple -> {
                    if (!(nodeTuple.getKeyNode() instanceof ScalarNode)) {
                        throw new YAMLException("Exp keys must be scalar " + nodeTuple.getKeyNode().getStartMark());
                    }
                    String key = ((ScalarNode)nodeTuple.getKeyNode()).getValue();
                    Node valueNode = nodeTuple.getValueNode();
                    switch (key) {
                        case "debug": {
                            break;
                        }
                        case "name": 
                        case "pattern": {
                            break;
                        }
                        case "eat": {
                            if (valueNode instanceof ScalarNode) {
                                String value = ((ScalarNode)valueNode).getValue();
                                if (value.matches("//d+")) {
                                    exp.eat(Integer.parseInt(value));
                                    break;
                                }
                                try {
                                    exp.eat((Eat)StringUtil.getEnum((String)value, Eat.class, (Enum)Eat.Match));
                                    break;
                                }
                                catch (IllegalArgumentException e) {
                                    throw new YAMLException("invalid eat value" + valueNode.getStartMark());
                                }
                            }
                            throw new YAMLException("eat must be a scalar" + valueNode.getStartMark());
                        }
                        case "children": {
                            if (valueNode instanceof SequenceNode) {
                                SequenceNode children = (SequenceNode)valueNode;
                                children.getValue().forEach(child -> {
                                    Object childExp = this.construct((Node)child);
                                    if (childExp != null && childExp instanceof Exp) {
                                        exp.add((Exp)childExp);
                                    }
                                });
                                break;
                            }
                            throw new YAMLException("children must be a sequence" + valueNode.getStartMark());
                        }
                        case "merge": {
                            if (valueNode instanceof ScalarNode) {
                                try {
                                    ExpMerge m = (ExpMerge)StringUtil.getEnum((String)((ScalarNode)valueNode).getValue(), ExpMerge.class, (Enum)ExpMerge.ByKey);
                                    exp.setMerge(m);
                                    break;
                                }
                                catch (IllegalArgumentException e) {
                                    throw new YAMLException("invalid merge value" + valueNode.getStartMark());
                                }
                            }
                            throw new YAMLException("merge must be a scalar" + valueNode.getStartMark());
                        }
                        case "requires": {
                            if (valueNode instanceof ScalarNode) {
                                exp.requires(((ScalarNode)valueNode).getValue());
                                break;
                            }
                            if (valueNode instanceof SequenceNode) {
                                SequenceNode sequenceNode = (SequenceNode)valueNode;
                                sequenceNode.getValue().forEach(entry -> {
                                    if (!(entry instanceof ScalarNode)) {
                                        throw new YAMLException("requires entries must be scalar" + entry.getStartMark());
                                    }
                                    exp.requires(((ScalarNode)entry).getValue());
                                });
                                break;
                            }
                            throw new YAMLException("requires should be a scalar or sequence" + valueNode.getStartMark());
                        }
                        case "enables": {
                            if (valueNode instanceof ScalarNode) {
                                exp.enables(((ScalarNode)valueNode).getValue());
                                break;
                            }
                            if (valueNode instanceof SequenceNode) {
                                SequenceNode sequenceNode = (SequenceNode)valueNode;
                                sequenceNode.getValue().forEach(entry -> {
                                    if (!(entry instanceof ScalarNode)) {
                                        throw new YAMLException("enables entries must be scalar" + entry.getStartMark());
                                    }
                                    exp.enables(((ScalarNode)entry).getValue());
                                });
                                break;
                            }
                            throw new YAMLException("enables should be a scalar or sequence" + valueNode.getStartMark());
                        }
                        case "disables": {
                            if (valueNode instanceof ScalarNode) {
                                exp.disables(((ScalarNode)valueNode).getValue());
                                break;
                            }
                            if (valueNode instanceof SequenceNode) {
                                SequenceNode sequenceNode = (SequenceNode)valueNode;
                                sequenceNode.getValue().forEach(entry -> {
                                    if (!(entry instanceof ScalarNode)) {
                                        throw new YAMLException("disables entries must be scalar" + entry.getStartMark());
                                    }
                                    exp.disables(((ScalarNode)entry).getValue());
                                });
                                break;
                            }
                            throw new YAMLException("disables should be a scalar or sequence" + valueNode.getStartMark());
                        }
                        case "rule": {
                            if (valueNode instanceof ScalarNode) {
                                ruleScalar.accept(exp, (ScalarNode)valueNode);
                                break;
                            }
                            if (valueNode instanceof MappingNode) {
                                ruleMap.accept(exp, (MappingNode)valueNode);
                                break;
                            }
                            if (valueNode instanceof SequenceNode) {
                                SequenceNode sequenceNode = (SequenceNode)valueNode;
                                sequenceNode.getValue().forEach(entry -> {
                                    if (entry instanceof ScalarNode) {
                                        ruleScalar.accept(exp, (ScalarNode)entry);
                                    } else if (entry instanceof MappingNode) {
                                        ruleMap.accept(exp, (MappingNode)entry);
                                    } else {
                                        throw new YAMLException("rule sequence entreis must be scalar or mapping" + entry.getStartMark());
                                    }
                                });
                                break;
                            }
                            throw new YAMLException("rule must be a scalar, sequence, or mapping" + valueNode.getStartMark());
                        }
                        case "nest": {
                            if (valueNode instanceof ScalarNode) {
                                exp.nest(((ScalarNode)valueNode).getValue());
                                break;
                            }
                            throw new YAMLException("nest requires a scalar" + valueNode.getStartMark());
                        }
                        case "group": {
                            if (valueNode instanceof ScalarNode) {
                                exp.group(((ScalarNode)valueNode).getValue());
                                break;
                            }
                            if (valueNode instanceof SequenceNode) {
                                ((SequenceNode)valueNode).getValue().forEach(entry -> {
                                    if (!(entry instanceof ScalarNode)) {
                                        throw new YAMLException("group sequence entries need to be scalar" + entry.getStartMark());
                                    }
                                    exp.group(((ScalarNode)valueNode).getValue());
                                });
                                break;
                            }
                            throw new YAMLException("group requires a scalar or sequence" + valueNode.getStartMark());
                        }
                        case "key": {
                            if (valueNode instanceof ScalarNode) {
                                exp.key(((ScalarNode)valueNode).getValue());
                                break;
                            }
                            if (valueNode instanceof SequenceNode) {
                                ((SequenceNode)valueNode).getValue().forEach(entry -> {
                                    if (!(entry instanceof ScalarNode)) {
                                        throw new YAMLException("key sequence entries need to be scalar" + entry.getStartMark());
                                    }
                                    exp.key(((ScalarNode)valueNode).getValue());
                                });
                                break;
                            }
                            throw new YAMLException("key requires a scalar or sequence" + valueNode.getStartMark());
                        }
                        case "extend": {
                            if (valueNode instanceof ScalarNode) {
                                exp.extend(((ScalarNode)valueNode).getValue());
                                break;
                            }
                            if (valueNode instanceof SequenceNode) {
                                ((SequenceNode)valueNode).getValue().forEach(entry -> {
                                    if (!(entry instanceof ScalarNode)) {
                                        throw new YAMLException("extend sequence entries need to be scalar" + entry.getStartMark());
                                    }
                                    exp.extend(((ScalarNode)valueNode).getValue());
                                });
                                break;
                            }
                            throw new YAMLException("extend requires a scalar or sequence" + valueNode.getStartMark());
                        }
                    }
                });
            }
            return rtrn;
        }
        throw new YAMLException("Exp requires a mapping node" + node.getStartMark());
    }
}

