/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.yaml;

import io.hyperfoil.tools.parse.file.FileRule;
import io.hyperfoil.tools.parse.file.Filter;
import io.hyperfoil.tools.parse.file.JbossCliConverter;
import io.hyperfoil.tools.parse.file.JsonConverter;
import io.hyperfoil.tools.parse.file.MatchCriteria;
import io.hyperfoil.tools.parse.file.XmlConverter;
import io.hyperfoil.tools.yaup.yaml.DeferableConstruct;
import java.util.List;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class FileRuleConstruct
extends DeferableConstruct {
    public Object construct(Node node) {
        FileRule rtrn = new FileRule();
        if (!(node instanceof MappingNode)) {
            throw new YAMLException("FileRule requires a mapping" + node.getStartMark());
        }
        MappingNode mappingNode = (MappingNode)node;
        mappingNode.getValue().forEach(nodeTuple -> {
            if (!(nodeTuple.getKeyNode() instanceof ScalarNode)) {
                throw new YAMLException("FileRule keys must be scalar" + nodeTuple.getKeyNode().getStartMark());
            }
            String key = ((ScalarNode)nodeTuple.getKeyNode()).getValue();
            Node valueNode = nodeTuple.getValueNode();
            switch (key.toLowerCase()) {
                case "match": {
                    if (valueNode instanceof SequenceNode) {
                        ((SequenceNode)valueNode).getValue().forEach(entryNode -> {
                            Object deferred = this.deferAs((Node)entryNode, new Tag(MatchCriteria.class));
                            if (!(deferred instanceof MatchCriteria)) {
                                throw new YAMLException("failed to create a MatchCriteria" + entryNode.getStartMark());
                            }
                            rtrn.setCriteria((MatchCriteria)deferred);
                        });
                        break;
                    }
                    Object deferred = this.deferAs(valueNode, new Tag(MatchCriteria.class));
                    if (deferred instanceof MatchCriteria) {
                        rtrn.setCriteria((MatchCriteria)deferred);
                        break;
                    }
                    throw new YAMLException("failt to create a MatchCriteria" + valueNode.getStartMark());
                }
                case "nest": {
                    if (valueNode instanceof ScalarNode) {
                        rtrn.setNest(((ScalarNode)valueNode).getValue());
                        break;
                    }
                    throw new YAMLException("FileRule nest must be a scalar" + valueNode.getStartMark());
                }
                case "parse": {
                    if (valueNode instanceof SequenceNode) {
                        String value = ((ScalarNode)valueNode).getValue().toLowerCase().trim();
                        if (value.equals("json")) {
                            rtrn.setConverter(new JsonConverter());
                            break;
                        }
                        if (value.equals("xml")) {
                            rtrn.setConverter(new XmlConverter());
                            break;
                        }
                        if (value.equals("jboss-cli") || value.equals("jbosscli")) {
                            rtrn.setConverter(new JbossCliConverter());
                            break;
                        }
                        throw new YAMLException("failed to create a parser" + valueNode.getStartMark());
                    }
                    if (!(valueNode instanceof MappingNode)) break;
                    MappingNode valueMapping = (MappingNode)valueNode;
                    List keys = valueMapping.getValue().stream().map(tuple -> ((ScalarNode)tuple.getKeyNode()).getValue()).collect(Collectors.toList());
                    if (keys.size() > 1) {
                        throw new YAMLException("FileRule parse can only have one key mapping" + valueNode.getStartMark());
                    }
                    String converterKey = ((String)keys.get(0)).toLowerCase().trim();
                    Node mappingValue = ((NodeTuple)((MappingNode)valueNode).getValue().get(0)).getValueNode();
                    this.deferAs((Node)mappingNode, new Tag(converterKey));
                    break;
                }
                case "filter": {
                    if (valueNode instanceof SequenceNode) {
                        ((SequenceNode)valueNode).getValue().forEach(entryNode -> {
                            Object deferred = this.deferAs((Node)entryNode, new Tag(Filter.class));
                            if (!(deferred instanceof Filter)) {
                                throw new YAMLException("failed to create a filter" + entryNode.getStartMark());
                            }
                            rtrn.addFilter((Filter)deferred);
                        });
                        break;
                    }
                    Object deferred = this.deferAs(valueNode, new Tag(Filter.class));
                    if (deferred instanceof Filter) {
                        rtrn.addFilter((Filter)deferred);
                        break;
                    }
                    throw new YAMLException("failed to create a filter" + valueNode.getStartMark());
                }
            }
        });
        return rtrn;
    }
}

