/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.parse.yaml;

import io.hyperfoil.tools.parse.file.Filter;
import io.hyperfoil.tools.yaup.yaml.DeferableConstruct;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class FilterConstruct
extends DeferableConstruct {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object construct(Node node) {
        Filter rtrn = new Filter();
        if (node instanceof ScalarNode) {
            String value = ((ScalarNode)node).getValue();
            if (!value.startsWith("function") && !value.contains("=>")) throw new YAMLException("scalar filter definition must be a javascript function" + node.getStartMark());
            rtrn.setResult(value);
            return rtrn;
        } else {
            if (!(node instanceof MappingNode)) return rtrn;
            MappingNode mappingNode = (MappingNode)node;
            mappingNode.getValue().forEach(nodeTuple -> {
                if (!(nodeTuple.getKeyNode() instanceof ScalarNode)) {
                    throw new YAMLException("filter keys must be scalar" + nodeTuple.getKeyNode().getStartMark());
                }
                String key = ((ScalarNode)nodeTuple.getKeyNode()).getValue();
                Node valueNode = nodeTuple.getValueNode();
                switch (key.toLowerCase()) {
                    case "path": {
                        String path = ((ScalarNode)valueNode).getValue();
                        rtrn.setPath(path);
                        if (path.startsWith("/")) {
                            rtrn.setType(Filter.Type.Xml);
                            break;
                        }
                        if (path.startsWith("$")) {
                            rtrn.setType(Filter.Type.Json);
                            break;
                        }
                        throw new YAMLException("valid filter paths start with / or $" + valueNode.getStartMark());
                    }
                    case "nest": {
                        rtrn.setNest(((ScalarNode)valueNode).getValue());
                        break;
                    }
                    case "regex": {
                        rtrn.setRegex(((ScalarNode)valueNode).getValue());
                        break;
                    }
                    case "result": {
                        rtrn.setResult(((ScalarNode)valueNode).getValue());
                    }
                }
            });
        }
        return rtrn;
    }
}

