/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Counters<T>
implements Serializable {
    private ConcurrentHashMap<T, LongAdder> counts = new ConcurrentHashMap();
    private LongAdder sum = new LongAdder();

    public void add(T t) {
        this.add(t, 1L);
    }

    public void add(T t, long amount) {
        this.counts.computeIfAbsent(t, v -> new LongAdder());
        this.counts.get(t).add(amount);
        this.sum.add(amount);
    }

    public void clear() {
        this.sum.reset();
        this.counts.clear();
    }

    public void forEach(Consumer<T> consumer) {
        ((ConcurrentHashMap.KeySetView)this.counts.keySet()).forEach(consumer);
    }

    public void forEach(BiConsumer<T, Long> consumer) {
        this.counts.forEach((? super K t, ? super V a) -> consumer.accept(t, a.longValue()));
    }

    public boolean contains(T t) {
        return this.counts.containsKey(t);
    }

    public long count(T t) {
        if (this.contains(t)) {
            return this.counts.get(t).longValue();
        }
        return 0L;
    }

    public boolean isEmpty() {
        return this.counts.isEmpty();
    }

    public long sum() {
        return this.sum.longValue();
    }

    public int size() {
        return this.counts.size();
    }

    public List<T> entries() {
        return Arrays.asList(((ConcurrentHashMap.CollectionView)((Object)this.counts.keySet())).toArray());
    }

    public String toString() {
        return this.counts.entrySet().stream().map(e -> e.getKey() + "=" + e.getValue()).collect(Collectors.joining(" "));
    }
}

