/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HashedList<V> {
    private HashSet<V> seen = new HashSet();
    private LinkedList<V> data = new LinkedList();

    public HashedList() {
        this(Collections.emptyList());
    }

    public HashedList(List<V> values) {
        this.addAll(values);
    }

    public boolean addAll(Collection<V> values) {
        boolean rtrn = true;
        if (!values.isEmpty()) {
            for (V v : values) {
                boolean addRtrn = this.add(v);
                rtrn = addRtrn && rtrn;
            }
        }
        return rtrn;
    }

    public V get(int index) {
        if (index < this.size()) {
            return this.data.get(index);
        }
        return null;
    }

    public boolean add(V value) {
        boolean rtrn = false;
        if (this.seen.add(value)) {
            this.data.add(value);
            rtrn = true;
        }
        return rtrn;
    }

    public boolean removeAll(Collection<V> values) {
        boolean rtrn = true;
        if (!values.isEmpty()) {
            for (V v : values) {
                rtrn = rtrn && this.remove(v);
            }
        }
        return rtrn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(V value) {
        if (this.seen.contains(value)) {
            HashSet<V> hashSet = this.seen;
            synchronized (hashSet) {
                this.seen.remove(value);
                this.data.remove(value);
            }
            return true;
        }
        return false;
    }

    public boolean contains(V value) {
        return this.seen.contains(value);
    }

    public int size() {
        return this.data.size();
    }

    public V getLast() {
        return this.data.getLast();
    }

    public V getFirst() {
        return this.data.getFirst();
    }

    public Iterator<V> iterator() {
        return this.data.iterator();
    }

    public List<V> toList() {
        return Collections.unmodifiableList(this.data);
    }
}

