/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class HashedSets<K, V>
implements Serializable {
    private Map<K, HashSet<V>> sets = new ConcurrentHashMap<K, HashSet<V>>();
    private Set<V> empty = Collections.unmodifiableSet(new HashSet());
    private final boolean linked;
    private final Function<K, HashSet<V>> supplier;

    public HashedSets() {
        this(true);
    }

    public HashedSets(boolean linked) {
        this.linked = linked;
        this.supplier = k -> linked ? new LinkedHashSet() : new HashSet();
    }

    public void put(K name, V value) {
        this.sets.computeIfAbsent(name, this.supplier).add(value);
    }

    public void putAll(K name, Collection<V> values) {
        this.sets.computeIfAbsent(name, this.supplier).addAll(values);
    }

    public Set<V> get(K key) {
        if (this.sets.containsKey(key)) {
            return Collections.unmodifiableSet((Set)this.sets.get(key));
        }
        return this.empty;
    }

    public boolean has(K key) {
        return this.sets.containsKey(key);
    }

    public Set<K> keys() {
        return Collections.unmodifiableSet(this.sets.keySet());
    }

    public int size() {
        return this.sets.size();
    }

    public boolean isEmpty() {
        return this.sets.isEmpty();
    }

    public void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.empty);
        stream.writeObject(this.sets);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.empty = (Set)stream.readObject();
        this.sets = (HashMap)stream.readObject();
    }

    private void readObjectNoData() throws ObjectStreamException {
    }

    public void clear() {
        this.sets.clear();
    }

    public void forEach(BiConsumer<K, Set<V>> consumer) {
        this.sets.forEach(consumer);
    }

    public Stream<Map.Entry<K, HashSet<V>>> stream() {
        return this.sets.entrySet().stream();
    }

    public Iterator<Map.Entry<K, HashSet<V>>> iterator() {
        return this.sets.entrySet().iterator();
    }
}

