/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.json.JSONArray;

public class Indexer<T>
implements Serializable {
    private AtomicInteger counter = new AtomicInteger(0);
    private HashMap<Integer, T> values = new HashMap();
    private HashMap<T, Integer> seen = new HashMap();
    private T defaultValue;

    public Indexer() {
        this(null);
    }

    public Indexer(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int get(T value) {
        return this.seen.getOrDefault(value, -1);
    }

    public T get(int index) {
        if (this.values.containsKey(index)) {
            return this.values.get(index);
        }
        return this.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(T value) {
        if (this.seen.containsKey(value)) {
            return this.seen.get(value);
        }
        Indexer indexer = this;
        synchronized (indexer) {
            if (this.seen.containsKey(value)) {
                return this.seen.get(value);
            }
            int newIndex = this.counter.getAndIncrement();
            this.seen.put(value, newIndex);
            this.values.put(newIndex, value);
            return newIndex;
        }
    }

    public List<T> getIndexedList() {
        ArrayList<T> rtrn = new ArrayList<T>();
        int size = this.values.size();
        for (int i = 0; i < size; ++i) {
            rtrn.add(this.values.get(i));
        }
        return Collections.unmodifiableList(rtrn);
    }

    public boolean contains(T value) {
        return this.seen.containsKey(value);
    }

    public int size() {
        return this.values.size();
    }

    public Set<Integer> getIndexSet() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    public void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.defaultValue);
        stream.writeObject(this.getIndexedList());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.defaultValue = stream.readObject();
        List indexedList = (List)stream.readObject();
        for (int i = 0; i < indexedList.size(); ++i) {
            Object value = indexedList.get(i);
            this.values.put(i, value);
            this.seen.put(value, i);
        }
        this.counter.set(indexedList.size());
    }

    private void readObjectNoData() throws ObjectStreamException {
    }

    public static <T> Indexer<T> fromList(List<T> list) {
        Indexer<T> rtrn = new Indexer<T>();
        for (int i = 0; i < list.size(); ++i) {
            rtrn.add(list.get(i));
        }
        return rtrn;
    }

    public static Indexer<String> fromJSONArray(JSONArray list) {
        Indexer<String> rtrn = new Indexer<String>();
        for (int i = 0; i < list.length(); ++i) {
            rtrn.add(list.getString(i));
        }
        return rtrn;
    }

    public void forEach(Consumer<T> consumer) {
        this.seen.keySet().forEach(consumer);
    }

    public void forEach(BiConsumer<Integer, T> consumer) {
        this.values.forEach(consumer::accept);
    }
}

