/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup;

import io.hyperfoil.tools.yaup.HashedLists;
import io.hyperfoil.tools.yaup.PopulatePatternException;
import io.hyperfoil.tools.yaup.json.Json;
import io.hyperfoil.tools.yaup.json.ValueConverter;
import io.hyperfoil.tools.yaup.json.graaljs.JsException;
import io.hyperfoil.tools.yaup.json.graaljs.JsFetch;
import io.hyperfoil.tools.yaup.json.graaljs.JsonProxy;
import io.hyperfoil.tools.yaup.json.graaljs.JsonProxyObject;
import io.hyperfoil.tools.yaup.json.graaljs.MapProxyWrapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;

public class StringUtil {
    public static final String MINUTES = "m";
    public static final String SECONDS = "s";
    public static final String MILLISECONDS = "ms";
    public static final String HOURS = "h";
    private static final Pattern timeUnitPattern = Pattern.compile("(?<amount>\\d+)(?<unit>ms|m|s|h)?");
    public static final String PATTERN_PREFIX = "${{";
    public static final String PATTERN_JAVASCRIPT_PREFIX = "=";
    public static final String PATTERN_SUFFIX = "}}";
    public static final String PATTERN_DEFAULT_SEPARATOR = ":";
    private static final Pattern NAMED_CAPTURE = Pattern.compile("\\(\\?<([^>]+)>");
    private static final String VALID_REGEX_NAME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static List<String> getCaptureNames(String pattern) {
        Matcher fieldMatcher = NAMED_CAPTURE.matcher(pattern);
        LinkedList<String> names = new LinkedList<String>();
        while (fieldMatcher.find()) {
            names.add(fieldMatcher.group(1));
        }
        return names;
    }

    public static Object jsEval(String js, Object ... args) {
        return StringUtil.jsEval(js, Collections.EMPTY_LIST, args);
    }

    public static Object jsEval(String js, Collection<String> evals, Object ... args) {
        return StringUtil.jsEval(js, Collections.EMPTY_MAP, evals, args);
    }

    public static Object jsEval(String js, Map globals, Collection<String> evals, Object ... args) {
        Object rtrn = null;
        try (Engine engine = Engine.newBuilder().option("engine.WarnInterpreterOnly", "false").build();
             Context context = Context.newBuilder((String[])new String[]{"js"}).engine(engine).allowAllAccess(true).allowHostAccess(HostAccess.ALL).allowIO(true).allowExperimentalOptions(true).option("js.foreign-object-prototype", "true").option("js.global-property", "true").build();){
            context.enter();
            try {
                Object converted;
                if (!globals.isEmpty()) {
                    context.getBindings("js").putMember("__yaupGlobal", (Object)new MapProxyWrapper(globals));
                    context.eval("js", (CharSequence)"Object.setPrototypeOf(globalThis, new Proxy(Object.prototype, {\n    has(target, key) {\n        return  __yaupGlobal.containsKey(key) || key in target;\n    },\n    get(target, key, receiver) {\n        if (__yaupGlobal.containsKey(key)){ return __yaupGlobal.get(key); }\n        else { return Reflect.get( target, key, receiver); }\n    }\n}))");
                }
                evals.forEach(s -> {
                    try {
                        context.eval("js", (CharSequence)s);
                    }
                    catch (PolyglotException pge) {
                        throw new RuntimeException("failed to evaluate " + s + " preparing for js = " + js, pge);
                    }
                });
                context.getBindings("js").putMember("_http", (Object)new JsFetch(null, null));
                Source fetchSource = Source.newBuilder((String)"js", (CharSequence)"fetch = async (url,options)=>new Promise(new (Java.type('io.hyperfoil.tools.yaup.json.graaljs.JsFetch'))(url,options));", (String)"fakeFetch").build();
                context.eval(fetchSource);
                context.eval("js", (CharSequence)"global.btoa = (str)=>Java.type('io.hyperfoil.tools.yaup.json.graaljs.JsFetch').btoa(str)");
                context.eval("js", (CharSequence)"global.atob = (str)=>Java.type('io.hyperfoil.tools.yaup.json.graaljs.JsFetch').atob(str)");
                context.eval(Source.newBuilder((String)"js", (CharSequence)((Stream)new BufferedReader(new InputStreamReader(StringUtil.class.getClassLoader().getResourceAsStream("jsonpath.js"))).lines().parallel()).collect(Collectors.joining("\n")), (String)"jsonpath.js").build());
                context.eval(Source.newBuilder((String)"js", (CharSequence)((Stream)new BufferedReader(new InputStreamReader(StringUtil.class.getClassLoader().getResourceAsStream("luxon.min.js"))).lines().parallel()).collect(Collectors.joining("\n")), (String)"luxon.min.js").build());
                context.getBindings("js").putMember("isInstanceLike", (Object)new JsonProxyObject.InstanceCheck());
                context.eval("js", (CharSequence)"Object.defineProperty(Object,Symbol.hasInstance, {\n  value: function myinstanceof(obj) {\n    return isInstanceLike(obj);\n  }\n});");
                Value matcher = null;
                try {
                    matcher = context.eval("js", (CharSequence)js);
                }
                catch (PolyglotException pge) {
                    rtrn = pge;
                    try {
                        matcher = context.eval("js", (CharSequence)("async  (async () => " + StringUtil.quote(js) + ")()"));
                    }
                    catch (PolyglotException pge2) {
                        Value factory = context.eval("js", (CharSequence)("new Function('return '+" + StringUtil.quote(js) + ")"));
                        matcher = factory.execute(new Object[0]);
                    }
                }
                if (matcher == null) {
                    throw new JsException("failed to evaluate result with arguments = " + args, js);
                }
                if (matcher.canExecute() && args != null && args.length > 0) {
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i] == null || !(args[i] instanceof Json)) continue;
                        args[i] = JsonProxy.create((Json)args[i]);
                    }
                    Value result = matcher.execute(args);
                    if (result != null) {
                        matcher = result;
                    }
                }
                if (matcher.toString().startsWith("Promise{[")) {
                    final ArrayList resolved = new ArrayList();
                    final ArrayList rejected = new ArrayList();
                    Value invokeRtrn = matcher.invokeMember("then", new Object[]{new ProxyExecutable(){

                        public Object execute(Value ... arguments) {
                            resolved.addAll(Arrays.asList(arguments));
                            return arguments;
                        }
                    }, new ProxyExecutable(){

                        public Object execute(Value ... arguments) {
                            rejected.addAll(Arrays.asList(arguments));
                            return arguments;
                        }
                    }});
                    if (invokeRtrn instanceof Value) {
                        Value value = invokeRtrn;
                    }
                    if (rejected.size() > 0) {
                        matcher = (Value)rejected.get(0);
                    } else if (resolved.size() == 1) {
                        matcher = (Value)resolved.get(0);
                    }
                }
                rtrn = (converted = ValueConverter.convert(matcher)) instanceof JsonProxyObject ? ((JsonProxyObject)converted).getJson() : (converted instanceof Exception ? new JsException(((Exception)converted).getMessage(), js, (Throwable)converted) : (converted instanceof Json ? (Json)converted : converted));
            }
            catch (PolyglotException pe) {
                throw new JsException(pe.getMessage(), js, pe);
            }
            catch (Throwable e) {
                throw new JsException(e.getMessage(), js, e);
            }
            finally {
                context.leave();
            }
        }
        return rtrn;
    }

    public static List<String> getPatternNames(String pattern, Map<Object, Object> map) throws PopulatePatternException {
        return StringUtil.getPatternNames(pattern, map, PATTERN_PREFIX, PATTERN_DEFAULT_SEPARATOR, PATTERN_SUFFIX, PATTERN_JAVASCRIPT_PREFIX);
    }

    public static List<String> getPatternNames(String pattern, Map<Object, Object> map, String prefix, String separator, String suffix, String javascriptPrefix) throws PopulatePatternException {
        UnclearableSet<String> rtrn = new UnclearableSet<String>();
        StringUtil.populatePattern(pattern, new HasItAllMap<Object, Object>(map, "_"), prefix, separator, suffix, javascriptPrefix, rtrn, true);
        return new ArrayList<String>(rtrn);
    }

    public static String populatePattern(String pattern, Map<Object, Object> map) throws PopulatePatternException {
        return StringUtil.populatePattern(pattern, map, Collections.emptyList(), PATTERN_PREFIX, PATTERN_DEFAULT_SEPARATOR, PATTERN_SUFFIX, PATTERN_JAVASCRIPT_PREFIX);
    }

    public static String populatePattern(String pattern, Map<Object, Object> map, String prefix, String separator, String suffix, String javascriptPrefix) throws PopulatePatternException {
        HashSet<String> seen = new HashSet<String>();
        return StringUtil.populatePattern(pattern, map, Collections.emptyList(), prefix, separator, suffix, javascriptPrefix, seen, false);
    }

    public static String populatePattern(String pattern, Map<Object, Object> map, Collection<String> evals, String prefix, String separator, String suffix, String javascriptPrefix) throws PopulatePatternException {
        HashSet<String> seen = new HashSet<String>();
        return StringUtil.populatePattern(pattern, map, evals, prefix, separator, suffix, javascriptPrefix, seen, false);
    }

    private static String populatePattern(String pattern, Map<Object, Object> map, String prefix, String separator, String suffix, String javascriptPrefix, Set<String> seen, boolean fullScan) throws PopulatePatternException {
        return StringUtil.populatePattern(pattern, map, Collections.emptyList(), prefix, separator, suffix, javascriptPrefix, seen, fullScan);
    }

    private static String populatePattern(String pattern, Map<Object, Object> map, Collection<String> evals, String prefix, String separator, String suffix, String javascriptPrefix, Set<String> seen, boolean fullScan) throws PopulatePatternException {
        boolean replaced;
        boolean replaceMissing = false;
        PopulatePatternException toThrow = null;
        Throwable jsEvalException = null;
        if (map == null) {
            map = new HashMap<Object, Object>();
        }
        String rtrn = pattern;
        int skip = 0;
        int seenIndex = -1;
        do {
            String defaultValue;
            replaced = false;
            int nameStart = -1;
            int nameEnd = -1;
            int defaultStart = -1;
            int defaultEnd = -1;
            int count = 0;
            char quoteChar = '\"';
            boolean inQuote = false;
            for (int i = skip; i < rtrn.length(); ++i) {
                char targetChar = rtrn.charAt(i);
                if (inQuote) {
                    if (rtrn.charAt(i) == quoteChar) {
                        inQuote = false;
                    }
                } else if (count > 0 && (rtrn.charAt(i) == '\"' || rtrn.charAt(i) == '\'' || rtrn.charAt(i) == '`')) {
                    quoteChar = rtrn.charAt(i);
                    inQuote = true;
                }
                if (rtrn.startsWith(prefix, i)) {
                    if (count == 0) {
                        nameStart = i;
                    }
                    ++count;
                    i += prefix.length() - 1;
                    continue;
                }
                if (rtrn.startsWith(separator, i) && !inQuote) {
                    if (count != 1) continue;
                    nameEnd = i;
                    defaultStart = i;
                    continue;
                }
                if (!rtrn.startsWith(suffix, i) || count <= 0) continue;
                if (--count == 0) {
                    if (nameEnd > -1 && defaultStart > -1) {
                        defaultEnd = i;
                    } else {
                        nameEnd = i;
                    }
                    i = rtrn.length();
                }
                i += suffix.length() - 1;
            }
            if (nameStart <= -1 || count != 0) continue;
            replaced = true;
            if (nameStart > seenIndex && seenIndex >= 0) {
                seen.clear();
            }
            String namePattern = rtrn.substring(nameStart + prefix.length(), nameEnd).trim();
            String name = StringUtil.populatePattern(namePattern, map, evals, prefix, separator, suffix, javascriptPrefix, seen, fullScan);
            String string = defaultValue = defaultStart > -1 ? rtrn.substring(defaultStart + separator.length(), defaultEnd) : null;
            if (defaultValue != null && fullScan) {
                defaultValue = StringUtil.populatePattern(defaultValue, map, evals, prefix, separator, suffix, javascriptPrefix, seen, fullScan);
            }
            boolean isJavascript = false;
            if (name.startsWith(javascriptPrefix)) {
                isJavascript = true;
                name = name.substring(javascriptPrefix.length());
            }
            String replacement = null;
            if (!isJavascript && map.containsKey(name) && map.get(name) != null && !map.get(name).toString().isEmpty()) {
                if (seen.contains(name)) {
                    throw new PopulatePatternException("Circular pattern reference " + name + "\n  pattern=" + pattern + "\n  nameStart=" + nameStart + "\n  seenIndex=" + seenIndex + "\n  seen=" + seen + "\n  rtrn=" + rtrn, rtrn);
                }
                replacement = map.get(name).toString();
                seen.add(name);
            } else if (isJavascript || StringUtil.findAny(name, "()/*^+-") > -1 || name.matches(".*?\\.\\.\\.\\s*[{\\[].*")) {
                Object value = null;
                try {
                    Object evalResult = StringUtil.jsEval(name, map, evals, new Object[0]);
                    if (evalResult != null) {
                        replacement = evalResult.toString();
                    }
                }
                catch (JsException ise) {
                    jsEvalException = ise;
                }
            }
            if (replacement == null || "".equals(replacement)) {
                replacement = defaultValue != null ? defaultValue : (map.containsKey(name) && map.get(name) != null ? map.get(name).toString() : null);
            }
            int end = Math.max(nameEnd, defaultEnd) + PATTERN_SUFFIX.length();
            if (replacement == null) {
                if (toThrow == null) {
                    toThrow = new PopulatePatternException("Unable to resolve replacement for: " + name + " in " + pattern + " Either state variable has not been set, or JS expression is invalid", rtrn);
                }
                skip = end;
                seenIndex = end;
                continue;
            }
            rtrn = rtrn.substring(0, nameStart) + replacement + rtrn.substring(end);
            seenIndex = nameStart + replacement.length() - 1;
        } while (replaced);
        if (toThrow != null) {
            if (jsEvalException != null) {
                throw new PopulatePatternException("Failed to evaluate JS: " + jsEvalException.getMessage(), rtrn, true);
            }
            toThrow.setResult(rtrn);
            throw toThrow;
        }
        return rtrn;
    }

    public static HashedLists<String, String> groupCommonPrefixes(List<String> inputs) {
        return StringUtil.groupCommonPrefixes(inputs, StringUtil::commonPrefixLength);
    }

    public static HashedLists<String, String> groupCommonPrefixes(List<String> inputs, BiFunction<String, String, Integer> prefixMeasurer) {
        inputs.sort(String.CASE_INSENSITIVE_ORDER);
        HashedLists<String, String> rtrn = new HashedLists<String, String>();
        for (int i = 0; i < inputs.size(); ++i) {
            String current = inputs.get(i);
            String previous = i > 0 ? inputs.get(i - 1) : "";
            String next = i < inputs.size() - 1 ? inputs.get(i + 1) : "";
            int commonPreviousLength = prefixMeasurer.apply(current, previous);
            int commonNextLength = prefixMeasurer.apply(current, next);
            if (commonPreviousLength == 0 && commonNextLength == 0) {
                rtrn.put(current, current);
                continue;
            }
            if (commonPreviousLength > commonNextLength) {
                rtrn.put(current.substring(0, commonPreviousLength), current);
                continue;
            }
            rtrn.put(current.substring(0, commonNextLength), current);
        }
        return rtrn;
    }

    public static long parseToMs(String amount) {
        amount = amount.replaceAll("_", "");
        long rtrn = 0L;
        Matcher m = timeUnitPattern.matcher(amount);
        while (m.find()) {
            TimeUnit timeUnit;
            String unit;
            long toAdd = Long.parseLong(m.group("amount"));
            switch (unit = m.group("unit") == null ? "" : m.group("unit")) {
                case "h": {
                    timeUnit = TimeUnit.HOURS;
                    break;
                }
                case "m": {
                    timeUnit = TimeUnit.MINUTES;
                    break;
                }
                case "s": {
                    timeUnit = TimeUnit.SECONDS;
                    break;
                }
                default: {
                    timeUnit = TimeUnit.MILLISECONDS;
                }
            }
            long increment = timeUnit.toMillis(toAdd);
            rtrn += increment;
        }
        return rtrn;
    }

    public static long parseKMG(String kmg) {
        Matcher m = Pattern.compile("(?<number>\\d+\\.?\\d*)\\s?(?<kmg>[kmgtpezyKMGTPEZY]*)(?<bB>[bB]*)").matcher(kmg);
        if (m.matches()) {
            double mult = 1.0;
            switch (m.group("kmg").toUpperCase()) {
                case "Y": {
                    mult *= 1024.0;
                }
                case "Z": {
                    mult *= 1024.0;
                }
                case "E": {
                    mult *= 1024.0;
                }
                case "P": {
                    mult *= 1024.0;
                }
                case "T": {
                    mult *= 1024.0;
                }
                case "G": {
                    mult *= 1024.0;
                }
                case "M": {
                    mult *= 1024.0;
                }
                case "K": {
                    mult *= 1024.0;
                }
                case "B": {
                    mult *= 1.0;
                }
            }
            double bytes = m.group("bB").equals("b") ? 0.125 : 1.0;
            double v = Double.parseDouble(m.group("number")) * mult * bytes;
            return (long)v;
        }
        if (kmg.equals("-")) {
            return 0L;
        }
        throw new IllegalArgumentException(kmg + " does not match expected pattern for KMG");
    }

    public static <T extends Enum<?>> T getEnum(String input, Class<T> clazz) {
        return StringUtil.getEnum(input, clazz, null);
    }

    public static <T extends Enum<?>> T getEnum(String input, Class<T> clazz, T defaultValue) {
        if (input == null || input.isEmpty()) {
            return defaultValue;
        }
        input = input.replaceAll("[\\-_]", "");
        for (Enum t : (Enum[])clazz.getEnumConstants()) {
            if (!input.equalsIgnoreCase(t.name())) continue;
            return (T)t;
        }
        return defaultValue;
    }

    private static char randNameChar() {
        return VALID_REGEX_NAME_CHARS.charAt(ThreadLocalRandom.current().nextInt(0, VALID_REGEX_NAME_CHARS.length()));
    }

    public static String greatestCommonSubstring(String first, String second) {
        int firstLength = first.length();
        int secondLength = second.length();
        int maxIndex = -1;
        int max = 0;
        int[][] dp = new int[firstLength][secondLength];
        for (int f = 0; f < firstLength; ++f) {
            for (int s = 0; s < secondLength; ++s) {
                if (first.charAt(f) != second.charAt(s)) continue;
                dp[f][s] = f == 0 || s == 0 ? 1 : dp[f - 1][s - 1] + 1;
                if (max >= dp[f][s]) continue;
                max = dp[f][s];
                maxIndex = f;
            }
        }
        if (max > 0) {
            return first.substring(maxIndex - max + 1, maxIndex + 1);
        }
        return "";
    }

    public static int commonPrefixLength(String a, String b) {
        int rtrn;
        for (rtrn = 0; a.length() > rtrn && b.length() > rtrn && a.charAt(rtrn) == b.charAt(rtrn); ++rtrn) {
        }
        return rtrn;
    }

    public static String generateRegexNameSubstitute(String input) {
        if (input == null) {
            return "";
        }
        StringBuilder rtrn = new StringBuilder();
        while (input.contains(rtrn.toString())) {
            rtrn.append(StringUtil.randNameChar());
        }
        return rtrn.toString();
    }

    public static String escapeBash(String input) {
        if (input == null) {
            return "";
        }
        String rtrn = input;
        rtrn = rtrn.replaceAll("\u001b(?<!\\\\\u001b)", "\\\\\u001b");
        rtrn = rtrn.replaceAll("\r", "\\\\r");
        rtrn = rtrn.replaceAll("\n", "\\\\n");
        rtrn = rtrn.replaceAll("\t", "\\\\t");
        return rtrn;
    }

    public static String escapeRegex(String input) {
        if (input == null) {
            return "";
        }
        String rtrn = input;
        rtrn = rtrn.replaceAll("\\.(?<!\\\\\\.)", "\\\\.");
        rtrn = rtrn.replaceAll("\\*(?<!\\\\\\.)", "\\\\*");
        rtrn = rtrn.replaceAll("\\+(?<!\\\\\\+)", "\\\\+");
        rtrn = rtrn.replaceAll("\\?(?<!\\\\\\?)", "\\\\?");
        rtrn = rtrn.replaceAll("\\^(?<!\\\\\\^)", "\\\\^");
        rtrn = rtrn.replaceAll("\\$(?<!\\\\\\$)", "\\\\\\$");
        return rtrn;
    }

    public static int countOccurances(String target, String toFind) {
        int count = 0;
        int index = 0 - toFind.length();
        while ((index = target.indexOf(toFind, index + toFind.length())) > -1) {
            ++count;
        }
        return count;
    }

    public static String toHms(long duration) {
        long ms = duration % 1000L;
        duration /= 1000L;
        if (ms > 0L) {
            return "" + duration;
        }
        String rtrn = duration % 60L + SECONDS;
        if ((duration /= 60L) == 0L) {
            return rtrn;
        }
        rtrn = duration % 60L + MINUTES + rtrn;
        if ((duration /= 60L) == 0L) {
            return rtrn;
        }
        rtrn = duration % 24L + HOURS + rtrn;
        if ((duration /= 24L) == 0L) {
            return rtrn;
        }
        rtrn = duration + "d" + rtrn;
        return rtrn;
    }

    public static String durationToString(long duration) {
        long _ms = duration % 1000L;
        String rtrn = String.format("%02d.%03d", (duration /= 1000L) % 60L, _ms);
        if ((duration /= 60L) == 0L) {
            return rtrn;
        }
        rtrn = String.format("%02d:%s", duration % 60L, rtrn);
        if ((duration /= 60L) == 0L) {
            return rtrn;
        }
        rtrn = String.format("%02d:%s", duration % 24L, rtrn);
        if ((duration /= 24L) == 0L) {
            return rtrn;
        }
        rtrn = String.format("%dd %s", duration % 7L, rtrn);
        if ((duration /= 7L) == 0L) {
            return rtrn;
        }
        rtrn = String.format("%dw %s", duration % 52L, rtrn);
        return rtrn;
    }

    public static int editDistance(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return -1;
        }
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        int[] costs = new int[s2.length() + 1];
        for (int i = 0; i <= s1.length(); ++i) {
            int lastValue = i;
            for (int j = 0; j <= s2.length(); ++j) {
                if (i == 0) {
                    costs[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int newValue = costs[j - 1];
                if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                    newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                }
                costs[j - 1] = lastValue;
                lastValue = newValue;
            }
            if (i <= 0) continue;
            costs[s2.length()] = lastValue;
        }
        return costs[s2.length()];
    }

    public static int findAny(String input, String toFind) {
        int index = -1;
        HashSet<Character> chars = new HashSet<Character>();
        boolean stop = false;
        if (toFind != null) {
            char[] charArray = toFind.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                chars.add(Character.valueOf(charArray[i]));
            }
        }
        while (index < input.length() && !stop) {
            if (++index >= input.length()) {
                stop = true;
                continue;
            }
            if (!chars.contains(Character.valueOf(input.charAt(index)))) continue;
            stop = true;
        }
        if (index >= input.length()) {
            index = -1;
        }
        return index;
    }

    public static String findNotQuoted(String input, String toFind) {
        if (input == null) {
            return "";
        }
        if (toFind == null) {
            return input;
        }
        int index = -1;
        boolean stop = false;
        boolean quoted = false;
        char quoteChar = '\"';
        HashSet<Character> chars = new HashSet<Character>();
        char[] charArray = toFind.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            chars.add(Character.valueOf(charArray[i]));
        }
        while (index < input.length() && !stop) {
            if (++index >= input.length()) {
                stop = true;
                continue;
            }
            if (!quoted && chars.contains(Character.valueOf(input.charAt(index)))) {
                stop = true;
                continue;
            }
            if ('\"' != input.charAt(index) && '\'' != input.charAt(index)) continue;
            if (!quoted) {
                quoteChar = input.charAt(index);
                quoted = true;
                continue;
            }
            if (quoteChar != input.charAt(index) || index > 0 && '/' == input.charAt(index - 1)) continue;
            quoted = false;
        }
        return input.substring(0, index);
    }

    public static String trimIndent(String input) {
        return input.replaceAll("^\\s*", "");
    }

    public static String trimTrailing(String input) {
        return input.replaceAll("\\s*$", "");
    }

    public static String removeSpace(String input) {
        return input.replaceAll("\\s+", "");
    }

    public static boolean isJsFnLike(String input) {
        return input != null && !input.isEmpty() && (input.trim().matches("^\\([^\\)]*\\)\\s*=>.*") || input.trim().startsWith("function") && input.trim().endsWith("}"));
    }

    public static boolean isQuoted(String value) {
        if (value == null) {
            return false;
        }
        return value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'");
    }

    public static String quote(String value) {
        return StringUtil.quote(value, "\"");
    }

    public static String quote(String value, String quoteMark) {
        if (value == null) {
            value = "";
        }
        if (StringUtil.isQuoted(value)) {
            return value;
        }
        return quoteMark + value.replaceAll("" + quoteMark + "(?<!\\\\" + quoteMark + ")", "\\\\" + quoteMark + "") + quoteMark;
    }

    public static String removeQuotes(String value) {
        if (value == null) {
            return null;
        }
        String rtrn = value;
        if (StringUtil.isQuoted(value)) {
            rtrn = value.substring(1, value.length() - 1);
        }
        return rtrn;
    }

    public static int indexNotMatching(String input, String toFind, int start) {
        int index = start;
        boolean stop = false;
        HashSet<Character> chars = new HashSet<Character>();
        if (toFind != null) {
            char[] charArray = toFind.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                chars.add(Character.valueOf(charArray[i]));
            }
        }
        while (!stop && index < input.length() && chars.contains(Character.valueOf(input.charAt(index)))) {
            ++index;
        }
        return index;
    }

    public static class HasItAllMap<K, V>
    implements Map<K, V> {
        private final Map<K, V> map;
        private final V value;

        public HasItAllMap(Map<K, V> map, V value) {
            this.map = map;
            this.value = value;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object o) {
            return true;
        }

        @Override
        public boolean containsValue(Object o) {
            return true;
        }

        @Override
        public V get(Object o) {
            return this.map.containsKey(o) ? this.map.get(o) : this.value;
        }

        @Override
        public V put(Object o, Object o2) {
            return null;
        }

        @Override
        public V remove(Object o) {
            return null;
        }

        @Override
        public void putAll(Map map) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.map.entrySet();
        }
    }

    public static class UnclearableSet<V>
    implements Set<V> {
        private final Set<V> set;

        public UnclearableSet() {
            this(new HashSet());
        }

        public UnclearableSet(Set<V> set) {
            this.set = set;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public Iterator<V> iterator() {
            return this.set.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            return this.set.toArray(ts);
        }

        @Override
        public boolean add(V v) {
            return this.set.add(v);
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.set.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            return this.set.addAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.set.retainAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return false;
        }

        @Override
        public void clear() {
        }
    }
}

