/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.file;

import io.hyperfoil.tools.yaup.file.FileUtility;
import io.hyperfoil.tools.yaup.file.ImmutableFile;
import java.util.LinkedList;
import java.util.List;

public class ArchiveEntryFile
extends ImmutableFile {
    private String pathName;
    private String entryPath;
    private boolean isDirectory = false;
    private boolean exists = false;
    private List<String> children;

    public ArchiveEntryFile(String pathName) {
        super(FileUtility.getArchiveFilePath(pathName));
        this.pathName = pathName;
        this.entryPath = FileUtility.getArchiveEntrySubPath(pathName);
        this.isDirectory = this.entryPath.endsWith("/");
        this.children = new LinkedList<String>();
        this.populateChildren();
    }

    private void populateChildren() {
        List<String> entries = FileUtility.getArchiveEntries(this.pathName);
        for (String entry : entries) {
            if (entry.startsWith(this.entryPath) && this.isDirectory) {
                this.children.add(entry);
                this.exists = true;
            }
            if (!entry.equals(this.entryPath) || this.isDirectory) continue;
            this.exists = true;
        }
    }
}

