/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.json;

import io.hyperfoil.tools.yaup.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.Draft;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.JsonSchemaOptions;
import io.vertx.json.schema.OutputUnit;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.Validator;

public class JsonValidator {
    private Json schemaJson;
    private Validator validator;

    public JsonValidator(Json schema) {
        this.schemaJson = schema;
        JsonObject object = new JsonObject(this.schemaJson.toString());
        JsonSchema jsonSchema = JsonSchema.of((JsonObject)object);
        this.validator = Validator.create((JsonSchema)jsonSchema, (JsonSchemaOptions)new JsonSchemaOptions().setDraft(Draft.DRAFT202012).setBaseUri("https://hyperfoil.io"));
    }

    public Json validate(Json input) {
        Json rtrn = new Json();
        if (input == null) {
            return rtrn;
        }
        try {
            OutputUnit outputUnit = this.validator.validate((Object)new JsonObject(input.toString()));
            if (!outputUnit.getValid().booleanValue()) {
                outputUnit.getErrors().forEach(e -> rtrn.add(Json.fromString(e.toString())));
            }
        }
        catch (SchemaException se) {
            rtrn.add(se.getMessage());
        }
        return rtrn;
    }

    public Json getSchema() {
        return this.schemaJson;
    }
}

