/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.json;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.spi.json.JsonProvider;
import io.hyperfoil.tools.yaup.json.Json;
import java.io.InputStream;
import java.util.Collection;
import java.util.Scanner;
import java.util.stream.Collectors;

public class YaupJsonProvider
implements JsonProvider {
    public Object parse(String s) throws InvalidJsonException {
        return Json.fromString(s);
    }

    public Object parse(InputStream inputStream, String s) throws InvalidJsonException {
        Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");
        String result = scanner.hasNext() ? scanner.next() : "";
        return Json.fromString(result);
    }

    public String toJson(Object o) {
        return o instanceof Json ? ((Json)o).toString() : "";
    }

    public Object createArray() {
        return new Json(true);
    }

    public Object createMap() {
        return new Json(false);
    }

    public boolean isArray(Object o) {
        return o != null && o instanceof Json && ((Json)o).isArray();
    }

    public int length(Object o) {
        if (o instanceof Json) {
            return ((Json)o).size();
        }
        if (o instanceof String) {
            return ((String)o).length();
        }
        throw new JsonPathException("cannot get length of " + o);
    }

    public Iterable<?> toIterable(Object o) {
        if (o instanceof Json && ((Json)o).isArray()) {
            return ((Json)o).values();
        }
        throw new JsonPathException("cannot iterate over " + o);
    }

    public Collection<String> getPropertyKeys(Object o) {
        if (this.isMap(o)) {
            return ((Json)o).keys().stream().map(Object::toString).collect(Collectors.toList());
        }
        throw new JsonPathException("cannot get keys of " + o);
    }

    public Object getArrayIndex(Object o, int i) {
        return o instanceof Json ? ((Json)o).get(i) : JsonProvider.UNDEFINED;
    }

    public Object getArrayIndex(Object o, int i, boolean b) {
        return this.getArrayIndex(o, i);
    }

    public void setArrayIndex(Object o, int i, Object o1) {
        Json json;
        if (o instanceof Json && (json = (Json)o).isArray()) {
            while (json.size() <= i) {
                json.add(new Json(false));
            }
            json.set(i, o1);
        }
    }

    public Object getMapValue(Object o, String s) {
        return o instanceof Json && ((Json)o).has(s) ? ((Json)o).get(s) : JsonProvider.UNDEFINED;
    }

    public void setProperty(Object o, Object o1, Object o2) {
        if (o instanceof Json) {
            ((Json)o).set(o1, o2);
        }
    }

    public void removeProperty(Object o, Object o1) {
        if (o instanceof Json) {
            ((Json)o).remove(o1);
        }
    }

    public boolean isMap(Object o) {
        return o != null && o instanceof Json && !((Json)o).isArray();
    }

    public Object unwrap(Object o) {
        return o;
    }

    static {
        System.setProperty("com.jayway.jsonpath.internal.path.CompiledPath.level", "ERROR");
    }
}

