/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.json.graaljs;

import io.hyperfoil.tools.yaup.json.Json;
import io.hyperfoil.tools.yaup.json.graaljs.JsException;
import io.hyperfoil.tools.yaup.json.graaljs.JsPromiseExecutor;
import io.hyperfoil.tools.yaup.json.graaljs.JsThenable;
import io.hyperfoil.tools.yaup.json.graaljs.JsonProxy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;

public class JsFetch
implements JsThenable,
JsPromiseExecutor {
    public static final Json DEFAULT_OPTIONS = Json.fromString("{\"method\":\"GET\",\"mode\":\"cors\",\"cache\":\"no-cache\",\"credentials\":\"same-origin\",\"headers\":{    \"Content-Type\":\"application/json\"},\"redirect\":\"follow\",\"referrer\":\"no-referrer\",\"body\":\"\"}", null, true);
    private Value url;
    private Value options;

    public JsFetch(Value url, Value options) {
        this.url = url;
        this.options = options;
    }

    @Override
    @HostAccess.Export
    public void onPromiseCreation(Value onResolve, Value onReject) {
        this.then(onResolve, onReject);
    }

    @Override
    @HostAccess.Export
    public void then(Value onResolve, Value onReject) {
        block6: {
            try {
                Object rtrn = this.jsApply(this.url, this.options);
                if (onResolve.hasMember("then")) {
                    onResolve.invokeMember("then", new Object[]{rtrn});
                } else if (onResolve.canExecute()) {
                    onResolve.execute(new Object[]{rtrn});
                }
            }
            catch (Exception e) {
                if (onReject.hasMember("then")) {
                    onReject.invokeMember("then", new Object[]{e.getMessage()});
                }
                if (!onReject.canExecute()) break block6;
                onReject.execute(new Object[]{e.getMessage()});
            }
        }
    }

    @HostAccess.Export
    public Object jsApply(Value url, Value options) {
        if (url.isString()) {
            Json optionsJson;
            String urlString = url.asString();
            Object v = this.apply(urlString, optionsJson = options == null ? new Json(false) : Json.fromGraalvm(options));
            if (v instanceof Json) {
                v = JsonProxy.create((Json)v);
            }
            return v;
        }
        return "ERROR url=" + url + " options=" + options;
    }

    public Object apply(String url, Json options) {
        if (options == null) {
            options = DEFAULT_OPTIONS;
        } else {
            options.merge(DEFAULT_OPTIONS, false);
        }
        try {
            int status;
            HttpURLConnection con;
            if ("ignore".equals(options.getString("tls", ""))) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                try {
                    SSLContext sc = SSLContext.getInstance("SSL");
                    sc.init(null, trustAllCerts, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
            }
            if ((con = (HttpURLConnection)new URL(url).openConnection()) instanceof HttpsURLConnection) {
                ((HttpsURLConnection)con).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                });
            }
            con.setRequestMethod(options.getString("method", "GET"));
            con.setInstanceFollowRedirects("follow".equals(options.getString("redirect", "")));
            con.setConnectTimeout(30000);
            con.setReadTimeout(30000);
            options.getJson("headers", new Json()).forEach((key, value) -> con.setRequestProperty(key.toString(), value.toString()));
            if ("POST".equals(options.getString("method", "GET"))) {
                con.setDoOutput(true);
                String body = options.get("body") == null ? "" : options.get("body").toString();
                try (OutputStream os = con.getOutputStream();){
                    byte[] input = body.getBytes("utf-8");
                    os.write(input, 0, input.length);
                }
            }
            if (((status = con.getResponseCode()) == 302 || status == 301) && "follow".equals(options.getString("redirect", ""))) {
                String location = con.getHeaderField("Location");
                URL newUrl = new URL(location);
                return this.apply(newUrl.toString(), options);
            }
            InputStreamReader streamReader = null;
            streamReader = status >= 400 ? new InputStreamReader(con.getErrorStream()) : new InputStreamReader(con.getInputStream());
            StringBuffer content = new StringBuffer();
            try (BufferedReader in = new BufferedReader(streamReader);){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Map<String, List<String>> headerFields = con.getHeaderFields();
            Json result = new Json();
            result.set("status", status);
            result.set("statusText", con.getResponseMessage());
            result.set("headers", new Json());
            for (Map.Entry<String, List<String>> entries : con.getHeaderFields().entrySet()) {
                String values = "";
                for (String value2 : entries.getValue()) {
                    values = values + value2 + ",";
                    result.getJson("headers").add(entries.getKey() == null ? "" : entries.getKey(), value2);
                }
            }
            if (headerFields.containsKey("Content-Type") && headerFields.get("Content-Type").contains("application/json") || headerFields.containsKey("content-type") && headerFields.get("content-type").contains("application/json")) {
                result.set("body", Json.fromString(content.toString(), new Json(false)));
            } else {
                result.set("body", content.toString());
            }
            return JsonProxy.create(result);
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            return Json.fromThrowable(e);
        }
        catch (ProtocolException e) {
            e.printStackTrace();
            return Json.fromThrowable(e);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return Json.fromThrowable(e);
        }
        catch (IOException e) {
            throw new JsException(e.getMessage(), "fetch(" + url + "," + options + ")", e);
        }
    }

    public static String btoa(Value input) {
        String str = input == null ? "" : input.asString();
        return new String(Base64.getEncoder().encode(str.getBytes()), Charset.defaultCharset());
    }

    public static String atob(Value input) {
        String str = input == null ? "" : input.asString();
        return new String(Base64.getDecoder().decode(str.getBytes()), Charset.defaultCharset());
    }

    public class MapProxyObject
    implements ProxyObject {
        private final Map<String, Object> map;

        public MapProxyObject(Map<String, Object> map) {
            this.map = map;
        }

        public void putMember(String key, Value value) {
            this.map.put(key, value.isHostObject() ? value.asHostObject() : value);
        }

        public boolean hasMember(String key) {
            return this.map.containsKey(key);
        }

        public Object getMemberKeys() {
            return this.map.keySet().toArray();
        }

        public Object getMember(String key) {
            Object v = this.map.get(key);
            if (v instanceof Map) {
                return new MapProxyObject((Map)v);
            }
            return v;
        }

        public Map<String, Object> getMap() {
            return this.map;
        }
    }
}

