/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.linux;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Local {
    static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DEFAULT_PORT = 22;
    private static final String DEFAULT_SSH = "/usr/bin/ssh";
    private static final String DEFAULT_SSH_ADD = "/usr/bin/ssh-add";
    private static final String DEFAULT_RSYNC = "/usr/bin/rsync";
    private static final String DEFAULT_KNOWN_HOSTS = System.getProperty("user.home") + "/.ssh/known_hosts";
    private static final String DEAULLT_IDENTITY = System.getProperty("user.home") + "/.ssh/id_rsa";
    public static final String DEFAULT_PASSPHRASE = null;
    public static final int DEFAULT_SSH_TIMEOUT = 5;
    private String sshPath = "/usr/bin/ssh";
    private String sshAddPath = "/usr/bin/ssh-add";
    private String rsyncPath = "/usr/bin/rsync";
    private boolean useRsync = true;
    private String identity = DEAULLT_IDENTITY;
    private String knownHosts = DEFAULT_KNOWN_HOSTS;
    private String passphrase = DEFAULT_PASSPHRASE;

    public Local() {
        this(null, null, null);
    }

    public Local(String identity, String knownHosts, String passphrase) {
        this.identity = identity != null && !identity.isEmpty() ? identity : DEAULLT_IDENTITY;
        this.knownHosts = knownHosts != null && !knownHosts.isEmpty() ? knownHosts : DEFAULT_KNOWN_HOSTS;
        this.passphrase = passphrase != null && !passphrase.isEmpty() ? passphrase : DEFAULT_PASSPHRASE;
    }

    public void upload(String localPath, String remotePath, String userName, String hostName) {
        this.upload(localPath, remotePath, userName, hostName, 22);
    }

    public void upload(String localPath, String remotePath, String userName, String hostName, int port) {
        if (localPath == null || localPath.isEmpty() || remotePath == null || remotePath.isEmpty()) {
            return;
        }
        if (this.useRsync) {
            this.rsyncSend(userName, hostName, port, localPath, remotePath);
        } else {
            logger.error("upload currently only supports rsync");
        }
    }

    public void download(String localPath, String remotePath) {
        if (remotePath == null || remotePath.isEmpty() || localPath == null || localPath.isEmpty()) {
            return;
        }
        if (this.useRsync) {
            String userName = "";
            String hostName = "";
            int idx = -1;
            int port = 22;
            if (remotePath.contains(":") && !remotePath.startsWith(":") && !remotePath.endsWith(":")) {
                String possiblePort;
                idx = remotePath.indexOf(":");
                hostName = remotePath.substring(0, idx);
                remotePath = remotePath.substring(idx + 1);
                if (hostName.contains("@")) {
                    idx = hostName.indexOf("@");
                    userName = hostName.substring(0, idx);
                    hostName = hostName.substring(idx + 1);
                }
                if (remotePath.contains(":") && !remotePath.startsWith(":") && (possiblePort = remotePath.substring(0, idx = remotePath.indexOf(":"))).matches("\\d+")) {
                    port = Integer.parseInt(possiblePort);
                    remotePath = remotePath.substring(idx + 1);
                }
                this.download(localPath, remotePath, userName, hostName, port);
            } else {
                logger.error("missing host:path for remote");
            }
        } else {
            logger.error("download currently only support rsync");
        }
    }

    public void download(String localPath, String remotePath, String userName, String hostName) {
        this.download(remotePath, localPath, userName, hostName, 22);
    }

    public void download(String localPath, String remotePath, String userName, String hostName, int port) {
        if (remotePath == null || remotePath.isEmpty() || localPath == null || localPath.isEmpty()) {
            return;
        }
        if (this.useRsync) {
            this.rsyncFetch(userName, hostName, port, localPath, remotePath);
        } else {
            logger.error("download currently only support rsync");
        }
    }

    public void setIdentify(String identify) {
        this.identity = identify;
    }

    public String getIdentity() {
        return this.identity;
    }

    public boolean hasIdentity() {
        return !DEAULLT_IDENTITY.equals(this.getIdentity());
    }

    public String getKnownHosts() {
        return this.knownHosts;
    }

    public boolean hasKnownHosts() {
        return !DEFAULT_KNOWN_HOSTS.endsWith(this.getKnownHosts());
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public boolean hasPassphrase() {
        return DEFAULT_PASSPHRASE != this.getPassphrase();
    }

    private String prepSshCommand(int port) {
        String rtrn = this.sshPath;
        if (this.knownHosts != null && !this.knownHosts.equals(DEFAULT_KNOWN_HOSTS)) {
            rtrn = rtrn + " -o UserKnownHostsFile=" + this.knownHosts + " ";
        }
        if (this.identity != null && !this.identity.equals(DEAULLT_IDENTITY)) {
            rtrn = rtrn + " -i " + this.identity + " ";
        }
        if (this.passphrase != null && !this.passphrase.equals(DEFAULT_PASSPHRASE)) {
            this.storePassphrase(this.identity, this.passphrase);
        }
        if (port != 22) {
            rtrn = rtrn + " -p " + port + " ";
        }
        return rtrn;
    }

    private void storePassphrase(String identity, String passphrase) {
        if (passphrase != DEFAULT_PASSPHRASE) {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(this.sshAddPath, identity);
            try {
                Process p = builder.start();
                InputStream inputStream = p.getInputStream();
                OutputStream outputStream = p.getOutputStream();
                InputStream errorStream = p.getErrorStream();
                outputStream.write(passphrase.getBytes());
                outputStream.flush();
                int result = p.waitFor();
                logger.debug("ssh-add.result = {}", (Object)result);
                String line = null;
                BufferedReader reader = null;
                reader = new BufferedReader(new InputStreamReader(errorStream));
                while ((line = reader.readLine()) != null) {
                    logger.error("  E: {}", (Object)line);
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    logger.trace("  I: {}", (Object)line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void rsync(String from, String to, String args, String sshOpt) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (this.sshPath.equals(sshOpt)) {
            builder.command(this.rsyncPath, args, from, to);
        } else {
            builder.command(this.rsyncPath, args, "-e", sshOpt, from, to);
        }
        try {
            Process p = builder.start();
            InputStream inputStream = p.getInputStream();
            OutputStream outputStream = p.getOutputStream();
            InputStream errorStream = p.getErrorStream();
            int result = p.waitFor();
            String line = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));){
                while ((line = reader.readLine()) != null) {
                    logger.error("  E: {}", (Object)line);
                }
            }
            reader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                while ((line = reader.readLine()) != null) {
                    logger.trace("  I: {}", (Object)line);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void rsyncSend(String userName, String hostName, int port, String localPath, String remotePath) {
        File localFile = new File(localPath);
        if (!localFile.exists()) {
            logger.error("{} does not exist", (Object)localPath);
            return;
        }
        String sshOpt = this.prepSshCommand(port);
        this.rsync(localPath, (userName == null || userName.isEmpty() ? "" : userName + "@") + hostName + ":" + remotePath, "-avzI", sshOpt);
    }

    private void rsyncFetch(String userName, String hostName, int port, String localPath, String remotePath) {
        File localFile = new File(localPath);
        if (!localFile.exists()) {
            if (localFile.isDirectory()) {
                localFile.mkdirs();
            } else {
                localFile.getParentFile().mkdirs();
            }
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        String args = "-avz";
        if (remotePath.contains("./")) {
            logger.trace("rsync enabling relative mode for {}", (Object)remotePath);
            args = args + "R";
        }
        String sshOpts = this.prepSshCommand(port);
        this.rsync((userName == null || userName.isEmpty() ? "" : userName + "@") + (hostName == null || hostName.isEmpty() ? "" : hostName + ":") + remotePath, localPath, args, sshOpts);
    }
}

