/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.time;

import io.hyperfoil.tools.yaup.json.Json;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SystemTimer {
    private static final SystemTimer NULL = new SystemTimer("NULL"){

        @Override
        public SystemTimer start(String name, Json json, boolean parallel) {
            return this;
        }

        @Override
        public boolean isActive() {
            return false;
        }
    };
    private final boolean isParallel;
    private boolean hasParallel;
    private long nanoStart;
    private long milliStart;
    private long nanoStop = -1L;
    private long milliStop = -1L;
    private String name;
    private Json data;
    private SystemTimer parent;
    private List<SystemTimer> children;

    public SystemTimer(String name) {
        this(name, 0L, 0L, false);
    }

    public SystemTimer(String name, long milli, long nano, boolean isParallel) {
        this.name = name;
        this.children = new ArrayList<SystemTimer>();
        this.milliStart = milli;
        this.nanoStart = nano;
        this.isParallel = isParallel;
        this.hasParallel = false;
        this.parent = null;
        this.data = new Json(false);
    }

    public boolean start() {
        return this.start((Json)null);
    }

    public boolean hasParent() {
        return this.parent != null && this.parent != NULL;
    }

    public SystemTimer getParent() {
        return this.parent;
    }

    public boolean start(Json data) {
        if (this.isStopped() || this.isActive()) {
            return false;
        }
        if (data != null) {
            this.data.merge(data);
        }
        this.milliStart = System.currentTimeMillis();
        this.nanoStart = System.nanoTime();
        return true;
    }

    public boolean isStopped() {
        return this.isStarted() && this.milliStop > 0L;
    }

    public boolean isStarted() {
        return this.milliStart > 0L;
    }

    public boolean isActive() {
        return this.isStarted() && !this.isStopped();
    }

    public long getStart() {
        return this.milliStart;
    }

    public long getStop() {
        return this.milliStop;
    }

    public String getName() {
        return this.name;
    }

    public long nanoTime() {
        return this.nanoStop - this.nanoStart;
    }

    public long milliTime() {
        return this.milliStop - this.milliStart;
    }

    public SystemTimer start(String name) {
        return this.start(name, null, false);
    }

    public SystemTimer start(String name, boolean parallel) {
        return this.start(name, null, parallel);
    }

    public SystemTimer start(String name, Json data, boolean parallel) {
        this.hasParallel = this.hasParallel || parallel;
        long milli = System.currentTimeMillis();
        long nano = System.nanoTime();
        if (this.isActive()) {
            if (!parallel) {
                this.stopChildren(milli, nano, null, false);
            }
        } else {
            this.milliStart = milli;
            this.nanoStart = nano;
        }
        milli = System.currentTimeMillis();
        nano = System.nanoTime();
        SystemTimer newTimer = new SystemTimer(name, milli, nano, parallel);
        newTimer.parent = this;
        newTimer.data.merge(data);
        this.children.add(newTimer);
        return newTimer;
    }

    public Json getData() {
        return this.data;
    }

    public void stop() {
        this.stop(null);
    }

    public void stop(Json data) {
        if (this.isActive()) {
            long milli = System.currentTimeMillis();
            long nano = System.nanoTime();
            this.stop(milli, nano, data, true);
        }
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<SystemTimer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    private SystemTimer current() {
        if (!this.children.isEmpty()) {
            return this.children.get(this.children.size() - 1);
        }
        return NULL;
    }

    private void stop(long milliStop, long nanoStop, boolean stopParallel) {
        this.stop(milliStop, nanoStop, null, stopParallel);
    }

    private void stop(long milliStop, long nanoStop, Json data, boolean stopParallel) {
        if (this.isActive() && (stopParallel || !this.isParallel)) {
            this.milliStop = milliStop;
            this.nanoStop = nanoStop;
            this.stopChildren(milliStop, nanoStop, data, stopParallel);
        }
    }

    private void stopChildren(long milliStop, long nanoStop, Json data, boolean stopParallel) {
        for (int counter = this.children.size() - 1; counter >= 0 && (stopParallel && this.hasParallel || this.children.get(counter).isActive()); --counter) {
            this.children.get(counter).stop(milliStop, nanoStop, data, stopParallel);
        }
        if (stopParallel) {
            this.hasParallel = false;
        }
    }

    public Json getJson() {
        Json rtrn = new Json();
        rtrn.set("name", this.getName());
        rtrn.set("start", this.getStart());
        rtrn.set("stop", this.getStop());
        rtrn.set("nanos", this.nanoTime());
        rtrn.set("millis", this.milliTime());
        if (!this.data.isEmpty()) {
            rtrn.set("data", this.data.clone());
        }
        if (this.hasChildren()) {
            Json childrenJson = new Json();
            for (int i = 0; i < this.children.size(); ++i) {
                childrenJson.add(this.children.get(i).getJson());
            }
            rtrn.set("timers", childrenJson);
        }
        return rtrn;
    }
}

