/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.xml.pojo;

import io.hyperfoil.tools.yaup.HashedLists;
import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.file.FileUtility;
import io.hyperfoil.tools.yaup.json.Json;
import io.hyperfoil.tools.yaup.xml.XmlOperation;
import io.hyperfoil.tools.yaup.xml.pojo.XmlPath;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class Xml {
    static final XLogger logger = XLoggerFactory.getXLogger(MethodHandles.lookup().lookupClass());
    public static final String JSON_ATTRIBUTE_PREFIX = "@";
    public static final String JSON_VALUE_KEY = "text()";
    public static final int INLINE_LENGTH = 120;
    public static final Xml INVALID = new Xml(Type.Invalid, null, "", "");
    public static final String COMMENT_PREFIX = "<!--";
    public static final String END_TAG_PREFIX = "</";
    public static final String START_TAG_PREFIX = "<";
    public static final String COMMENT_SUFFIX = "-->";
    public static final String CLOSE_TAG_SUFFIX = ">";
    public static final String EMPTY_TAG_SUFFIX = "/>";
    public static final String ATTRIBUTE_PREFIX = "@";
    public static final String ATTRIBUTE_VALUE_PREFIX = "=";
    public static final String ATTRIBUTE_WRAPPER = "\"";
    private String name;
    private String value;
    private Type type;
    private Map<String, Xml> attributes;
    private ArrayList<Xml> allChildren;
    private ArrayList<Xml> tagChildren;
    private ArrayList<Xml> textChildren;
    private HashedLists<String, Xml> namedTagChildren;
    private Xml parent;
    int tagIndex = -1;
    int namedIndex = -1;

    public static Xml parseFile(String path) {
        Xml rtrn = null;
        try (InputStream stream = FileUtility.getInputStream(path);){
            rtrn = Xml.parse(stream, path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (rtrn == null) {
            rtrn = new Xml(Type.Document, null, "xml");
        }
        return rtrn;
    }

    public static Xml parse(String content) {
        return Xml.parse(new ByteArrayInputStream(content.getBytes()));
    }

    public static Xml parse(InputStream stream) {
        return Xml.parse(stream, "InputStream");
    }

    public static Xml parse(InputStream stream, String streamName) {
        Xml rtrn = new Xml(Type.Document, null, "xml");
        Stack<Xml> parentStack = new Stack<Xml>();
        parentStack.push(rtrn);
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(stream);
            while (xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (xmlEvent.isStartDocument()) {
                    StartDocument startDocumentEvent = (StartDocument)xmlEvent;
                    if (startDocumentEvent.getVersion() != null) {
                        rtrn.setAttribute(new Xml(Type.Attribute, rtrn, "version", startDocumentEvent.getVersion()));
                    }
                    if (startDocumentEvent.encodingSet()) {
                        rtrn.setAttribute(new Xml(Type.Attribute, rtrn, "encoding", startDocumentEvent.getCharacterEncodingScheme()));
                    }
                    if (startDocumentEvent.getSystemId() != null) {
                        rtrn.setAttribute(new Xml(Type.Attribute, rtrn, ""));
                    }
                    if (startDocumentEvent.standaloneSet()) {
                        rtrn.setAttribute(new Xml(Type.Attribute, rtrn, "standalone", startDocumentEvent.isStandalone() ? "yes" : "no"));
                    }
                }
                if (xmlEvent.isStartElement()) {
                    StartElement startElement = xmlEvent.asStartElement();
                    String newElementName = startElement.getName().getLocalPart();
                    if (!startElement.getName().getPrefix().isEmpty()) {
                        newElementName = startElement.getName().getPrefix() + ":" + newElementName;
                    }
                    Xml newElement = new Xml(Type.Tag, (Xml)parentStack.peek(), newElementName);
                    Iterator<Namespace> namespaceIterator = startElement.getNamespaces();
                    while (namespaceIterator.hasNext()) {
                        Namespace namespace = namespaceIterator.next();
                        String namespaceName = namespace.getName().getLocalPart();
                        String namespacePrefix = namespace.getPrefix();
                        namespacePrefix = namespacePrefix.isEmpty() ? "xmlns" : "xmlns:" + namespacePrefix;
                        String namespaceValue = namespace.getNamespaceURI();
                        Xml newAttribute = new Xml(Type.Attribute, newElement, namespacePrefix, namespaceValue);
                        newElement.setAttribute(newAttribute);
                    }
                    Iterator<Attribute> attributeIterator = startElement.getAttributes();
                    while (attributeIterator.hasNext()) {
                        Attribute attribute = attributeIterator.next();
                        String attributeName = attribute.getName().getLocalPart();
                        String attributePrefix = attribute.getName().getPrefix();
                        if (attributePrefix != null && !attributePrefix.isEmpty()) {
                            attributeName = attribute.getName().getPrefix() + ":" + attributeName;
                        }
                        Xml newAttribute = new Xml(Type.Attribute, newElement, attributeName);
                        newAttribute.setValue(attribute.getValue());
                        newElement.setAttribute(newAttribute);
                    }
                    ((Xml)parentStack.peek()).addChild(newElement);
                    parentStack.push(newElement);
                    continue;
                }
                if (xmlEvent.isCharacters()) {
                    String value = xmlEvent.asCharacters().getData().trim();
                    if (value.isEmpty()) continue;
                    Xml textElement = new Xml(Type.Text, (Xml)parentStack.peek(), "#text");
                    textElement.setValue(xmlEvent.asCharacters().getData());
                    ((Xml)parentStack.peek()).addChild(textElement);
                    continue;
                }
                if (xmlEvent.isEndElement()) {
                    parentStack.pop();
                    continue;
                }
                if (!xmlEvent.isEndDocument()) continue;
            }
        }
        catch (XMLStreamException ex) {
            logger.error("XMLSException " + ex.getMessage() + " for " + streamName + "\n  " + parentStack.stream().map(e -> e.getName() + " " + (Object)((Object)e.getType()) + " " + e.getChildren().size()).collect(Collectors.joining("\n  ")));
        }
        return rtrn;
    }

    private Xml(Type type, Xml parent, String name) {
        this(type, parent, name, null);
    }

    private Xml(Type type, Xml parent, String name, String value) {
        this.type = type;
        this.parent = parent;
        this.name = name;
        this.value = value;
        this.attributes = new LinkedHashMap<String, Xml>();
        this.allChildren = new ArrayList();
        this.tagChildren = new ArrayList();
        this.namedTagChildren = new HashedLists();
        this.textChildren = new ArrayList();
    }

    public Xml get(String search) {
        if (!search.contains("/") && !search.contains("[") && search.startsWith("@")) {
            return this.attribute(search.substring(1));
        }
        if (!search.contains("@") && search.lastIndexOf("/") <= 0 && !search.contains("[")) {
            return this.firstChild(search);
        }
        List<Xml> list = this.getAll(search);
        return list.isEmpty() ? new Xml(Type.Invalid, null, "") : list.get(0);
    }

    public List<Xml> getAll(String search) {
        if (!(search.contains("@") || search.contains("/") || search.contains("["))) {
            return Collections.unmodifiableList(this.namedTagChildren.get(search));
        }
        XmlPath path = XmlPath.parse(search);
        List<Xml> rtrn = path.getMatches(this);
        return rtrn;
    }

    public void addChild(Xml child) {
        if (!child.exists()) {
            return;
        }
        if (child.isAttribute()) {
            this.setAttribute(child);
        } else {
            if (child.isDocument() && child.tagChildren.size() > 0) {
                child = child.tagChildren.get(0);
            }
            this.allChildren.add(child);
            child.parent = this;
            if (child.getType().equals((Object)Type.Text)) {
                this.textChildren.add(child);
                this.addValue(child.getValue());
            } else if (child.getType().equals((Object)Type.Tag)) {
                int tagIndex = this.tagChildren.size();
                this.tagChildren.add(child);
                int namedIndex = this.namedTagChildren.get(child.getName()).size();
                this.namedTagChildren.put(child.getName(), child);
                child.setIndexes(tagIndex, namedIndex);
            }
        }
    }

    public void setAttribute(Xml child) {
        if (!child.exists()) {
            return;
        }
        int index = this.attributes.size();
        Xml previous = this.attributes.put(child.getName(), child);
        child.parent = this;
        child.type = Type.Attribute;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public void removeAttribute(String name) {
        if (this.hasAttribute(name)) {
            this.attributes.remove(name);
        }
    }

    public void removeChild(Xml child) {
        this.allChildren.remove(child);
        if (child.isText()) {
            this.resetTextValue();
        } else if (child.isTag()) {
            this.tagChildren.remove(child);
        } else if (child.isAttribute()) {
            this.removeAttribute(child.getName());
        }
    }

    public void removeChild(int index) {
        this.allChildren.remove(index);
    }

    private void setIndexes(int tagIndex, int namedIndex) {
        this.tagIndex = tagIndex;
        this.namedIndex = namedIndex;
    }

    int tagIndex() {
        return this.tagIndex;
    }

    int namedIndex() {
        return this.namedIndex;
    }

    private Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.hasValue() ? this.value : "";
    }

    Xml getValueXml() {
        return new Xml(Type.Text, null, "#text", this.getValue());
    }

    public boolean hasValue() {
        return this.value != null;
    }

    private void addValue(String value) {
        if (this.value == null) {
            this.value = "";
        }
        this.value = this.value + value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Xml parent(String tagName) {
        Xml rtrn = new Xml(Type.Invalid, null, tagName);
        Xml target = this.parent;
        while (!rtrn.exists() && target != null) {
            if (!tagName.equals(target.getName())) continue;
            rtrn = target;
        }
        return rtrn;
    }

    public Xml parent() {
        return this.parent;
    }

    private void clearText() {
        Iterator<Xml> childIter = this.allChildren.iterator();
        while (childIter.hasNext()) {
            Xml child = childIter.next();
            if (!child.isText()) continue;
            childIter.remove();
        }
        this.value = "";
    }

    private void resetTextValue() {
        this.value = "";
        this.allChildren.forEach(child -> {
            if (child.isText()) {
                this.addValue(child.getValue());
            }
        });
    }

    private void clear() {
        this.tagChildren.clear();
        this.allChildren.clear();
        this.value = "";
    }

    public List<Xml> getChildren() {
        return Collections.unmodifiableList(this.tagChildren);
    }

    public Xml firstChild(String tagName) {
        if (this.isDocument() && !this.tagChildren.isEmpty() && !tagName.equals(this.tagChildren.get(0).getName())) {
            return this.tagChildren.get(0).firstChild(tagName);
        }
        Xml rtrn = new Xml(Type.Invalid, this, tagName);
        if (!this.exists()) {
            return rtrn;
        }
        for (int i = 0; i < this.tagChildren.size() && !rtrn.exists(); ++i) {
            Xml child = this.tagChildren.get(i);
            if (!tagName.equals(child.getName())) continue;
            rtrn = child;
            break;
        }
        return rtrn;
    }

    public static Object convertString(String input) {
        if (input.matches("-?\\d{1,18}")) {
            return Long.parseLong(input);
        }
        if (input.matches("-?\\d*(?:\\.\\d+)?")) {
            return Double.parseDouble(input);
        }
        return input;
    }

    private List<Xml> allChildren() {
        return Collections.unmodifiableList(this.allChildren);
    }

    public Xml attribute(String name) {
        if (this.isDocument() && !this.tagChildren.isEmpty()) {
            return this.tagChildren.get(0).attribute(name);
        }
        if (!this.exists()) {
            return new Xml(Type.Invalid, this, name);
        }
        return this.attributes.containsKey(name) ? this.attributes.get(name) : new Xml(Type.Invalid, this, name);
    }

    public Map<String, Xml> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Json toJson() {
        return this.toJson("@", JSON_VALUE_KEY, true);
    }

    public Json toJson(String attributePrefix, String valueKey, boolean convertNumbers) {
        Json rtrn = new Json();
        Stack<Json> jsonTodo = new Stack<Json>();
        Stack<Xml> xmlTodo = new Stack<Xml>();
        jsonTodo.push(rtrn);
        xmlTodo.push(this);
        while (!jsonTodo.isEmpty()) {
            Json json = (Json)jsonTodo.pop();
            Xml xml = (Xml)xmlTodo.pop();
            xml.getAttributes().forEach((name, valueXml) -> json.set(attributePrefix + name, convertNumbers ? Xml.convertString(valueXml.getValue()) : valueXml.getValue()));
            if (xml.hasValue()) {
                json.set(valueKey, convertNumbers ? Xml.convertString(xml.getValue()) : xml.getValue());
            }
            xml.getChildren().forEach(childXml -> {
                Json child = new Json(false);
                json.add(childXml.getName(), child);
                jsonTodo.push(child);
                xmlTodo.push((Xml)childXml);
            });
        }
        return rtrn;
    }

    public boolean exists() {
        return !Type.Invalid.equals((Object)this.getType());
    }

    public boolean isDocument() {
        return this.getType().equals((Object)Type.Document);
    }

    public boolean isAttribute() {
        return this.getType().equals((Object)Type.Attribute);
    }

    public boolean isTag() {
        return this.getType().equals((Object)Type.Tag);
    }

    public boolean isText() {
        return this.getType().equals((Object)Type.Text);
    }

    public void attributeWalk(Consumer<Xml> toWalk) {
        this.attributes.values().forEach(toWalk);
        for (Xml child : this.getChildren()) {
            child.attributeWalk(toWalk);
        }
    }

    public void childWalk(Consumer<Xml> toWalk) {
        toWalk.accept(this);
        for (Xml child : this.allChildren()) {
            child.childWalk(toWalk);
        }
    }

    public String apply(String xmlOperation) {
        XmlOperation toApply = XmlOperation.parse(xmlOperation);
        return this.apply(toApply);
    }

    public String apply(XmlOperation xmlOperation) {
        if (!this.exists()) {
            return null;
        }
        StringBuilder rtrn = new StringBuilder();
        XmlPath xmlPath = XmlPath.parse(xmlOperation.getPath());
        List<Xml> found = Collections.EMPTY_LIST;
        XmlOperation.Operation opp = xmlOperation.getOperation();
        String value = xmlOperation.getValue();
        found = xmlPath.getMatches(this);
        if (found.isEmpty() && (xmlOperation.isAdd() || xmlOperation.isSet())) {
            xmlPath = xmlPath.copy();
            XmlPath tail = xmlPath.getTail();
            tail.drop();
            if (XmlPath.Type.Attribute.equals((Object)tail.getType())) {
                if (!tail.hasChildren() && xmlOperation.isSet()) {
                    opp = XmlOperation.Operation.Add;
                    value = "@" + tail.getName() + ATTRIBUTE_VALUE_PREFIX + xmlOperation.getValue();
                    found = xmlPath.getMatches(this);
                }
            } else if (XmlPath.Type.Tag.equals((Object)tail.getType())) {
                if (xmlOperation.isSet()) {
                    opp = XmlOperation.Operation.Add;
                    StringBuilder sb = new StringBuilder();
                    sb.append(START_TAG_PREFIX);
                    sb.append(tail.getName());
                    if (tail.hasChildren()) {
                        for (XmlPath child : tail.getChildren()) {
                            if (XmlPath.Type.Start.equals((Object)child.getType())) {
                                child = child.getNext();
                            }
                            if (XmlPath.Type.Attribute.equals((Object)child.getType())) {
                                sb.append(" ");
                                sb.append(child.getName());
                                sb.append(ATTRIBUTE_VALUE_PREFIX);
                                sb.append(StringUtil.quote(child.getValue()));
                                continue;
                            }
                            logger.error("cannot build ADD out of child " + child);
                            sb.delete(0, sb.length());
                            break;
                        }
                    }
                    sb.append(CLOSE_TAG_SUFFIX);
                    if (sb.length() > 1) {
                        sb.append(value);
                        sb.append(END_TAG_PREFIX);
                        sb.append(tail.getName());
                        sb.append(CLOSE_TAG_SUFFIX);
                        value = sb.toString();
                    }
                    found = xmlPath.getMatches(this);
                }
            } else {
                logger.error("unsupported type = " + (Object)((Object)tail.getType()));
            }
        }
        String finalValue = value.trim();
        if (!found.isEmpty()) {
            switch (opp) {
                case None: {
                    found.forEach(x -> {
                        if (rtrn.length() > 0) {
                            rtrn.append(System.lineSeparator());
                        }
                        switch (x.getType()) {
                            case Attribute: 
                            case Text: {
                                rtrn.append(x.getValue());
                                break;
                            }
                            default: {
                                if (x.hasValue()) {
                                    rtrn.append(x.getValue());
                                    break;
                                }
                                rtrn.append(x.documentString());
                            }
                        }
                    });
                    break;
                }
                case Set: {
                    found.forEach(x -> {
                        if (x.isAttribute()) {
                            x.setValue(finalValue);
                        } else if (x.isTag()) {
                            if (finalValue.startsWith(START_TAG_PREFIX)) {
                                Xml toSet = Xml.parse(finalValue);
                                x.clear();
                                x.addChild(toSet);
                            } else {
                                x.clearText();
                                Xml toSet = new Xml(Type.Text, (Xml)x, "#text", finalValue);
                                x.addChild(toSet);
                            }
                        } else if (x.isText()) {
                            x.setValue(finalValue);
                            if (x.parent() != null) {
                                x.parent().resetTextValue();
                            }
                        } else {
                            logger.error("Unsupported XMl type: cannot SET " + x + " to " + finalValue);
                        }
                    });
                    break;
                }
                case Add: {
                    found.forEach(x -> {
                        if (x.isAttribute()) {
                            x.setValue(x.getValue() + finalValue);
                        } else if (x.isTag()) {
                            if (finalValue.startsWith(START_TAG_PREFIX)) {
                                Xml toAdd = Xml.parse(finalValue);
                                x.addChild(toAdd);
                            } else if (finalValue.startsWith("@")) {
                                String attrName = finalValue.substring(1);
                                String attrValue = "";
                                if (attrName.contains(ATTRIBUTE_VALUE_PREFIX)) {
                                    int index = attrName.indexOf(ATTRIBUTE_VALUE_PREFIX);
                                    if (attrName.length() > index + 1) {
                                        attrValue = attrName.substring(index + 1).trim();
                                    }
                                    attrName = attrName.substring(0, index).trim();
                                }
                                Xml toAdd = new Xml(Type.Attribute, (Xml)x, attrName, StringUtil.removeQuotes(attrValue));
                                x.setAttribute(toAdd);
                            } else {
                                Xml toAdd = new Xml(Type.Text, (Xml)x, "#text", finalValue);
                                x.addChild(toAdd);
                            }
                        } else {
                            logger.error("Unsupported XMl type: cannot ADD " + x + " to " + finalValue);
                        }
                    });
                    break;
                }
                case Delete: {
                    found.forEach(x -> {
                        if (x.hasParent()) {
                            if (x.isAttribute()) {
                                x.parent().removeAttribute(x.getName());
                            } else if (x.isTag()) {
                                x.parent().removeChild((Xml)x);
                            } else if (x.isText()) {
                                x.parent().removeChild((Xml)x);
                            } else {
                                logger.error("Unsupported XMl type: cannot DELETE " + x);
                            }
                        }
                    });
                    break;
                }
                default: {
                    logger.error("unsupported opp " + (Object)((Object)opp) + " on " + xmlPath.toString());
                }
            }
        }
        if (rtrn.toString().isEmpty() && found.size() > 0) {
            found.forEach(x -> {
                if (rtrn.length() > 0) {
                    rtrn.append(System.lineSeparator());
                }
                switch (x.getType()) {
                    case Attribute: 
                    case Text: {
                        rtrn.append(x.getValue());
                        break;
                    }
                    default: {
                        if (x.hasValue()) {
                            rtrn.append(x.getValue());
                            break;
                        }
                        rtrn.append(x.documentString());
                    }
                }
            });
        }
        return rtrn.toString();
    }

    private boolean hasParent() {
        return this.parent != null;
    }

    public String toString() {
        return this.isDocument() ? "?xml" : this.getName() + ":" + this.value;
    }

    public String documentString() {
        return this.documentString(4);
    }

    public String documentString(int indent) {
        boolean includeDocument = this.getType() == Type.Document ? this.hasAttribute("version") : true;
        return this.documentString(indent, includeDocument);
    }

    public String documentString(int indent, boolean includeDocument) {
        StringBuilder rtrn = new StringBuilder();
        this.append(rtrn, 0, indent, includeDocument);
        return rtrn.toString();
    }

    private void pad(StringBuilder sb, int amount) {
        if (amount > 0) {
            sb.append(String.format("%" + amount + "s", ""));
        }
    }

    private void append(StringBuilder sb, int indent, int increment, boolean includeDocument) {
        if (!this.type.equals((Object)Type.Document)) {
            this.pad(sb, indent);
        }
        switch (this.type) {
            case Attribute: {
                sb.append(this.getValue());
                break;
            }
            case Text: {
                sb.append(this.getValue());
                break;
            }
            case Document: {
                if (includeDocument) {
                    sb.append(START_TAG_PREFIX);
                    sb.append("?");
                    sb.append(this.getName());
                    for (Xml attribute : this.getAttributes().values()) {
                        sb.append(" ");
                        sb.append(attribute.getName());
                        sb.append(ATTRIBUTE_VALUE_PREFIX);
                        sb.append(ATTRIBUTE_WRAPPER);
                        sb.append(attribute.getValue());
                        sb.append(ATTRIBUTE_WRAPPER);
                    }
                    sb.append("?");
                    sb.append(CLOSE_TAG_SUFFIX);
                    if (increment > 0) {
                        sb.append(System.lineSeparator());
                    }
                }
                for (Xml child : this.getChildren()) {
                    child.append(sb, indent, increment, includeDocument);
                }
                break;
            }
            case Tag: {
                sb.append(START_TAG_PREFIX);
                sb.append(this.getName());
                for (Xml attribute : this.getAttributes().values()) {
                    sb.append(" ");
                    sb.append(attribute.getName());
                    sb.append(ATTRIBUTE_VALUE_PREFIX);
                    sb.append(ATTRIBUTE_WRAPPER);
                    sb.append(StringEscapeUtils.escapeXml11((String)attribute.getValue()));
                    sb.append(ATTRIBUTE_WRAPPER);
                }
                if (this.allChildren().isEmpty() && this.getValue().isEmpty()) {
                    sb.append(EMPTY_TAG_SUFFIX);
                    break;
                }
                sb.append(CLOSE_TAG_SUFFIX);
                if (this.tagChildren.isEmpty() && this.allChildren.stream().mapToInt(x -> x.getValue().length()).sum() < 120) {
                    for (Xml child : this.allChildren()) {
                        sb.append(child.getValue());
                    }
                    sb.append(END_TAG_PREFIX);
                    sb.append(this.getName());
                    sb.append(CLOSE_TAG_SUFFIX);
                    break;
                }
                for (Xml child : this.allChildren()) {
                    if (increment > 0) {
                        sb.append(System.lineSeparator());
                    }
                    child.append(sb, indent + increment, increment, includeDocument);
                }
                if (increment > 0) {
                    sb.append(System.lineSeparator());
                }
                this.pad(sb, indent);
                sb.append(END_TAG_PREFIX);
                sb.append(this.getName());
                sb.append(CLOSE_TAG_SUFFIX);
                break;
            }
            case Comment: {
                sb.append(COMMENT_PREFIX);
                sb.append(this.getValue());
                sb.append(COMMENT_SUFFIX);
                break;
            }
        }
    }

    public static enum Type {
        Invalid,
        Document,
        Tag,
        Attribute,
        Comment,
        Text;

    }
}

