/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class HashedLists<K, V>
implements Serializable {
    private LinkedHashMap<K, List<V>> sets = new LinkedHashMap();
    private transient List<V> empty = Collections.unmodifiableList(new ArrayList());
    private final Function<K, List<V>> supplier = k -> new ArrayList();

    public void remove(K name, V value) {
        if (this.sets.containsKey(name)) {
            this.sets.get(name).remove(value);
        }
    }

    public void removeAll(K name) {
        this.sets.remove(name);
    }

    public void put(K name, V value) {
        this.sets.computeIfAbsent(name, this.supplier).add(value);
    }

    public void putFirst(K name, V value) {
        this.sets.computeIfAbsent(name, this.supplier).add(0, value);
    }

    public void putAll(K name, Collection<V> values) {
        this.sets.computeIfAbsent(name, this.supplier).addAll(values);
    }

    public void putAllFirst(K name, Collection<V> values) {
        this.sets.computeIfAbsent(name, this.supplier).addAll(0, values);
    }

    public List<V> get(K name) {
        if (this.sets.containsKey(name)) {
            return Collections.unmodifiableList(this.sets.get(name));
        }
        return this.empty;
    }

    public boolean isEmpty() {
        return this.sets.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.sets.containsKey(key);
    }

    public int size() {
        return this.sets.size();
    }

    public Set<K> keys() {
        return Collections.unmodifiableSet(this.sets.keySet());
    }

    public Collection<List<V>> values() {
        return this.sets.values();
    }

    public void forEach(BiConsumer<K, List<V>> consumer) {
        this.sets.forEach(consumer);
    }

    public Stream<Map.Entry<K, List<V>>> stream() {
        return this.sets.entrySet().stream();
    }

    public void clear() {
        this.sets.clear();
    }
}

