/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class IdGenerator<T> {
    private static final int RADIX = 36;
    private HashMap<T, String> seen = new HashMap();
    private AtomicInteger counter;

    public IdGenerator() {
        this(null);
    }

    public IdGenerator(String previous) {
        this.counter = previous != null ? new AtomicInteger(Integer.parseInt(previous, 36)) : new AtomicInteger(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(T value) {
        if (this.seen.containsKey(value)) {
            return this.seen.get(value);
        }
        IdGenerator idGenerator = this;
        synchronized (idGenerator) {
            if (this.seen.containsKey(value)) {
                return this.seen.get(value);
            }
            int val = this.counter.getAndIncrement();
            String rtrn = Integer.toString(val, 36);
            this.seen.put(value, rtrn);
            return rtrn;
        }
    }

    public int count() {
        return this.counter.get();
    }

    protected void addSeen(T value, String key) {
        int val = Integer.valueOf(key, 36);
        this.seen.put(value, key);
        if (val >= this.counter.get()) {
            this.counter.set(val + 1);
        }
    }
}

