/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.json;

import io.hyperfoil.tools.yaup.json.Json;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class JsonTransform
implements Function<Json, Json> {
    private final Map<String, Function<Json, Object>> ops = new LinkedHashMap<String, Function<Json, Object>>();

    public JsonTransform set(String name, String jsonPath) {
        this.set(name, (Json json) -> {
            Object result = Json.find(json, jsonPath);
            if (result instanceof Json) {
                Json resultJson = (Json)result;
                if (resultJson.isArray() && resultJson.size() == 1) {
                    return resultJson.get(0);
                }
                if (resultJson.size() == 0) {
                    return "";
                }
                return resultJson;
            }
            return result;
        });
        return this;
    }

    public JsonTransform set(String name, Function<Json, Object> op) {
        this.ops.put(name, op);
        return this;
    }

    @Override
    public Json apply(Json json) {
        Json rtrn = new Json();
        this.ops.forEach((name, op) -> {
            Object result = op.apply(json);
            rtrn.set(name, result);
        });
        return rtrn;
    }
}

