/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.json;

import io.hyperfoil.tools.yaup.json.Json;
import io.hyperfoil.tools.yaup.json.graaljs.JsException;
import io.hyperfoil.tools.yaup.json.graaljs.JsonProxyArray;
import io.hyperfoil.tools.yaup.json.graaljs.JsonProxyObject;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;

public class ValueConverter {
    public static Object convert(Value value) {
        if (value == null) {
            return null;
        }
        if (value.isNull()) {
            if (value.toString().contains("undefined")) {
                return "";
            }
            return null;
        }
        if (value.isProxyObject()) {
            Proxy po = value.asProxyObject();
            if (po instanceof JsonProxyObject) {
                return ((JsonProxyObject)po).getJson();
            }
            if (po instanceof JsonProxyArray) {
                return ((JsonProxyArray)po).getJson();
            }
            return value.asProxyObject();
        }
        if (value.isHostObject()) {
            return value.asHostObject();
        }
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isNumber()) {
            double v = value.asDouble();
            if (v == Math.rint(v)) {
                return (long)v;
            }
            return v;
        }
        if (value.isString()) {
            return value.asString();
        }
        if (value.hasArrayElements()) {
            return ValueConverter.convertArray(value);
        }
        if (value.canExecute()) {
            return value.toString();
        }
        if (value.isException()) {
            return new JsException(value.toString());
        }
        if (value.hasMembers()) {
            return ValueConverter.convertMapping(value);
        }
        return "";
    }

    public static String asString(Object value) {
        if (value instanceof Double) {
            return String.format("%.8f", value);
        }
        return value.toString();
    }

    public static Json convertArray(Value value) {
        Json json = new Json();
        int i = 0;
        while ((long)i < value.getArraySize()) {
            json.add(ValueConverter.convert(value.getArrayElement((long)i)));
            ++i;
        }
        return json;
    }

    public static Json convertMapping(Value value) {
        Json json = new Json(false);
        for (String key : value.getMemberKeys()) {
            json.set(key, ValueConverter.convert(value.getMember(key)));
        }
        return json;
    }
}

