/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.xml;

import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.file.FileUtility;
import io.hyperfoil.tools.yaup.xml.XmlLoader;
import java.io.ByteArrayOutputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Xml {
    static final XLogger logger = XLoggerFactory.getXLogger(MethodHandles.lookup().lookupClass());
    public static final String ATTRIBUTE_VALUE_KEY = "=";
    public static final String ATTRIBUTE_KEY = "@";
    public static final String TAG_START = "<";
    public static final String TAG_END = ">";
    public static final Xml EMPTY = new Xml(null);
    private static final String XPATH_DELIM = "/";
    private final XmlLoader xmlLoader = new XmlLoader();
    private final XPathFactory xPathFactory = XPathFactory.newInstance();
    private final Node node;

    protected Xml(Node node) {
        this.node = node;
    }

    public boolean isEmpty() {
        return this.node == null;
    }

    public boolean exists() {
        return this.node != null;
    }

    public Xml get(String search) {
        if (!search.contains(XPATH_DELIM) && !search.contains("[") && search.startsWith(ATTRIBUTE_KEY)) {
            return this.attribute(search);
        }
        if (!search.contains(ATTRIBUTE_KEY) && search.lastIndexOf(XPATH_DELIM) <= 0 && !search.contains("[")) {
            return this.firstChild(search);
        }
        List<Xml> list = this.getAll(search);
        return list.isEmpty() ? EMPTY : list.get(0);
    }

    public List<Xml> getAll(String search) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Xml> rtrn = new ArrayList<Xml>();
        XPath xPath = this.xPathFactory.newXPath();
        try {
            Object resultObj = xPath.compile(search).evaluate(this.node, XPathConstants.NODESET);
            if (resultObj instanceof NodeList) {
                NodeList nodeList = (NodeList)resultObj;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    rtrn.add(new Xml(node));
                }
            } else if (resultObj instanceof String) {
                rtrn.add(new Xml(this.node.getOwnerDocument().createTextNode((String)resultObj)));
            } else {
                logger.error("resultObject is " + resultObj.getClass());
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return rtrn;
    }

    public void set(String key, String value) {
        if (this.isEmpty()) {
            return;
        }
        if (key.startsWith(ATTRIBUTE_KEY)) {
            String attributeName = key.substring(ATTRIBUTE_KEY.length());
            ((Element)this.node).setAttribute(attributeName, value);
        }
    }

    private void trimEmptyText(Node toTrim) {
        if (this.isEmpty()) {
            return;
        }
        XPathExpression xpathExp = null;
        try {
            xpathExp = this.xPathFactory.newXPath().compile("//text()[normalize-space(.) = '']");
            NodeList emptyTextNodes = (NodeList)xpathExp.evaluate(toTrim, XPathConstants.NODESET);
            for (int i = 0; i < emptyTextNodes.getLength(); ++i) {
                Node emptyTextNode = emptyTextNodes.item(i);
                emptyTextNode.getParentNode().removeChild(emptyTextNode);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public List<Xml> getChildren() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Xml> rtrn = new LinkedList<Xml>();
        NodeList children = this.node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            rtrn.add(new Xml(children.item(i)));
        }
        return rtrn;
    }

    public Xml firstChild(String tagName) {
        Xml rtrn = null;
        if (tagName == null) {
            return new Xml(null);
        }
        if (this.isEmpty()) {
            rtrn = new Xml(null);
        } else {
            NodeList children = this.node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child == null || !tagName.equals(child.getNodeName()) || rtrn != null) continue;
                rtrn = new Xml(child);
            }
        }
        return rtrn;
    }

    public Optional<Xml> optChild(String tagName) {
        Optional<Xml> rtrn = Optional.empty();
        NodeList children = this.node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!tagName.equals(child.getNodeName())) continue;
            rtrn = Optional.of(new Xml(child));
        }
        return rtrn;
    }

    public Xml attribute(String name) {
        Xml rtrn = null;
        if (this.isEmpty()) {
            rtrn = new Xml(null);
        } else {
            NamedNodeMap attributes = this.node.getAttributes();
            Node attributeNode = attributes.getNamedItem(name);
            rtrn = new Xml(attributeNode);
        }
        return rtrn;
    }

    public Optional<Xml> optAttribute(String attributeName) {
        Optional<Xml> rtrn = Optional.empty();
        NamedNodeMap attributes = this.node.getAttributes();
        Node node = attributes.getNamedItem(attributeName);
        if (node != null) {
            rtrn = Optional.of(new Xml(node));
        }
        return rtrn;
    }

    public boolean hasChild(String tagName) {
        boolean rtrn = false;
        NodeList children = this.node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!tagName.equals(child.getNodeName())) continue;
            rtrn = true;
        }
        return rtrn;
    }

    protected void clearChildren() {
        if (this.isEmpty()) {
            return;
        }
        while (this.node.hasChildNodes()) {
            this.node.removeChild(this.node.getFirstChild());
        }
    }

    public void setChild(String value) {
        if (this.isEmpty()) {
            return;
        }
        this.clearChildren();
        this.addChild(value);
    }

    private void addChild(String value) {
        value = "<cld>" + (String)value + "</cld>";
        List<Xml> xmls = this.xmlLoader.loadXml((String)value).getChildren();
        for (Xml xml : xmls) {
            this.addChild(xml);
        }
    }

    private void addChild(Xml value) {
        Node toImport = this.node.getOwnerDocument().importNode(value.node, true);
        ((Element)this.node).appendChild(toImport);
    }

    public void add(String value) {
        if (this.isEmpty()) {
            return;
        }
        switch (this.node.getNodeType()) {
            case 2: {
                this.node.setNodeValue(this.node.getNodeValue() + value);
                break;
            }
            case 1: {
                if (value.startsWith(TAG_START) && value.endsWith(TAG_END)) {
                    this.addChild(value);
                    break;
                }
                this.node.setTextContent(this.node.getTextContent() + value);
                break;
            }
            default: {
                logger.error("add(" + value + ") " + this.node.getNodeType());
            }
        }
    }

    public void set(String value) {
        if (this.isEmpty()) {
            return;
        }
        switch (this.node.getNodeType()) {
            case 2: {
                this.node.setNodeValue(value);
                break;
            }
            case 1: {
                if (value.startsWith(TAG_START) && value.endsWith(TAG_END)) {
                    this.setChild(value);
                    break;
                }
                this.node.setTextContent(value);
                break;
            }
            default: {
                logger.error("set(" + value + ") " + this.node.getNodeType());
            }
        }
    }

    public void modify(String value) {
        if (this.isEmpty()) {
            return;
        }
        int opIndex = -1;
        switch (this.node.getNodeType()) {
            case 2: {
                if (value.startsWith("--")) {
                    this.delete();
                    break;
                }
                if (value.startsWith("++")) {
                    String newValue = StringUtil.removeQuotes(value.substring(FileUtility.OPERATION_LENGTH).trim());
                    this.node.setNodeValue(this.node.getNodeValue() + newValue);
                    break;
                }
                if (value.startsWith("==")) {
                    this.node.setNodeValue(StringUtil.removeQuotes(value.substring(FileUtility.OPERATION_LENGTH).trim()));
                    break;
                }
                this.node.setNodeValue(StringUtil.removeQuotes(value));
                break;
            }
            case 1: {
                if (value.startsWith("--")) {
                    this.delete();
                    break;
                }
                if (value.startsWith("++")) {
                    String toAdd = value.substring("++".length()).trim();
                    if (toAdd.startsWith(ATTRIBUTE_KEY)) {
                        int valueIndex = toAdd.indexOf(ATTRIBUTE_VALUE_KEY);
                        String attributeKey = toAdd.substring(ATTRIBUTE_KEY.length(), valueIndex).trim();
                        String attributeValue = toAdd.substring(valueIndex + ATTRIBUTE_VALUE_KEY.length()).trim();
                        Element elm = (Element)this.node;
                        elm.setAttribute(attributeKey, StringUtil.removeQuotes(attributeValue));
                        break;
                    }
                    this.add(StringUtil.removeQuotes(toAdd));
                    break;
                }
                if (value.startsWith("==")) {
                    String toSet = value.substring("==".length()).trim();
                    this.set(StringUtil.removeQuotes(toSet));
                    break;
                }
                this.set(StringUtil.removeQuotes(value));
                break;
            }
            default: {
                logger.error("set(" + value + ") " + this.node.getNodeType());
            }
        }
    }

    public void delete() {
        if (this.node == null) {
            return;
        }
        switch (this.node.getNodeType()) {
            case 2: {
                Element attrParent = ((Attr)this.node).getOwnerElement();
                attrParent.removeAttributeNode((Attr)this.node);
                break;
            }
            case 1: {
                Node nodeParent = this.node.getParentNode();
                nodeParent.removeChild(this.node);
                break;
            }
            default: {
                logger.error("unknown type=" + this.node.getNodeType());
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        switch (this.node.getNodeType()) {
            case 2: {
                return this.node.getNodeValue();
            }
            case 1: {
                return this.node.getTextContent();
            }
            case 3: {
                return this.node.getNodeValue();
            }
        }
        return this.node.getNodeValue();
    }

    public String getName() {
        return this.node.getNodeName();
    }

    public String getValue() {
        return this.isEmpty() ? "" : this.node.getNodeValue();
    }

    public String documentString() {
        return this.documentString(4);
    }

    public String documentString(int indent) {
        Node toPrint = this.node.cloneNode(true);
        this.trimEmptyText(toPrint);
        Transformer transformer = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("doctype-public", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
            DOMSource source = new DOMSource(toPrint);
            StreamResult result = new StreamResult(baos);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return new String(baos.toByteArray());
    }
}

