/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.xml;

import io.hyperfoil.tools.yaup.xml.Xml;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlLoader {
    private final DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    private final XPathFactory xPathFactory = XPathFactory.newInstance();
    private DocumentBuilder builder;

    public XmlLoader() {
        this.docFactory.setValidating(false);
        this.docFactory.setNamespaceAware(true);
        try {
            this.docFactory.setFeature("http://xml.org/sax/features/namespaces", false);
            this.docFactory.setFeature("http://xml.org/sax/features/validation", false);
            this.docFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            this.docFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.builder = this.docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public String getValue(String pathValue) {
        List<String> found = this.getValues(pathValue);
        if (found.isEmpty()) {
            return "";
        }
        return found.get(0);
    }

    public List<String> getValues(String pathValue) {
        ArrayList<String> rtrn = new ArrayList<String>();
        int searchKeyIndex = pathValue.indexOf(">");
        if (searchKeyIndex > -1) {
            String searchPath = pathValue.substring(searchKeyIndex + ">".length());
            String filePath = pathValue.substring(0, searchKeyIndex);
            File f = new File(filePath);
            if (f.exists()) {
                Document doc = this.loadDocument(f.toPath());
                XPath xPath = this.xPathFactory.newXPath();
                try {
                    NodeList nodeList = (NodeList)xPath.evaluate(searchPath, doc.getDocumentElement(), XPathConstants.NODESET);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        rtrn.add(node.getNodeValue());
                    }
                }
                catch (XPathExpressionException e) {
                    e.printStackTrace();
                }
            }
        }
        return Collections.unmodifiableList(rtrn);
    }

    public Xml loadXml(String content) {
        Document document = this.loadDocument(content);
        return new Xml(document.getDocumentElement());
    }

    public Xml loadXml(Path path) {
        Document document = this.loadDocument(path);
        return new Xml(document.getDocumentElement());
    }

    public Document loadDocument(String document) {
        Document rtrn = null;
        try {
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(document));
            rtrn = this.builder.parse(is);
            this.builder.reset();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rtrn;
    }

    public Document loadDocument(Path path) {
        Document rtrn = null;
        try {
            rtrn = this.builder.parse(path.toFile());
            this.builder.reset();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rtrn;
    }
}

