/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.xml;

import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.xml.Xml;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlOperation {
    private static final String NAMESPACE_PATTERN = "starts-with(namespace::*[name()=\"%s\"],\"%s\")";
    private static final String XMLNS_PATTERN = "@xmlns:?(?<prefix>[^=\\s]*)\\s*=\\s*['\"]?(?<namespace>[^\\s'\\\"\\]]+)['\"]?";
    private static final String XPATH_ATTRIBUTE_CRITERIA_PATTERN = "^\\s*@(?<name>[^\\s=\\]]+)\\s*";
    private String path;
    private Operation operation;
    private String value;

    private static Operation getOperation(String input) {
        Operation rtrn = Operation.None;
        switch (input) {
            case "++": {
                rtrn = Operation.Add;
                break;
            }
            case "--": {
                rtrn = Operation.Delete;
                break;
            }
            case "==": {
                rtrn = Operation.Set;
            }
        }
        return rtrn;
    }

    public static XmlOperation parse(String input) {
        String path;
        String patternString = String.format("(?<operation>%s|%s|%s)", StringUtil.escapeRegex("++"), StringUtil.escapeRegex("--"), StringUtil.escapeRegex("=="));
        Pattern operationPattern = Pattern.compile(patternString);
        Operation operation = Operation.None;
        String value = null;
        Matcher m = operationPattern.matcher(input);
        if (m.find()) {
            path = input.substring(0, m.start()).trim();
            operation = XmlOperation.getOperation(m.group("operation"));
            value = input.substring(m.end()).trim();
        } else {
            path = input;
        }
        return new XmlOperation(path, operation, value);
    }

    public XmlOperation(String path, Operation operation, String value) {
        this.path = path;
        this.operation = operation;
        this.value = StringUtil.removeQuotes(value);
    }

    public boolean isRead() {
        return Operation.None.equals((Object)this.operation);
    }

    public boolean isSet() {
        return Operation.Set.equals((Object)this.operation);
    }

    public boolean isAdd() {
        return Operation.Add.equals((Object)this.operation);
    }

    public boolean isDelete() {
        return Operation.Delete.equals((Object)this.operation);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getPath() {
        return this.path;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    public String apply(Xml xml) {
        StringBuilder sb = new StringBuilder();
        String xpath = this.path;
        if (xpath != null && !xpath.isEmpty()) {
            List<Xml> found = xml.getAll(XmlOperation.replaceXmlnsAttribute(xpath));
            if (found.isEmpty()) {
                int lastIndex = XmlOperation.lastPathIndex(xpath);
                String lastFragment = null;
                if (lastIndex > -1) {
                    lastFragment = xpath.substring(lastIndex);
                    xpath = xpath.substring(0, lastIndex);
                    while (xpath.endsWith("/")) {
                        xpath = xpath.substring(0, xpath.length() - 1);
                    }
                }
                if (lastFragment != null) {
                    boolean canSet = true;
                    if (lastFragment.startsWith("@")) {
                        this.operation = Operation.Add;
                        this.value = lastFragment + " = " + this.value;
                    } else {
                        int criteriaIndex = lastFragment.indexOf("[");
                        String tagName = lastFragment;
                        HashMap<String, String> newAttributes = new HashMap<String, String>();
                        if (criteriaIndex > -1) {
                            tagName = lastFragment.substring(0, criteriaIndex);
                            String criteria = lastFragment.substring(tagName.length() + 1, lastFragment.lastIndexOf("]")).trim();
                            Matcher attributeMatcher = Pattern.compile(XPATH_ATTRIBUTE_CRITERIA_PATTERN).matcher(criteria);
                            Matcher separatorMatcher = Pattern.compile("^\\s*AND|and\\s+", 32).matcher(criteria);
                            while (canSet && !criteria.isEmpty()) {
                                canSet = false;
                                separatorMatcher.reset(criteria);
                                if (criteria.startsWith("AND") || criteria.startsWith("and")) {
                                    criteria = criteria.substring(3).trim();
                                }
                                attributeMatcher.reset(criteria);
                                if (!attributeMatcher.find()) continue;
                                canSet = true;
                                String name = attributeMatcher.group("name");
                                String value = "";
                                if ((criteria = criteria.substring(attributeMatcher.end())).startsWith("=")) {
                                    criteria = criteria.substring(1);
                                    value = StringUtil.findNotQuoted(criteria, " ]");
                                    criteria = criteria.substring(value.length()).trim();
                                    value = StringUtil.removeQuotes(value);
                                }
                                newAttributes.put(name, value);
                            }
                        }
                        if (canSet) {
                            StringBuilder newTagSb = new StringBuilder();
                            newTagSb.append("<");
                            newTagSb.append(tagName);
                            if (!newAttributes.isEmpty()) {
                                for (String key : newAttributes.keySet()) {
                                    String attributeValue = (String)newAttributes.get(key);
                                    newTagSb.append(" ");
                                    newTagSb.append(key);
                                    newTagSb.append("=");
                                    newTagSb.append(StringUtil.quote(attributeValue));
                                }
                            }
                            newTagSb.append(">");
                            this.operation = Operation.Add;
                            String newTagValue = newTagSb.toString();
                            this.value = newTagSb.toString() + this.value + "</" + tagName + ">";
                        }
                    }
                    if (canSet) {
                        found = xml.getAll(XmlOperation.replaceXmlnsAttribute(xpath));
                    }
                }
            }
            if (!found.isEmpty()) {
                if (Operation.None.equals((Object)this.operation)) {
                    for (Xml entry : found) {
                        if (sb.length() > 0) {
                            sb.append(System.lineSeparator());
                        }
                        sb.append(entry.toString());
                    }
                } else {
                    found.forEach(xmlEntry -> xmlEntry.modify(this.operation.getValue() + this.getValue()));
                }
            }
        } else {
            xml.modify(this.operation.getValue() + this.getValue());
        }
        return sb.toString();
    }

    public static String replaceXmlnsAttribute(String pattern) {
        String rtrn = pattern;
        Matcher xmlnsPattern = Pattern.compile(XMLNS_PATTERN).matcher(pattern);
        while (xmlnsPattern.find()) {
            rtrn = rtrn.replace(xmlnsPattern.group(), String.format(NAMESPACE_PATTERN, xmlnsPattern.group("prefix"), xmlnsPattern.group("namespace")));
        }
        return rtrn;
    }

    public static int lastPathIndex(String path) {
        int rtrn = -1;
        if (path.contains("/")) {
            rtrn = path.length();
            boolean stop = false;
            char quoteChar = '\"';
            boolean inQuote = false;
            boolean inCtriteria = false;
            while (rtrn > 0 && !stop) {
                switch (path.charAt(--rtrn)) {
                    case '\"': 
                    case '\'': {
                        if (!inQuote) {
                            inQuote = true;
                            quoteChar = path.charAt(rtrn);
                            break;
                        }
                        if (quoteChar != path.charAt(rtrn)) break;
                        if (rtrn > 0 && '\\' == path.charAt(rtrn - 1)) {
                            --rtrn;
                            break;
                        }
                        inQuote = false;
                        break;
                    }
                    case ']': {
                        if (inQuote) break;
                        inCtriteria = true;
                        break;
                    }
                    case '[': {
                        if (inQuote || !inCtriteria) break;
                        inCtriteria = false;
                        break;
                    }
                    case '/': {
                        if (inQuote || inCtriteria) break;
                        stop = true;
                        ++rtrn;
                    }
                }
            }
        }
        return rtrn;
    }

    public static String lastPathFragment(String path) {
        String rtrn = "";
        int i = XmlOperation.lastPathIndex(path);
        if (i < 0) {
            i = 0;
        }
        rtrn = path.substring(i);
        return rtrn;
    }

    public static enum Operation {
        None(""),
        Add("++"),
        Set("=="),
        Delete("--");

        private String value;

        private Operation(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

