/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.xml.pojo;

import io.hyperfoil.tools.yaup.Sets;
import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.linux.Local;
import io.hyperfoil.tools.yaup.xml.pojo.Xml;
import io.hyperfoil.tools.yaup.xml.pojo.XmlPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class XmlComparison {
    static final XLogger logger = XLoggerFactory.getXLogger(MethodHandles.lookup().lookupClass());
    private LinkedHashMap<String, Xml> rootXmls = new LinkedHashMap();
    private LinkedHashMap<XmlPath, Integer> criteria = new LinkedHashMap();
    private boolean ordered = false;

    public static final XmlComparison domainXml() {
        XmlComparison rtrn = new XmlComparison();
        XmlComparison.domainXml(rtrn);
        return rtrn;
    }

    public static final void domainXml(XmlComparison comp) {
        XmlComparison.standaloneXml(comp);
        comp.addCriteria("/context-param/param-name", 0);
        comp.addCriteria("/filter/filter-name", 0);
        comp.addCriteria("/filter-mapping/filter-name", 0);
        comp.addCriteria("/servlet/servlet-name", 0);
        comp.addCriteria("/servlet-mapping/servlet-name", 0);
        comp.addCriteria("/env-entry/env-entry-name", 0);
    }

    public static final XmlComparison standaloneXml() {
        XmlComparison rtrn = new XmlComparison();
        XmlComparison.standaloneXml(rtrn);
        return rtrn;
    }

    public static final void standaloneXml(XmlComparison comp) {
        comp.addCriteria("/option/@value", 0);
        comp.addCriteria("@name", 0);
        comp.addCriteria("@jndi-name", 0);
        comp.addCriteria("@xmlns", 3);
        comp.addCriteria("@class-name", 0);
        comp.addCriteria("@module", 0);
        comp.addCriteria("@category", 0);
    }

    public static final XmlComparison webXml() {
        XmlComparison rtrn = new XmlComparison();
        XmlComparison.webXml(rtrn);
        return rtrn;
    }

    public static final void webXml(XmlComparison comp) {
        comp.addCriteria("/context-param/param-name", 0);
        comp.addCriteria("/filter/filter-name", 0);
        comp.addCriteria("/filter-mapping/filter-name", 0);
        comp.addCriteria("/servlet/servlet-name", 0);
        comp.addCriteria("/servlet-mapping/servlet-name", 0);
        comp.addCriteria("/env-entry/env-entry-name", 0);
    }

    private static Map<String, XmlNamedChildren> buildNamedChildren(Map<String, Xml> xmls) {
        LinkedHashMap<String, XmlNamedChildren> rtrn = new LinkedHashMap<String, XmlNamedChildren>();
        xmls.forEach((name, xml) -> {
            XmlNamedChildren namedChildren = new XmlNamedChildren();
            if (xml.exists()) {
                xml.getChildren().forEach(namedChildren::add);
            }
            rtrn.put((String)name, namedChildren);
        });
        return rtrn;
    }

    public static void main(String[] args) {
        List paths;
        Properties criteria;
        CommandLine cmd;
        Options options = new Options();
        options.addOption(Option.builder((String)"C").longOpt("color").hasArg(false).desc("use terminal colored output").build());
        options.addOption(Option.builder((String)"S").longOpt("standalone").hasArg(false).desc("use standalone.xml criteria").build());
        options.addOption(Option.builder((String)"D").longOpt("domain").hasArg(false).desc("use domain.xml criteria").build());
        options.addOption(Option.builder((String)"W").longOpt("web").hasArg(false).desc("use web.xml criteria").build());
        options.addOption(Option.builder((String)"X").argName("criteria=#").hasArg().desc("criteria=edit_distance").valueSeparator().build());
        LinkedList toDelete = new LinkedList();
        XmlComparison comp = new XmlComparison();
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        String cmdLineSyntax = "java -jar " + new File(XmlComparison.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName() + " [options] [name=file...]";
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            formatter.printHelp(cmdLineSyntax, options);
            System.exit(1);
            return;
        }
        if (cmd.hasOption("standalone")) {
            XmlComparison.standaloneXml(comp);
        }
        if (cmd.hasOption("domain")) {
            XmlComparison.domainXml(comp);
        }
        if (cmd.hasOption("web")) {
            XmlComparison.webXml(comp);
        }
        if (!(criteria = cmd.getOptionProperties("X")).isEmpty()) {
            criteria.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> comp.addCriteria(k.toString(), Integer.parseInt(v.toString()))));
        }
        if ((paths = cmd.getArgList()).isEmpty()) {
            logger.error("Missing file(s)");
            formatter.printHelp(cmdLineSyntax, options);
            System.exit(1);
            return;
        }
        paths.forEach(arg -> {
            Xml toLoad;
            Object name = "";
            String path = "";
            if (arg.contains("=")) {
                if (arg.endsWith("=") || arg.startsWith("=")) {
                    // empty if block
                }
                name = arg.substring(0, arg.indexOf("="));
                path = arg.substring(arg.indexOf("=") + 1);
            } else {
                name = "" + comp.xmlCount();
                path = arg;
            }
            if (path.contains(":")) {
                if (path.startsWith("http")) {
                    try {
                        File tmp = File.createTempFile("xmlComp-", ".xml");
                        URL url = new URL(path);
                        ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
                        FileOutputStream fileOutputStream = new FileOutputStream(tmp.getAbsolutePath());
                        FileChannel fileChannel = fileOutputStream.getChannel();
                        fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                        toDelete.add(tmp.getPath());
                        path = tmp.getPath();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    Local local = new Local();
                    try {
                        File tmp = File.createTempFile("xmlComp-", ".xml");
                        logger.info("downloading " + path + " to " + tmp.getPath());
                        local.download(tmp.getPath(), path);
                        toDelete.add(tmp.getPath());
                        path = tmp.getPath();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        formatter.printHelp(cmdLineSyntax, options);
                        System.exit(1);
                    }
                }
            }
            if ((toLoad = Xml.parseFile(path)).exists()) {
                comp.load((String)name, Xml.parseFile(path));
            } else {
                logger.error("missing {}", (Object)toLoad.getName());
                formatter.printHelp(cmdLineSyntax, options);
                System.exit(1);
            }
        });
        if (comp.criteriaCount() == 0) {
            XmlComparison.standaloneXml(comp);
        }
        List<Entry> diffs = comp.getDiffs();
        int nameWidth = comp.xmlNames().stream().mapToInt(String::length).max().orElse(1);
        boolean c = cmd.hasOption("color");
        diffs.forEach(entry -> {
            logger.info("{}}{}{}", new Object[]{c ? "\u001b[94m" : "", entry.getPath(), c ? "\u001b[0m" : ""});
            entry.keys().forEach(key -> {
                String value = entry.value((String)key);
                logger.info(String.format("  %s%" + nameWidth + "s%s : %s%n", c ? "\u001b[97m" : "", key, c ? "\u001b[0m" : "", value.contains("\n") ? "\n    " + value.replaceAll("\n", "\n    ") : value));
            });
        });
        if (!toDelete.isEmpty()) {
            toDelete.forEach(deleteMe -> {
                File f = new File((String)deleteMe);
                if (f.exists()) {
                    f.delete();
                }
            });
        }
    }

    public void setOrdered() {
        this.ordered = true;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void addCriteria(String path, int editDistance) {
        this.criteria.put(XmlPath.parse(path), editDistance);
    }

    public int criteriaCount() {
        return this.criteria.size();
    }

    public int xmlCount() {
        return this.rootXmls.size();
    }

    public Set<String> xmlNames() {
        return this.rootXmls.keySet();
    }

    public void load(String name, Xml xml) {
        if (xml.exists()) {
            if (!this.rootXmls.containsKey(name)) {
                this.rootXmls.put(name, xml);
            }
        } else {
            logger.error("cannot load " + name + " xml is invalid " + xml);
        }
    }

    public List<Entry> getDiffs() {
        if (this.rootXmls.size() <= 1) {
            return Collections.emptyList();
        }
        LinkedList<Entry> rtrn = new LinkedList<Entry>();
        this.diff("", rtrn, this.rootXmls);
        return rtrn;
    }

    private void diff(String path, List<Entry> diffs, Map<String, Xml> xmls) {
        if (this.isEmtpy(xmls)) {
            return;
        }
        if (this.hasNull(xmls)) {
            logger.error("THIS SHOULD BE CAUGHT BEFORE THIS POINT FOR ALL SUB_CALLS");
            Entry newEntry = new Entry(path);
            xmls.forEach((xmlName, xml) -> newEntry.put(xmlName, xml.documentString()));
            diffs.add(newEntry);
        } else {
            this.diffAttributes(path, diffs, xmls);
            this.diffValues(path, diffs, xmls);
            if (!this.ordered) {
                Map<String, XmlNamedChildren> namedChildrenMap = XmlComparison.buildNamedChildren(xmls);
                while (0 < namedChildrenMap.entrySet().stream().mapToInt(e -> ((XmlNamedChildren)e.getValue()).size()).sum()) {
                    LinkedHashMap<String, Xml> toDiff = new LinkedHashMap<String, Xml>();
                    Xml firstChild = this.firstChildXml(namedChildrenMap);
                    if (firstChild.exists()) {
                        String firstChildName = firstChild.getName();
                        for (String rootName : namedChildrenMap.keySet()) {
                            XmlNamedChildren namedChildren = namedChildrenMap.get(rootName);
                            int bestScore = Integer.MAX_VALUE;
                            int bestIndex = -1;
                            Xml matched = Xml.INVALID;
                            if (namedChildren.has(firstChildName)) {
                                XmlChildList childList = namedChildren.get(firstChildName);
                                for (int i = 0; i < childList.size(); ++i) {
                                    Xml childEntry = childList.get(i);
                                    int childScore = this.getScore(firstChild, childEntry);
                                    if (childScore >= bestScore) continue;
                                    bestScore = childScore;
                                    bestIndex = i;
                                    matched = childEntry;
                                }
                                if (bestIndex > -1) {
                                    childList.remove(bestIndex);
                                }
                            }
                            toDiff.put(rootName, matched);
                        }
                        if (toDiff.size() != namedChildrenMap.size()) {
                            logger.error("toDiff " + toDiff.keySet() + "\n  namedChildren=" + namedChildrenMap.keySet());
                        }
                        StringBuffer toAdd = new StringBuffer("/");
                        boolean inAttribute = false;
                        toAdd.append(firstChildName);
                        for (XmlPath xmlPath : this.criteria.keySet()) {
                            int limit = this.criteria.get(xmlPath);
                            List<Xml> match = xmlPath.getMatches(firstChild);
                            if (match.size() == 1) {
                                if (inAttribute) {
                                    toAdd.append(" AND ");
                                } else {
                                    inAttribute = true;
                                    toAdd.append("[ ");
                                }
                                String xmlPathString = xmlPath.toString();
                                if (xmlPathString.startsWith("/")) {
                                    xmlPathString = xmlPathString.substring(1);
                                }
                                if (xmlPathString.startsWith(firstChildName)) {
                                    xmlPathString = xmlPathString.substring(firstChildName.length());
                                }
                                if (xmlPathString.startsWith("/")) {
                                    xmlPathString = xmlPathString.substring(1);
                                }
                                toAdd.append(xmlPathString);
                                if (!match.get(0).exists()) continue;
                                if (XmlPath.Method.Equals.equals((Object)xmlPath.getMethod())) {
                                    if (limit == 0) {
                                        toAdd.append(XmlPath.Method.Equals.getOperator());
                                    } else {
                                        toAdd.append(XmlPath.Method.StartsWith.getOperator());
                                    }
                                } else {
                                    toAdd.append(xmlPath.getMethod().getOperator());
                                }
                                if (xmlPath.hasValue()) {
                                    toAdd.append(StringUtil.quote(xmlPath.getValue().substring(0, xmlPath.getValue().length() - limit)));
                                    continue;
                                }
                                toAdd.append(StringUtil.quote(match.get(0).getValue().substring(0, match.get(0).getValue().length() - limit)));
                                continue;
                            }
                            if (match.size() <= 1) continue;
                            logger.error("too many matches by " + xmlPath + "\n  on" + firstChild.toString());
                        }
                        if (inAttribute) {
                            toAdd.append(" ]");
                        }
                        String newPath = path + toAdd.toString();
                        if (this.hasNull(toDiff)) {
                            Entry newEntry = new Entry(path);
                            toDiff.forEach((xmlName, xml) -> newEntry.put(xmlName, xml.documentString()));
                            diffs.add(newEntry);
                        } else {
                            this.diff(newPath, diffs, toDiff);
                        }
                    } else {
                        logger.error("HOW DID WE GET AN INVALID ENTRY?");
                    }
                    try {
                        TimeUnit.SECONDS.sleep(0L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
    }

    private int getScore(Xml base, Xml other) {
        int rtrn = 0;
        if (base.exists() && other.exists()) {
            for (XmlPath xmlPath : this.criteria.keySet()) {
                int limit = this.criteria.get(xmlPath);
                List<Xml> baseMatched = xmlPath.getMatches(base);
                List<Xml> otherMatched = xmlPath.getMatches(other);
                if (baseMatched.size() != otherMatched.size()) {
                    logger.info("different match counts for " + xmlPath + "\n  base " + base.documentString(0) + "\n  baseMatched=" + baseMatched.size() + "\n  other " + other.documentString(0) + "\n  otherMatched=" + baseMatched.size());
                    continue;
                }
                for (int i = 0; i < baseMatched.size(); ++i) {
                    String otherValue;
                    String baseValue = baseMatched.get(i).getValue();
                    int editDistance = StringUtil.editDistance(baseValue, otherValue = otherMatched.get(i).getValue());
                    if (editDistance > limit) {
                        return Integer.MAX_VALUE;
                    }
                    rtrn += editDistance;
                }
            }
            HashSet<String> attributeNames = new HashSet<String>();
            attributeNames.addAll(base.getAttributes().keySet());
            attributeNames.addAll(other.getAttributes().keySet());
            for (String attributeName : attributeNames) {
                if (base.hasAttribute(attributeName) && other.hasAttribute(attributeName)) {
                    String baseValue = base.getAttributes().get(attributeName).getValue();
                    String otherValue = other.getAttributes().get(attributeName).getValue();
                    int editDistance = StringUtil.editDistance(baseValue, otherValue);
                    rtrn += editDistance;
                    continue;
                }
                Xml target = base.hasAttribute(attributeName) ? base : other;
                String value = target.getAttributes().get(attributeName).getValue();
                rtrn += value.length();
                rtrn += attributeName.length();
            }
        } else {
            if (!base.exists() && !other.exists()) {
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        String string = base.getValue().trim();
        String otherValue = other.getValue().trim();
        int editDistance = StringUtil.editDistance(string, otherValue);
        return rtrn += editDistance;
    }

    private Xml firstChildXml(Map<String, XmlNamedChildren> namedChildrenMap) {
        Xml rtrn = Xml.INVALID;
        for (String rootName : namedChildrenMap.keySet()) {
            XmlNamedChildren namedChildren = namedChildrenMap.get(rootName);
            if (namedChildren.isEmpty()) continue;
            rtrn = namedChildren.getFirst();
            return rtrn;
        }
        return rtrn;
    }

    private Set<String> tagNames(Xml xml) {
        return xml.getChildren().stream().map(Xml::getName).collect(Collectors.toSet());
    }

    private boolean isEmtpy(Map<String, Xml> xmls) {
        return xmls.values().stream().map(xml -> xml == null || !xml.exists()).reduce(Boolean::logicalAnd).orElse(false);
    }

    private Xml firstNotNull(Map<String, Xml> xmls) {
        return xmls.values().stream().filter(xml -> xml != null).findAny().orElse(null);
    }

    private boolean hasNull(Map<String, Xml> xmls) {
        boolean rtrn = false;
        for (Xml xml : xmls.values()) {
            if (xml != null && xml.exists()) continue;
            rtrn = true;
            return true;
        }
        return rtrn;
    }

    private boolean allSameAttributeValue(String attributeName, Map<String, Xml> xmls) {
        String firstKey = this.firstKey(xmls.keySet());
        String firstValue = xmls.get(firstKey).attribute(attributeName).getValue();
        return xmls.values().stream().map(xml -> xml.attribute(attributeName).getValue().equals(firstValue)).reduce(Boolean::logicalAnd).orElse(true);
    }

    private void diffValues(String path, List<Entry> diffs, Map<String, Xml> xmls) {
        if (xmls.isEmpty()) {
            return;
        }
        List values = xmls.values().stream().map(xml -> xml.getValue().trim()).collect(Collectors.toList());
        HashSet uniqueValues = new HashSet(values);
        if (uniqueValues.size() > 1) {
            Entry newEntry = new Entry(path);
            for (String key : xmls.keySet()) {
                newEntry.put(key, xmls.get(key).getValue().trim());
            }
            diffs.add(newEntry);
        }
    }

    private void diffAttributes(String tagPath, List<Entry> diffs, Map<String, Xml> xmls) {
        if (xmls.isEmpty()) {
            return;
        }
        String firstKey = this.firstKey(xmls.keySet());
        Set<String> firstAttributes = xmls.get(firstKey).getAttributes().keySet();
        Set allAttributes = xmls.values().stream().flatMap(x -> x.getAttributes().keySet().stream()).collect(Collectors.toSet());
        Set<String> notInFirst = Sets.unique(allAttributes, firstAttributes);
        firstAttributes.forEach(key -> {
            boolean isSame = this.allSameAttributeValue((String)key, xmls);
            if (!isSame) {
                Entry newEntry = new Entry(tagPath + "/@" + key);
                xmls.forEach((xmlName, xml) -> newEntry.put(xmlName, xml.attribute((String)key).getValue()));
                diffs.add(newEntry);
            }
        });
        notInFirst.forEach(key -> {
            Entry newEntry = new Entry(tagPath + "/@" + key);
            xmls.forEach((xmlName, xml) -> newEntry.put(xmlName, xml.attribute((String)key).getValue()));
            diffs.add(newEntry);
        });
    }

    private String firstKey(Set<String> set) {
        return set.iterator().next();
    }

    public static class Entry {
        private String path;
        private LinkedHashMap<String, String> values;

        public Entry(String path) {
            this.path = path;
            this.values = new LinkedHashMap();
        }

        private void put(String name, String value) {
            this.values.put(name, value);
        }

        public String getPath() {
            return this.path;
        }

        public Set<String> keys() {
            return this.values.keySet();
        }

        public String value(String key) {
            return this.values.get(key);
        }

        public void forEach(BiConsumer<String, String> consumer) {
            this.values.forEach(consumer);
        }
    }

    private static class XmlChildList {
        private List<Xml> data = new ArrayList<Xml>();
        private XmlNamedChildren namedChildren;

        public XmlChildList(XmlNamedChildren namedChildren) {
            this.namedChildren = namedChildren;
        }

        public int size() {
            return this.data.size();
        }

        public void add(Xml xml) {
            this.data.add(xml);
        }

        public void remove(Xml xml) {
            this.namedChildren.remove(xml);
            this.data.remove(xml);
            if (this.data.isEmpty()) {
                this.namedChildren.remove(xml.getName());
            }
        }

        public void remove(int index) {
            if (index < this.data.size()) {
                Xml toRemove = this.data.get(index);
                this.namedChildren.remove(toRemove);
                this.data.remove(index);
            }
        }

        public Xml get(int index) {
            return this.data.get(index);
        }
    }

    private static class XmlNamedChildren {
        private List<Xml> allChildren = new ArrayList<Xml>();
        private Map<String, XmlChildList> namedChildren = new LinkedHashMap<String, XmlChildList>();

        public boolean has(String name) {
            return this.namedChildren.containsKey(name);
        }

        public void add(Xml child) {
            String name = child.getName();
            if (!this.namedChildren.containsKey(name)) {
                this.namedChildren.put(name, new XmlChildList(this));
            }
            this.allChildren.add(child);
            this.namedChildren.get(name).add(child);
        }

        public Xml getFirst() {
            return this.allChildren.get(0);
        }

        public void remove(Xml child) {
            this.allChildren.remove(child);
        }

        public void remove(String name) {
            this.namedChildren.remove(name);
        }

        public boolean isEmpty() {
            return this.allChildren.size() == 0;
        }

        public XmlChildList get(String tagName) {
            return this.namedChildren.get(tagName);
        }

        public int size() {
            return this.allChildren.size();
        }

        public String debug() {
            StringBuffer sb = new StringBuffer();
            for (String name : this.namedChildren.keySet()) {
                sb.append(name + "\n");
                sb.append("  " + this.namedChildren.get(name).data + "\n");
            }
            return sb.toString();
        }
    }
}

