/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.xml.pojo;

import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.xml.pojo.Xml;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class XmlPath {
    static final XLogger logger = XLoggerFactory.getXLogger(MethodHandles.lookup().lookupClass());
    private Scope scope = Scope.Relative;
    private String name;
    private String value;
    private Method method = Method.Equals;
    private Type type = Type.Undefined;
    private List<XmlPath> children;
    private XmlPath next;
    private XmlPath prev;
    private XmlPath parent;
    private boolean isFirst = false;
    private boolean isCriteria = false;

    private static XmlPath error(String error) {
        return new XmlPath(error);
    }

    public static XmlPath parse(String path) {
        int index = 0;
        XmlPath rtrn = new XmlPath(Type.Start);
        Stack<XmlPath> parentStack = new Stack<XmlPath>();
        parentStack.push(rtrn);
        Stack<State> state = new Stack<State>();
        state.push(State.Path);
        int previousLoopIndex = index - 1;
        String operators = Arrays.asList(Method.values()).stream().map(m -> "" + m.getOperator()).collect(Collectors.joining(""));
        operators = StringUtil.escapeRegex(operators);
        Matcher pathMatcher = Pattern.compile("(?<prefix>\\.{0,2}/{0,2})(?<attr>@?)(?<name>[^'\"\\s,/\\(\\[\\]@" + operators + "]+)(?<suffix>[\\(\\[/]?).*").matcher(path);
        HashSet<Character> methodOperators = new HashSet<Character>();
        for (int i = 0; i < Method.values().length; ++i) {
            methodOperators.add(Character.valueOf(Method.values()[i].getOperator()));
        }
        while (previousLoopIndex < index && index < path.length()) {
            int nonSpaceIndex;
            int nonSpaceIndex2;
            previousLoopIndex = index;
            if (path.startsWith(")", index)) {
                if (!State.Function.equals(state.peek())) {
                    return XmlPath.error("unexpected close function arguments ')' @ " + index + " in " + path);
                }
                parentStack.pop();
                state.pop();
                index = nonSpaceIndex2 = StringUtil.indexNotMatching(path, "     ", index + 1);
                continue;
            }
            if (path.startsWith("]", index)) {
                if (!State.Criteria.equals(state.peek())) {
                    return XmlPath.error("unexpected close criteria ']' @ " + index + " in " + path);
                }
                parentStack.pop();
                state.pop();
                index = nonSpaceIndex2 = StringUtil.indexNotMatching(path, "     ", index + 1);
                continue;
            }
            if (path.startsWith(",", index)) {
                int nonSpaceIndex3;
                if (!State.Function.equals(state.peek())) {
                    return XmlPath.error("unexpected function argument separator ',' @ " + index + " in " + path);
                }
                parentStack.pop();
                XmlPath newStart = new XmlPath(Type.Start);
                ((XmlPath)parentStack.peek()).addChild(newStart);
                parentStack.push(newStart);
                index = nonSpaceIndex3 = StringUtil.indexNotMatching(path, "     ", index + 1);
                continue;
            }
            if (methodOperators.contains(Character.valueOf(path.charAt(index)))) {
                int nonSpaceIndex4;
                char operatorChar = path.charAt(index);
                Method method = Arrays.asList(Method.values()).stream().filter(m -> operatorChar == m.getOperator()).findFirst().orElse(Method.Undefined);
                if (Type.Start.equals((Object)((XmlPath)parentStack.peek()).getType())) {
                    return XmlPath.error("unexpected value comparison = @ " + index + " in " + path);
                }
                ((XmlPath)parentStack.peek()).setMethod(method);
                index = nonSpaceIndex4 = StringUtil.indexNotMatching(path, "     ", index + 1);
                continue;
            }
            if (path.startsWith("[", index)) {
                int closeIndex = StringUtil.indexNotMatching(path, "1234567890", index + 1);
                String criteria = path.substring(index + 1, closeIndex);
                if (criteria.isEmpty() || !criteria.matches("\\d+")) continue;
                XmlPath childIndex = new XmlPath(Type.Index);
                childIndex.setMethod(Method.Equals);
                childIndex.setName(criteria);
                ((XmlPath)parentStack.peek()).setNext(childIndex);
                parentStack.push(childIndex);
                index = closeIndex + 1;
                continue;
            }
            if (path.startsWith("'", index) || path.startsWith("\"", index)) {
                int nonSpaceIndex5;
                int closeIndex;
                if (Type.Start.equals((Object)((XmlPath)parentStack.peek()).getType())) {
                    return XmlPath.error("unexpected string constant @ " + index + " in " + path);
                }
                char quoteChar = path.charAt(index);
                for (closeIndex = index + 1; closeIndex < path.length() && quoteChar != path.charAt(closeIndex) || closeIndex > 1 && '/' == path.charAt(closeIndex - 1); ++closeIndex) {
                }
                if (closeIndex == path.length()) {
                    return XmlPath.error("failed to find closing " + quoteChar + " which starts @ " + index + " in " + path);
                }
                String quotedValue = path.substring(index + 1, closeIndex);
                ((XmlPath)parentStack.peek()).setValue(quotedValue);
                index = nonSpaceIndex5 = StringUtil.indexNotMatching(path, "     ", ++closeIndex);
                continue;
            }
            if (State.Criteria.equals(state.peek()) && "0123456789".contains("" + path.charAt(index))) {
                int notSpace;
                int nonDigit = StringUtil.indexNotMatching(path, "1234567890", index);
                String digits = path.substring(index, nonDigit);
                ((XmlPath)parentStack.peek()).setValue(digits);
                index = nonDigit;
                index = notSpace = StringUtil.indexNotMatching(path, "   ", index);
                continue;
            }
            if (State.Criteria.equals(state.peek()) && (path.startsWith("and", index) || path.startsWith("AND", index))) {
                int nonSpaceIndex6;
                parentStack.pop();
                XmlPath newStart = new XmlPath(Type.Start);
                ((XmlPath)parentStack.peek()).addChild(newStart);
                parentStack.push(newStart);
                index = nonSpaceIndex6 = StringUtil.indexNotMatching(path, "     ", index + "and".length());
                continue;
            }
            if (!pathMatcher.reset(path.substring(index)).matches()) continue;
            String prefix = pathMatcher.group("prefix");
            String attr = pathMatcher.group("attr");
            String name = pathMatcher.group("name");
            String suffix = pathMatcher.group("suffix");
            Type type = Type.Tag;
            Scope scope = Scope.Relative;
            if ("@".equals(attr)) {
                type = Type.Attribute;
            } else if ("(".equals(suffix)) {
                type = Type.Function;
            }
            if ("/".equals(prefix)) {
                if (!Type.Start.equals((Object)((XmlPath)parentStack.peek()).getType())) {
                    scope = index > 0 && '/' == path.charAt(index - 1) ? Scope.Descendant : Scope.Absolute;
                }
            } else if ("//".equals(prefix)) {
                scope = Scope.Descendant;
            } else if (!"".equals(prefix)) {
                if ("./".equals(prefix)) {
                    return XmlPath.error("unsupported scope=[" + prefix + "] @ " + index + " in " + path);
                }
                return XmlPath.error("unsupported scope=[" + prefix + "] @ " + index + " in " + path);
            }
            XmlPath nextPath = new XmlPath(type);
            nextPath.setName(name);
            nextPath.setScope(scope);
            ((XmlPath)parentStack.peek()).setNext(nextPath);
            parentStack.pop();
            parentStack.push(nextPath);
            if ("[".equals(suffix)) {
                int suffixIndex = index + pathMatcher.end("suffix");
                int closeIndex = path.indexOf("]", suffixIndex);
                if (closeIndex > suffixIndex && path.substring(suffixIndex, closeIndex).matches("\\d+")) {
                    String criteria = path.substring(suffixIndex, closeIndex);
                    XmlPath childIndex = new XmlPath(Type.Index);
                    childIndex.setName(criteria);
                    index += closeIndex - suffixIndex + "]".length();
                    ((XmlPath)parentStack.peek()).addChild(childIndex);
                    parentStack.pop();
                    parentStack.push(childIndex);
                } else {
                    XmlPath newStart = new XmlPath(Type.Start);
                    ((XmlPath)parentStack.peek()).addChild(newStart);
                    parentStack.push(newStart);
                    state.push(State.Criteria);
                }
            } else if ("(".equals(suffix)) {
                if (index + pathMatcher.end("suffix") < path.length() && ')' == path.charAt(index + pathMatcher.end("suffix"))) {
                    ++index;
                } else {
                    XmlPath newStart = new XmlPath(Type.Start);
                    ((XmlPath)parentStack.peek()).addChild(newStart);
                    parentStack.push(newStart);
                    state.push(State.Function);
                }
            } else if (!"/".equals(suffix) && !"".equals(suffix)) {
                return XmlPath.error("unknown path separator [" + suffix + "] @ " + (index + pathMatcher.start("suffix")) + " in " + path);
            }
            index = nonSpaceIndex = StringUtil.indexNotMatching(path, "     ", index + pathMatcher.end("suffix"));
        }
        if (index < path.length()) {
            return XmlPath.error("failed to parse @ " + index + " in " + path);
        }
        return rtrn;
    }

    public boolean equals(Object other) {
        boolean rtrn = false;
        if (other instanceof XmlPath) {
            XmlPath otherPath = (XmlPath)other;
            rtrn = this.scope == otherPath.scope && this.getName() == otherPath.getName() && this.getType() == otherPath.getType() && this.getValue() == otherPath.getValue() && this.getMethod() == otherPath.getMethod() && this.isChild() == otherPath.isChild() && this.isFirst == otherPath.isFirst;
        }
        return rtrn;
    }

    public XmlPath(Type type) {
        this.type = type;
        this.children = new ArrayList<XmlPath>();
    }

    private XmlPath(String error) {
        this(Type.Undefined);
        this.name = "Error: ";
        this.value = error;
    }

    public int size() {
        int rtrn = 1;
        XmlPath target = this;
        while (target.hasNext()) {
            target = target.getNext();
            ++rtrn;
        }
        return rtrn;
    }

    public XmlPath getTail() {
        XmlPath rtrn = this;
        while (rtrn.hasNext()) {
            rtrn = rtrn.getNext();
        }
        return rtrn;
    }

    public XmlPath copy() {
        if (!this.isValid()) {
            return new XmlPath(this.getValue());
        }
        XmlPath rtrn = new XmlPath(this.getType());
        rtrn.setScope(this.getScope());
        rtrn.setName(this.getName());
        rtrn.setValue(this.getValue());
        rtrn.setMethod(this.getMethod());
        rtrn.isFirst = this.isFirst;
        rtrn.isCriteria = this.isCriteria;
        if (this.hasNext()) {
            rtrn.setNext(this.getNext().copy());
        }
        if (!this.getChildren().isEmpty()) {
            for (XmlPath child : this.getChildren()) {
                rtrn.addChild(child.copy());
            }
        }
        return rtrn;
    }

    private Scope getScope() {
        return this.scope;
    }

    public void dropNext() {
        if (this.hasNext()) {
            if (this.getNext().hasParent()) {
                this.getNext().getParent().children.remove(this.getNext());
            }
            this.next = null;
        }
    }

    public void drop() {
        if (this.hasPrevious()) {
            this.getPrevious().next = null;
        }
        if (this.hasParent()) {
            this.getParent().children.remove(this);
        }
    }

    private void setNext(XmlPath next) {
        this.next = next;
        next.prev = this;
        if (Type.Start.equals((Object)this.getType())) {
            next.isFirst = true;
        }
        if (this.isChild()) {
            next.setParent(this.getParent());
        }
    }

    private void setParent(XmlPath parent) {
        for (XmlPath target = this; target != null; target = target.getNext()) {
            target.isCriteria = true;
            target.parent = parent;
        }
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public XmlPath getParent() {
        return this.parent;
    }

    public boolean isChild() {
        return this.isCriteria;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean hasPrevious() {
        return this.prev != null;
    }

    public XmlPath getPrevious() {
        return this.prev;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public XmlPath getNext() {
        return this.next;
    }

    private void setScope(Scope scope) {
        this.scope = scope;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setValue(String value) {
        this.value = value;
    }

    private void setMethod(Method method) {
        this.method = method;
    }

    private void addChild(XmlPath child) {
        this.children.add(child);
        child.setParent(this);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<XmlPath> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean isDescendant() {
        return this.scope.equals((Object)Scope.Descendant);
    }

    public boolean isRelative() {
        return this.scope.equals((Object)Scope.Relative);
    }

    public boolean isAbsoulte() {
        return this.scope.equals((Object)Scope.Absolute);
    }

    public boolean isValid() {
        return !Type.Undefined.equals((Object)this.getType());
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getValue() {
        return this.value;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb, true);
        return sb.toString();
    }

    public String toString(boolean recursive) {
        StringBuilder sb = new StringBuilder();
        this.append(sb, recursive);
        return sb.toString();
    }

    public List<Xml> getMatches(Xml xml) {
        ArrayList<Xml> toMatch = new ArrayList<Xml>();
        ArrayList<Xml> matches = new ArrayList<Xml>();
        matches.add(xml);
        XmlPath target = this;
        do {
            ArrayList<Xml> tmp = toMatch;
            toMatch = matches;
            matches = tmp;
            matches.clear();
            if (target.isDescendant()) {
                for (int i = 0; i < toMatch.size(); ++i) {
                    Xml entry = (Xml)toMatch.get(i);
                    toMatch.addAll(entry.getChildren());
                }
            }
            target.collectMatches(toMatch, matches);
        } while (!matches.isEmpty() && (target = target.getNext()) != null);
        return matches;
    }

    public void collectMatches(List<Xml> toCheck, List<Xml> matches) {
        block11: for (Xml xml : toCheck) {
            if (Type.Start.equals((Object)this.getType())) {
                if (xml.isDocument()) {
                    matches.addAll(xml.getChildren());
                } else {
                    matches.add(xml);
                }
            }
            if (Type.Attribute.equals((Object)this.getType())) {
                boolean rtrn = true;
                Xml attributeXml = xml.getAttributes().get(this.getName());
                if (attributeXml == null) {
                    rtrn = false;
                } else {
                    String xmlPathValue = this.getValue();
                    String attributeValue = attributeXml.getValue();
                    if (xmlPathValue != null) {
                        boolean bl = rtrn = rtrn && this.methodMatch(attributeValue);
                    }
                }
                if (!rtrn) continue;
                matches.add(attributeXml);
                continue;
            }
            if (Type.Tag.equals((Object)this.getType())) {
                if (this.isFirst() && !this.isChild()) {
                    boolean rtrn = true;
                    boolean bl = rtrn = rtrn && this.getName().equals(xml.getName());
                    if (this.hasValue()) {
                        boolean methodMatches = this.methodMatch(xml.getValue());
                        boolean bl2 = rtrn = rtrn && methodMatches;
                    }
                    if (rtrn && !this.getChildren().isEmpty()) {
                        List<XmlPath> pathChildren = this.getChildren();
                        for (int i = 0; i < pathChildren.size() && rtrn; ++i) {
                            XmlPath pathChild = pathChildren.get(i).getNext();
                            List<Xml> matchers = pathChild.getMatches(xml);
                            rtrn = rtrn && !matchers.isEmpty();
                        }
                    }
                    if (!rtrn) continue;
                    matches.add(xml);
                    continue;
                }
                for (Xml child : xml.getChildren()) {
                    boolean rtrn = true;
                    boolean bl = rtrn = rtrn && this.getName().equals(child.getName());
                    if (rtrn && this.hasValue()) {
                        boolean methodMatches = this.methodMatch(child.getValue());
                        boolean bl3 = rtrn = rtrn && methodMatches;
                    }
                    if (rtrn && !this.getChildren().isEmpty()) {
                        List<XmlPath> pathChildren = this.getChildren();
                        for (int i = 0; i < pathChildren.size() && rtrn; ++i) {
                            XmlPath pathChild = pathChildren.get(i);
                            List<Xml> matchers = pathChild.getMatches(child);
                            rtrn = rtrn && !matchers.isEmpty();
                        }
                    }
                    if (!rtrn) continue;
                    matches.add(child);
                }
                continue;
            }
            if (Type.Function.equals((Object)this.getType())) {
                if ("text".equals(this.getName())) {
                    String xmlValue = xml.getValue();
                    if (this.hasValue()) {
                        switch (this.getMethod()) {
                            case Contains: {
                                if (!xmlValue.contains(this.getValue())) continue block11;
                                matches.add(xml.getValueXml());
                                break;
                            }
                            case Equals: {
                                if (!xmlValue.equals(this.getValue())) continue block11;
                                matches.add(xml.getValueXml());
                                break;
                            }
                            case StartsWith: {
                                if (xmlValue.startsWith(this.getValue())) {
                                    matches.add(xml.getValueXml());
                                }
                            }
                            case EndsWith: {
                                if (!xmlValue.endsWith(this.getValue())) continue block11;
                                matches.add(xml.getValueXml());
                                break;
                            }
                            default: {
                                logger.error("text does not support method=" + this.getMethod());
                                break;
                            }
                        }
                        continue;
                    }
                    matches.add(xml.getValueXml());
                    continue;
                }
                if (!"position".equals(this.getName())) continue;
                int position = xml.tagIndex();
                if (!this.getValue().matches("\\d+")) continue;
                int valueInt = Integer.parseInt(this.getValue());
                switch (this.getMethod()) {
                    case Equals: {
                        if (position != valueInt) break;
                        matches.add(xml);
                        break;
                    }
                    case GreaterThan: {
                        if (position <= valueInt) break;
                        matches.add(xml);
                        break;
                    }
                    case LessThan: {
                        if (position >= valueInt) break;
                        matches.add(xml);
                    }
                }
                continue;
            }
            if (!Type.Index.equals((Object)this.getType())) continue;
            int targetIndex = Integer.parseInt(this.getName());
            if (this.isChild()) {
                if (targetIndex != xml.namedIndex()) continue;
                matches.add(xml);
                continue;
            }
            if (xml.getChildren().size() <= targetIndex) continue;
            matches.add(xml.getChildren().get(targetIndex));
        }
    }

    public boolean methodMatch(String foundValue) {
        boolean rtrn = foundValue != null;
        switch (this.getMethod()) {
            case Equals: {
                rtrn = rtrn && foundValue.equals(this.getValue());
                break;
            }
            case StartsWith: {
                rtrn = rtrn && foundValue.startsWith(this.getValue());
                break;
            }
            case EndsWith: {
                rtrn = rtrn && foundValue.endsWith(this.getValue());
                break;
            }
            case Contains: {
                rtrn = rtrn && foundValue.contains(this.getValue());
                break;
            }
            default: {
                rtrn = false;
            }
        }
        return rtrn;
    }

    private void append(StringBuilder sb, boolean recursive) {
        String childWrap;
        if (Type.Attribute.equals((Object)this.getType())) {
            sb.append("@");
        } else if (Type.Tag.equals((Object)this.getType())) {
            if (this.isFirst()) {
                if (Scope.Descendant.equals((Object)this.getScope())) {
                    sb.append("//");
                } else {
                    sb.append("/");
                }
            } else if (Scope.Descendant.equals((Object)this.getScope())) {
                sb.append("//");
            } else {
                sb.append("/");
            }
        } else if (Type.Function.equals((Object)this.getType())) {
            if (this.isFirst()) {
                if (Scope.Descendant.equals((Object)this.getScope())) {
                    sb.append("//");
                } else {
                    sb.append("/");
                }
            } else if (Scope.Descendant.equals((Object)this.getScope())) {
                sb.append("//");
            } else {
                sb.append("/");
            }
        } else if (Type.Index.equals((Object)this.getType()) && !this.isChild()) {
            sb.append("/[");
        }
        if (!Type.Start.equals((Object)this.getType())) {
            sb.append(this.getName());
        }
        List<XmlPath> children = this.getChildren();
        String string = childWrap = Type.Function.equals((Object)this.getType()) ? "()" : "[]";
        if (!children.isEmpty()) {
            sb.append(childWrap.charAt(0));
            for (int i = 0; i < children.size(); ++i) {
                if (i > 0) {
                    sb.append(" and ");
                }
                XmlPath child = children.get(i);
                child.append(sb, recursive);
            }
            sb.append(childWrap.charAt(1));
        } else if (Type.Function.equals((Object)this.getType())) {
            sb.append("()");
        }
        if (Type.Index.equals((Object)this.getType()) && !this.isChild()) {
            sb.append("]");
        }
        if (this.hasValue()) {
            sb.append(" ");
            sb.append(this.method.getOperator());
            sb.append(" ");
            sb.append(this.getValue());
        }
        if (recursive && this.hasNext()) {
            this.getNext().append(sb, recursive);
        }
    }

    private static enum State {
        Path,
        Criteria,
        Function;

    }

    public static enum Type {
        Undefined,
        Start,
        Tag,
        Attribute,
        Function,
        Index;

    }

    public static enum Method {
        Undefined('?'),
        Equals('='),
        StartsWith('^'),
        EndsWith('$'),
        Contains('~'),
        GreaterThan('>'),
        LessThan('<');

        private char operator;

        private Method(char operator) {
            this.operator = operator;
        }

        public char getOperator() {
            return this.operator;
        }
    }

    public static enum Scope {
        Descendant,
        Absolute,
        Relative;

    }
}

