/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup;

import java.util.List;
import java.util.function.Function;

public class AsciiArt {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_MAGENTA = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_LIGHT_GREY = "\u001b[37m";
    public static final String ANSI_DARK_GREY = "\u001b[90m";
    public static final String ANSI_LIGHT_RED = "\u001b[91m";
    public static final String ANSI_LIGHT_GREEN = "\u001b[92m";
    public static final String ANSI_LIGHT_YELLOW = "\u001b[93m";
    public static final String ANSI_LIGHT_BLUE = "\u001b[94m";
    public static final String ANSI_LIGHT_MAGENTA = "\u001b[95m";
    public static final String ANSI_LIGHT_CYAN = "\u001b[96m";
    public static final String ANSI_WHITE = "\u001b[97m";
    private static String KMG_SUFFIX = "KMGTPEZY";
    public static String CHECKED = "\u2713";
    public static String XED = "\u2715";
    public static String BOX = "\u2610";
    public static String BOX_CHECKED = "\u2611";
    public static String BULLET = "\u25e6";
    public static String HORIZ_SCALE = " \u2581\u2582\u2583\u2584\u2585\u2586\u2587\u2588";
    public static String VERT_SCALE = " \u258f\u258e\u258d\u258c\u258b\u258a\u2589\u2588";
    public static String TRIANGLE_RIGHT = "\u25b6";
    public static String TRIANGLE_LEFT = "\u25c0";
    public static String DOUBLE_RIGHT = "\u226b";
    public static String DOUBLE_LEFT = "\u226a";
    public static String TREE_OFFSET_SPACE = "   ";
    public static String TREE_OFFSET_SUB_CHILD = " \u2502 ";
    public static String TREE_CHILD = " \u251c ";
    public static String TREE_CHILD_LAST = " \u2514 ";
    public static String ELLIPSIS = "\u2026";

    public static String printKMG(double bytes) {
        return AsciiArt.printKMG(bytes, 2);
    }

    public static String printKMG(double bytes, int precision) {
        double amnt;
        int index = -1;
        for (amnt = bytes; amnt >= 1024.0 && index < KMG_SUFFIX.length() - 1; amnt /= 1024.0, ++index) {
        }
        return String.format("%." + precision + "f%sB", amnt, index > -1 ? Character.valueOf(KMG_SUFFIX.charAt(index)) : "");
    }

    public static String termGoto(int row, int column) {
        return "\u001b[" + row + ";" + column + "H";
    }

    public static char horiz(double value) {
        return AsciiArt.horiz(value, 100.0);
    }

    public static char horiz(double value, double maxValue) {
        double hIdx = 1.0 * value / maxValue * (double)(HORIZ_SCALE.length() - 1);
        return HORIZ_SCALE.charAt((int)hIdx);
    }

    public static String vert(double value) {
        return AsciiArt.vert(value, 100.0, 13, true);
    }

    public static String vert(double value, double maxValue, int width, boolean fill) {
        StringBuilder rtrn = new StringBuilder();
        int denom = VERT_SCALE.length() * width;
        double sizer = maxValue / (1.0 * (double)denom);
        int vIdx = (int)Math.floor(value / sizer) % VERT_SCALE.length();
        int vSp = (int)(value / sizer) / VERT_SCALE.length();
        for (int i = 0; i < width; ++i) {
            if (i < vSp) {
                rtrn.append(VERT_SCALE.charAt(VERT_SCALE.length() - 1));
                continue;
            }
            if (i == vSp) {
                rtrn.append(VERT_SCALE.charAt(vIdx));
                continue;
            }
            if (fill) {
                rtrn.append(VERT_SCALE.charAt(0));
                continue;
            }
            return rtrn.toString();
        }
        return rtrn.toString();
    }

    protected static <T> void printTreeAppend(T target, Function<T, List<T>> getChildren, Function<T, String> printFunction, StringBuilder sb, String prefix, boolean isTopLevel, boolean isLastChild) {
        sb.append(prefix);
        if (!isTopLevel) {
            if (isLastChild) {
                sb.append(TREE_CHILD_LAST);
            } else {
                sb.append(TREE_CHILD);
            }
        }
        if (printFunction == null) {
            sb.append(target.toString());
        } else {
            sb.append(printFunction.apply(target));
        }
        List<T> children = getChildren.apply(target);
        if (!children.isEmpty()) {
            String newChildPrefix = prefix + TREE_OFFSET_SUB_CHILD;
            String newSpacePrefix = prefix + TREE_OFFSET_SPACE;
            for (int i = 0; i < children.size(); ++i) {
                T child = children.get(i);
                sb.append(System.lineSeparator());
                String newPrefix = isTopLevel ? "" : (isLastChild ? newSpacePrefix : newChildPrefix);
                AsciiArt.printTreeAppend(child, getChildren, printFunction, sb, newPrefix, false, i == children.size() - 1);
            }
        }
    }

    public static <T> String printTree(T target, Function<T, List<T>> getChildren) {
        return AsciiArt.printTree(target, getChildren, null);
    }

    public static <T> String printTree(T target, Function<T, List<T>> getChildren, Function<T, String> printFunction) {
        StringBuilder rtrn = new StringBuilder();
        AsciiArt.printTreeAppend(target, getChildren, printFunction, rtrn, "", true, true);
        return rtrn.toString();
    }

    public static String abLine(double a, double b, double max, int width, boolean fill) {
        String both = "\u2588";
        String top = "\u2580";
        String bot = "\u2584";
        StringBuilder rtrn = new StringBuilder();
        double denom = 1.0 * max / (double)width;
        int aWidth = (int)(1.0 * a / max * (double)width);
        int bWidth = (int)(1.0 * b / max * (double)width);
        for (int i = 1; i <= width; ++i) {
            if (i <= aWidth && i <= bWidth) {
                rtrn.append(both);
                continue;
            }
            if (i <= aWidth) {
                rtrn.append(top);
                continue;
            }
            if (i <= bWidth) {
                rtrn.append(bot);
                continue;
            }
            if (fill) {
                rtrn.append(" ");
                continue;
            }
            return rtrn.toString();
        }
        return rtrn.toString();
    }
}

