/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;

public class BinCounter {
    private ArrayList<LongAdder> counts = new ArrayList();
    private Long[] bins;

    public BinCounter(Long ... bins) {
        if (bins != null && bins.length > 0) {
            Long[] longArray = bins;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long bin = longArray[i];
                this.counts.add(new LongAdder());
            }
        }
        this.counts.add(new LongAdder());
        this.bins = bins;
    }

    public void add(long value) {
        int index = this.findBin(value);
        this.counts.get(index).increment();
    }

    public long count(Long value) {
        int index = this.findBin(value);
        return this.counts.get(index).longValue();
    }

    public long getOverflow(Long value) {
        return this.counts.get(this.bins.length).longValue();
    }

    public List<Long> getBins() {
        List<Long> rtrn = Arrays.asList(this.bins);
        return rtrn;
    }

    private int findBin(Long value) {
        return Arrays.binarySearch((Object[])this.bins, value);
    }
}

