/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup;

import io.hyperfoil.tools.yaup.json.Json;
import io.hyperfoil.tools.yaup.json.JsonValidator;
import io.hyperfoil.tools.yaup.xml.XmlOperation;
import io.hyperfoil.tools.yaup.xml.pojo.Xml;
import io.hyperfoil.tools.yaup.xml.pojo.XmlComparison;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class Yaup {
    static final XLogger logger = XLoggerFactory.getXLogger(MethodHandles.lookup().lookupClass());

    public static void main(String[] vargs) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(vargs));
        if (!args.isEmpty()) {
            String tool = (String)args.remove(0);
            logger.debug("tool: " + tool);
            for (int i = 0; i < args.size(); ++i) {
                logger.trace("  arg[%2d]: %s%n", (Object)i, args.get(i));
            }
            switch (tool) {
                case "xml": {
                    XmlOperation operation;
                    Xml doc;
                    if (args.size() < 2) {
                        logger.error("xml expects <operation> <file-path>%n");
                        System.exit(1);
                    }
                    if ((doc = Xml.parseFile((String)args.get(1))) == null || !doc.exists()) {
                        logger.error("failed to load %s as xml %n", args.get(1));
                        System.exit(1);
                    }
                    if ((operation = XmlOperation.parse((String)args.get(0))) == null) {
                        logger.error("failed to identify xml operation %s%n", args.get(0));
                        System.exit(1);
                    }
                    String response = doc.apply(operation);
                    logger.info("response:%n%s", (Object)response);
                    break;
                }
                case "xml-diff": {
                    XmlComparison.main(args.toArray(new String[0]));
                    break;
                }
                case "json-schema": {
                    if (args.size() != 2) {
                        logger.error("json-schema expects <schema-path> <json-path>");
                        System.exit(1);
                        break;
                    }
                    Json schemaJson = Json.fromFile((String)args.get(0));
                    Json dataJson = Json.fromFile((String)args.get(1));
                    JsonValidator validator = new JsonValidator(schemaJson);
                    Json errors = validator.validate(dataJson);
                    logger.info(errors.toString());
                }
            }
        }
    }
}

