/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.file;

import io.hyperfoil.tools.yaup.HashedLists;
import io.hyperfoil.tools.yaup.Sets;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileUtility {
    private static final HashedLists<Format, int[]> magic_numbers = new HashedLists();
    public static final String ARCHIVE_KEY = "#";
    public static final String SEARCH_KEY = ">";
    public static final String REMOTE_KEY = ":";
    public static int OPERATION_LENGTH;
    public static final String ADD_OPERATION = "++";
    public static final String DELETE_OPERATION = "--";
    public static final String SET_OPERATION = "==";
    public static final Set<String> OPERATIONS;

    public static List<String> getFiles(String baseDir, String nameSubstring, boolean recursive) {
        return FileUtility.search(baseDir, nameSubstring, recursive, true, false, false);
    }

    public static List<String> getFiles(String baseDir, String nameSubstring, boolean recursive, boolean inArchive) {
        return FileUtility.search(baseDir, nameSubstring, recursive, true, false, inArchive);
    }

    public static List<String> getDirectories(String baseDir, String nameSubstring, boolean recursive) {
        return FileUtility.search(baseDir, nameSubstring, recursive, false, true, false);
    }

    public static boolean isArchiveEntryPattern(String fileName) {
        return fileName != null && fileName.contains(ARCHIVE_KEY);
    }

    public static boolean isArchiveEntryPath(String fileName) {
        if (!FileUtility.isArchiveEntryPattern(fileName)) {
            return false;
        }
        File parentFile = new File(fileName.substring(0, fileName.indexOf(ARCHIVE_KEY)));
        File tmpFile = new File(fileName);
        return !tmpFile.exists() && parentFile.exists();
    }

    private static InputStream wrapStream(InputStream stream, String path) throws IOException {
        InputStream rtrn = stream;
        if (path.endsWith(".tar.gz") || path.endsWith(".tgz")) {
            rtrn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(stream));
        } else if (path.endsWith(".gz")) {
            rtrn = new GzipCompressorInputStream(stream);
        } else if (path.endsWith(".tar")) {
            rtrn = new TarArchiveInputStream(stream);
        } else if (path.endsWith(".zip")) {
            rtrn = new ZipArchiveInputStream(stream);
        } else if (path.endsWith(".Z")) {
            rtrn = new ZCompressorInputStream(stream);
        } else if (path.endsWith(".tar.bz2") || path.endsWith("tbz2")) {
            rtrn = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(stream));
        } else if (path.endsWith(".bz2")) {
            rtrn = new BZip2CompressorInputStream(stream);
        } else if (path.endsWith(".jar") || path.endsWith(".war") || path.endsWith(".ear")) {
            rtrn = new JarArchiveInputStream(stream);
        }
        return rtrn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getInputSize(String fullPath) {
        File archiveFile;
        String archivePath = fullPath;
        String entryPath = "";
        if (FileUtility.isArchiveEntryPath(fullPath)) {
            archivePath = FileUtility.getArchiveFilePath(fullPath);
            entryPath = FileUtility.getArchiveEntrySubPath(fullPath);
        }
        if (!(archiveFile = new File(archivePath)).exists()) {
            return 0L;
        }
        if (archiveFile.isDirectory()) {
            Path folder = archiveFile.toPath();
            try {
                return Files.walk(folder, new FileVisitOption[0]).filter(p -> p.toFile().isFile()).mapToLong(p -> p.toFile().length()).sum();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileInputStream rtrn = new FileInputStream(archiveFile);
            if (archivePath.endsWith(".tar.gz") || archivePath.endsWith(".tgz")) {
                rtrn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)rtrn));
            } else if (archivePath.endsWith(".gz")) {
                rtrn = new GzipCompressorInputStream((InputStream)rtrn);
            } else if (archivePath.endsWith(".tar")) {
                rtrn = new TarArchiveInputStream((InputStream)rtrn);
            } else if (archivePath.endsWith(".zip")) {
                rtrn = new ZipArchiveInputStream((InputStream)rtrn);
            } else if (archivePath.endsWith(".Z")) {
                rtrn = new ZCompressorInputStream((InputStream)rtrn);
            } else if (archivePath.endsWith(".tar.bz2") || archivePath.endsWith("tbz2")) {
                rtrn = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream((InputStream)rtrn));
            } else if (archivePath.endsWith(".bz2")) {
                rtrn = new BZip2CompressorInputStream((InputStream)rtrn);
            } else {
                if (!archivePath.endsWith(".jar") && !archivePath.endsWith(".ear")) {
                    if (!archivePath.endsWith(".war")) return archiveFile.length();
                }
                rtrn = new JarArchiveInputStream((InputStream)rtrn);
            }
            if (entryPath.isEmpty()) return archiveFile.length();
            if (!(rtrn instanceof ArchiveInputStream)) throw new RuntimeException("Could not find " + entryPath + " in " + archivePath + " because it is not an archive collection");
            ArchiveInputStream ais = (ArchiveInputStream)rtrn;
            ArchiveEntry ae = null;
            FileInputStream entryStream = null;
            while ((ae = ais.getNextEntry()) != null) {
                String aeName = ae.getName();
                if (aeName.startsWith("./")) {
                    aeName = aeName.substring(2);
                } else if (aeName.startsWith("/")) {
                    aeName = aeName.substring(1);
                }
                if (entryPath.startsWith("./")) {
                    entryPath = entryPath.substring(2);
                } else if (entryPath.startsWith("/")) {
                    entryPath = entryPath.substring(1);
                }
                if (!aeName.equals(entryPath)) continue;
                ae.getSize();
                entryStream = rtrn;
                break;
            }
            if (entryStream == null) {
                throw new RuntimeException("Could not find " + entryPath + " in " + archivePath + " on local file system");
            }
            rtrn = entryStream;
            if (rtrn == null) return 0L;
            return ((InputStream)rtrn).available();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static List<String> lines(String fullPath) {
        String content = FileUtility.readFile(fullPath);
        return new ArrayList<String>(Arrays.asList(content.split("\r?\n")));
    }

    public static Stream<String> stream(String path) {
        return new BufferedReader(new InputStreamReader(FileUtility.getInputStream(path))).lines();
    }

    public static String readHead(String fullPath, int lines) {
        StringBuilder sb = new StringBuilder();
        InputStream stream = FileUtility.getInputStream(fullPath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            for (int i = 0; i < lines; ++i) {
                if (i > 0) {
                    sb.append(System.lineSeparator());
                }
                sb.append(reader.readLine());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String readFile(String fullPath) {
        InputStream stream = FileUtility.getInputStream(fullPath);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = stream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(buffer.toByteArray());
    }

    private static InputStream getInputStream(ArchiveInputStream inputStream, String currentPath) throws IOException {
        ArchiveEntry entry;
        String entryPath = currentPath;
        String remainder = "";
        if (currentPath.contains(ARCHIVE_KEY)) {
            entryPath = FileUtility.getArchiveFilePath(currentPath);
            remainder = FileUtility.getArchiveEntrySubPath(currentPath);
        }
        if (entryPath.startsWith("./")) {
            entryPath = entryPath.substring(2);
        }
        if (entryPath.startsWith("/")) {
            entryPath = entryPath.substring(1);
        }
        InputStream rtrn = null;
        while ((entry = inputStream.getNextEntry()) != null) {
            String name = entry.getName();
            if (name.startsWith("./")) {
                name = name.substring(2);
            }
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (!name.equals(entryPath)) continue;
            rtrn = FileUtility.wrapStream((InputStream)inputStream, entryPath);
            if (remainder.isEmpty() || !FileUtility.isArchive(entryPath) || !(rtrn instanceof ArchiveInputStream)) break;
            rtrn = FileUtility.getInputStream((ArchiveInputStream)rtrn, remainder);
            break;
        }
        return rtrn;
    }

    private static File getFileFromArchive(String archivePath, String entryPath) {
        try {
            FileSystem fs = FileSystems.newFileSystem(Paths.get(archivePath, new String[0]), FileUtility.class.getClassLoader());
            Path entry = fs.getPath(entryPath, new String[0]);
            String prefix = entryPath;
            if (prefix.contains("/")) {
                prefix = prefix.substring(prefix.lastIndexOf("/"));
            }
            Path tmp = Files.createTempFile(prefix + "_", ".yaup", new FileAttribute[0]);
            Files.copy(entry, tmp, StandardCopyOption.REPLACE_EXISTING);
            File rtrn = tmp.toFile();
            return rtrn;
        }
        catch (IOException iOException) {
            return new File(archivePath + ARCHIVE_KEY + entryPath);
        }
    }

    public static File getFile(String fullPath, boolean delete) {
        String archivePath = fullPath;
        String entryPath = "";
        File found = new File(fullPath);
        if (!found.exists() && FileUtility.isArchiveEntryPath(fullPath)) {
            archivePath = FileUtility.getArchiveFilePath(fullPath);
            entryPath = FileUtility.getArchiveEntrySubPath(fullPath);
            if (FileUtility.isArchive(archivePath)) {
                found = FileUtility.getFileFromArchive(archivePath, entryPath);
                if (delete) {
                    found.deleteOnExit();
                }
            }
        }
        if (!found.exists() && fullPath.startsWith("http")) {
            File tmp = null;
            try {
                File.createTempFile("yaup-" + fullPath, ".tmp");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (tmp != null) {
                try (ReadableByteChannel readableByteChannel = Channels.newChannel(new URL(fullPath).openStream());
                     FileOutputStream fileOutputStream = new FileOutputStream(tmp.getPath());
                     FileChannel fileChannel = fileOutputStream.getChannel();){
                    if (delete) {
                        tmp.deleteOnExit();
                    }
                    fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                    fileChannel.close();
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (FileUtility.isArchiveEntryPattern(fullPath)) {
                    archivePath = FileUtility.getArchiveFilePath(fullPath);
                    entryPath = FileUtility.getArchiveEntrySubPath(fullPath);
                    found = FileUtility.getFileFromArchive(tmp.getPath(), entryPath);
                    if (delete) {
                        found.deleteOnExit();
                    }
                    if (found.exists()) {
                        // empty if block
                    }
                } else {
                    found = tmp;
                }
            }
        }
        return found;
    }

    public static InputStream getInputStream(String fullPath) {
        InputStream rtrn = null;
        String archivePath = fullPath;
        String entryPath = "";
        if (FileUtility.isArchiveEntryPath(fullPath)) {
            archivePath = FileUtility.getArchiveFilePath(fullPath);
            entryPath = FileUtility.getArchiveEntrySubPath(fullPath);
        }
        try {
            if (!new File(archivePath).exists()) {
                rtrn = null;
                throw new RuntimeException("Cannot find " + archivePath + " on local file system");
            }
            rtrn = new BufferedInputStream(new FileInputStream(archivePath));
            rtrn = FileUtility.wrapStream(rtrn, archivePath);
            if (!entryPath.isEmpty() && rtrn instanceof ArchiveInputStream) {
                rtrn = FileUtility.getInputStream((ArchiveInputStream)rtrn, entryPath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rtrn;
    }

    public static List<String> getArchiveEntries(String archivePath) {
        return FileUtility.getArchiveEntries(archivePath, false);
    }

    public static List<String> getArchiveEntries(String archivePath, boolean deep) {
        LinkedList<String> rtrn = new LinkedList<String>();
        try (InputStream is = FileUtility.getInputStream(archivePath);){
            if (is != null && is instanceof ArchiveInputStream) {
                try {
                    FileUtility.addEntries((ArchiveInputStream)is, "", rtrn, deep);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Collections.unmodifiableList(rtrn);
    }

    private static void addEntries(ArchiveInputStream inputStream, String prefix, List<String> rtrn, boolean recursive) throws IOException {
        if (inputStream != null) {
            ArchiveEntry entry = null;
            while ((entry = inputStream.getNextEntry()) != null) {
                InputStream wrappedStream;
                String name = entry.getName();
                rtrn.add(prefix + name);
                if (!recursive || !FileUtility.isArchive(name) || !((wrappedStream = FileUtility.wrapStream((InputStream)inputStream, name)) instanceof ArchiveInputStream)) continue;
                FileUtility.addEntries((ArchiveInputStream)wrappedStream, prefix + name + ARCHIVE_KEY, rtrn, recursive);
            }
        }
    }

    public static String getArchiveEntrySubPath(String archiveEntryPath) {
        if (archiveEntryPath == null || archiveEntryPath.isEmpty()) {
            return "";
        }
        if (archiveEntryPath.contains(ARCHIVE_KEY)) {
            return archiveEntryPath.substring(archiveEntryPath.indexOf(ARCHIVE_KEY) + ARCHIVE_KEY.length());
        }
        return "";
    }

    public static String getArchiveFilePath(String archiveEntryPath) {
        if (archiveEntryPath == null || archiveEntryPath.isEmpty()) {
            return "";
        }
        if (archiveEntryPath.contains(ARCHIVE_KEY)) {
            return archiveEntryPath.substring(0, archiveEntryPath.indexOf(ARCHIVE_KEY));
        }
        return "";
    }

    public static String getDirectory(String fileName) {
        if (FileUtility.isArchiveEntryPath(fileName)) {
            fileName = fileName.substring(0, fileName.indexOf(ARCHIVE_KEY));
        }
        if (fileName.contains("\\")) {
            fileName = fileName.replaceAll("\\\\", "/");
        }
        if (fileName.endsWith("/")) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("/") + 1);
    }

    public static String getParentDirectory(String fileName) {
        if (fileName == null) {
            return "";
        }
        if (fileName.contains("\\")) {
            fileName = fileName.replaceAll("\\\\", "/");
        }
        if (fileName.endsWith("/")) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        return fileName.substring(0, fileName.lastIndexOf("/") + 1);
    }

    private static final List<String> search(String baseDir, String nameSubstring, boolean recursive, boolean wantFiles, boolean depthFirst, boolean inArchive) {
        ArrayList<String> rtrn = new ArrayList<String>();
        ArrayList<String> toParse = new ArrayList<String>();
        toParse.add(baseDir);
        while (!toParse.isEmpty()) {
            String next = (String)toParse.remove(0);
            File f = new File(next);
            if (f.exists() && f.isDirectory()) {
                File[] subs = f.listFiles();
                if (subs == null) continue;
                for (File sub : subs) {
                    if (recursive && sub.isDirectory()) {
                        if (depthFirst) {
                            toParse.add(0, sub.getAbsolutePath());
                        } else {
                            toParse.add(sub.getAbsolutePath());
                        }
                    }
                    if (sub.isFile() == wantFiles && sub.isDirectory() != wantFiles) {
                        if (nameSubstring != null && !nameSubstring.isEmpty()) {
                            if (sub.getName().contains(nameSubstring)) {
                                rtrn.add(sub.getAbsolutePath());
                            }
                        } else {
                            rtrn.add(sub.getAbsolutePath());
                        }
                    }
                    if (!inArchive || !sub.isFile() || !FileUtility.isArchive(sub)) continue;
                    List<String> entries = FileUtility.getArchiveEntries(sub.getPath());
                    for (String entry : entries) {
                        if (!entry.contains(nameSubstring)) continue;
                        rtrn.add(sub.getPath() + ARCHIVE_KEY + entry);
                    }
                }
                continue;
            }
            if (!f.exists()) continue;
            if (f.isFile() == wantFiles && f.isDirectory() != wantFiles && nameSubstring != null && !nameSubstring.isEmpty() && f.getName().contains(nameSubstring)) {
                rtrn.add(f.getAbsolutePath());
            }
            if (!inArchive || !f.isFile() || !FileUtility.isArchive(f)) continue;
            List<String> entries = FileUtility.getArchiveEntries(f.getPath());
            for (String entry : entries) {
                if (!entry.contains(nameSubstring)) continue;
                rtrn.add(entry);
            }
        }
        return rtrn;
    }

    public static JSONObject readJsonObjectFile(String fileName) {
        JSONObject rtrn = new JSONObject();
        if (Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
            try {
                rtrn = new JSONObject(new String(Files.readAllBytes(Paths.get(fileName, new String[0]))));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rtrn;
    }

    public static JSONArray readJsonArrayFile(String fileName) {
        JSONArray rtrn = new JSONArray();
        if (Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
            try {
                rtrn = new JSONArray(new String(Files.readAllBytes(Paths.get(fileName, new String[0]))));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rtrn;
    }

    public static Object readObjectFile(String fileName) {
        return FileUtility.readObjectFile(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObjectFile(File file) {
        ObjectInputStream ois = null;
        Object rtrn = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(file));
            rtrn = ois.readObject();
            ois.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return rtrn;
    }

    public static int lineCount(String substring, String fileName) {
        int index = 0 - substring.length();
        int count = 0;
        String line = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(substring) <= -1) continue;
                ++count;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return count;
    }

    public static void writeObjectFile(String fileName, Object object) {
        FileUtility.writeObjectFile(new File(fileName), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectFile(File file, Object object) {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(object);
            oos.flush();
            oos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean isArchive(String filePath) {
        return FileUtility.isArchive(new File(filePath));
    }

    public static boolean isArchive(File file) {
        String n = file.getName();
        return file.exists() && (n.endsWith(".zip") || n.endsWith(".tar") || n.endsWith("tar.gz") || n.endsWith(".tgz") || n.endsWith(".Z") || n.endsWith(".jar") || n.endsWith(".ear") || n.endsWith(".war") || n.endsWith(".bzip2"));
    }

    public static boolean isZip(InputStream stream) {
        boolean rtrn = false;
        if (stream.markSupported()) {
            stream.mark(10);
        }
        try {
            for (int i = 0; i < 10; ++i) {
                int n = stream.read();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (stream.markSupported()) {
            try {
                stream.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rtrn;
    }

    static {
        magic_numbers.put(Format.gz, new int[]{31, 139});
        magic_numbers.put(Format.tar, new int[]{117, 115, 116, 97, 114});
        magic_numbers.putAll(Format.zip, Arrays.asList({80, 75, 3, 4}, {80, 75, 5, 6}, {80, 75, 7, 8}));
        magic_numbers.putAll(Format.Z, Arrays.asList({31, 157}, {31, 160}));
        magic_numbers.put(Format.tarZ, new int[]{31, 160});
        magic_numbers.put(Format.bz2, new int[]{66, 90, 104});
        magic_numbers.putAll(Format.rar, Arrays.asList({82, 97, 114, 33, 26, 7, 0}, {82, 97, 114, 33, 26, 7, 1, 0}));
        magic_numbers.put(Format.sevenZ, new int[]{55, 122, 188, 175, 114, 28});
        magic_numbers.put(Format.xz, new int[]{253, 55, 122, 88, 90, 0, 0});
        OPERATION_LENGTH = 2;
        OPERATIONS = Collections.unmodifiableSet(Sets.of(ADD_OPERATION, DELETE_OPERATION, SET_OPERATION));
    }

    public static enum Format {
        bz2,
        gz,
        tar,
        zip,
        Z,
        tarZ,
        rar,
        sevenZ,
        xz;

    }

    private class Child {
        private File file;
        private ArchiveEntry archiveEntry;

        private Child() {
        }
    }
}

