/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.file;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class WrappedInputStream
extends InputStream {
    private final InputStream stream;
    private List<Watcher> watchers;
    private long cumulative;

    public WrappedInputStream(InputStream stream) {
        this.stream = stream;
        this.cumulative = 0L;
        this.watchers = new LinkedList<Watcher>();
    }

    private void notifyAll(long amount) {
        if (!this.watchers.isEmpty()) {
            for (Watcher w : this.watchers) {
                w.advanced(amount);
            }
        }
    }

    public void addWatcher(Watcher w) {
        this.watchers.add(w);
    }

    public long getCumulative() {
        return this.cumulative;
    }

    @Override
    public int read() throws IOException {
        int amnt = this.stream.read();
        this.cumulative += (long)amnt;
        this.notifyAll(amnt);
        return amnt;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int amnt = this.stream.read(b, off, len);
        this.cumulative += (long)amnt;
        this.notifyAll(amnt);
        return amnt;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
        this.cumulative = 0L;
    }

    @Override
    public long skip(long n) throws IOException {
        long amnt = this.stream.skip(n);
        this.cumulative += amnt;
        this.notifyAll(amnt);
        return amnt;
    }

    public static interface Watcher {
        public void advanced(long var1);
    }
}

