/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.file.FileUtility;
import io.hyperfoil.tools.yaup.json.ValueConverter;
import io.hyperfoil.tools.yaup.json.YaupJsonProvider;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.script.Bindings;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Value;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Json {
    static final XLogger logger = XLoggerFactory.getXLogger(MethodHandles.lookup().lookupClass());
    public static JsonAction ADD_ACTION = (target, key, value) -> {
        if (key == null || key.isEmpty()) {
            if (value instanceof Json && !((Json)value).isArray() && !target.isArray()) {
                ((Json)value).forEach((Object k, Object v) -> target.add(k, v, true));
            }
        } else {
            target.add(key, value, true);
        }
    };
    public static JsonAction SET_ACTION = (target, key, value) -> {
        if ((key == null || key.isEmpty()) && value instanceof Json && !((Json)value).isArray() && !target.isArray()) {
            target.merge((Json)value, true);
        }
        target.set(key, value);
    };
    public static JsonAction MERGE_ACTION = (target, key, value) -> {
        if (key == null || key.isEmpty()) {
            if (!target.isArray()) {
                Json jsonValue;
                if (value instanceof Json && !(jsonValue = (Json)value).isArray()) {
                    target.merge(jsonValue, false);
                }
            } else {
                target.add(value);
            }
        } else if (!target.has(key)) {
            target.set(key, value);
        } else if (target.get(key) instanceof Json) {
            Json existing = target.getJson(key);
            if (existing.isArray()) {
                if (value instanceof Json && ((Json)value).isArray()) {
                    ((Json)value).forEach((Object v) -> existing.add(v));
                } else {
                    existing.add(value);
                }
            } else if (value instanceof Json) {
                Json valueJson = (Json)value;
                if (valueJson.isArray()) {
                    valueJson.add(existing);
                    target.set(key, valueJson);
                } else {
                    existing.merge((Json)value, false);
                }
            } else {
                logger.error("MERGE_ACTION unexpected value type for existing json object\nkey\n" + key + "\nvalue\n" + value + "\nexisting\n" + existing);
                existing.add(value);
            }
        } else {
            Json newArray = new Json(true);
            newArray.add(target.get(key));
            newArray.add(value);
            target.set(key, newArray);
        }
    };
    private static Configuration yaup = Configuration.builder().jsonProvider((JsonProvider)new YaupJsonProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS, Option.DEFAULT_PATH_LEAF_TO_NULL}).build();
    private LinkedHashMap<Object, Object> data = new LinkedHashMap();
    private boolean isArray;

    public static MapBuilder map() {
        return new MapBuilder();
    }

    public static ArrayBuilder array() {
        return new ArrayBuilder();
    }

    public static Map<Object, Object> toObjectMap(Json json) {
        LinkedHashMap<Object, Object> rtrn = new LinkedHashMap<Object, Object>();
        json.forEach((Object k, Object v) -> {
            if (v instanceof Json) {
                rtrn.put(k, Json.toObject((Json)v));
            } else {
                rtrn.put(k, v);
            }
        });
        return rtrn;
    }

    private static Object toObject(Json json) {
        if (json.isArray()) {
            LinkedList rtrn = new LinkedList();
            json.forEach((Object entry) -> {
                if (entry instanceof Json) {
                    ((LinkedList)rtrn).add(Json.toObject((Json)entry));
                } else {
                    ((LinkedList)rtrn).add(entry);
                }
            });
            return rtrn;
        }
        return Json.toObjectMap(json);
    }

    public static JSONArray toJSONArray(Json json) {
        JSONArray rtrn = new JSONArray();
        if (json.isArray()) {
            for (int i = 0; i < json.size(); ++i) {
                Object toAdd = json.get(i);
                if (toAdd instanceof Json) {
                    Json entryJson = (Json)toAdd;
                    toAdd = entryJson.isArray() ? Json.toJSONArray(entryJson) : Json.toJSONObject(entryJson);
                }
                rtrn.put(toAdd);
            }
        }
        return rtrn;
    }

    public static JSONObject toJSONObject(Json json) {
        JSONObject rtrn = new JSONObject();
        if (!json.isArray) {
            LinkedList<Json> jsonList = new LinkedList<Json>();
            jsonList.add(json);
            LinkedList<JSONObject> objects = new LinkedList<JSONObject>();
            objects.add(rtrn);
            while (!jsonList.isEmpty()) {
                Json currentJson = (Json)jsonList.poll();
                Object currentObject = objects.poll();
                if (currentJson.isArray()) {
                    JSONArray objectArray = (JSONArray)currentObject;
                    currentJson.forEach((Object entry) -> {
                        if (entry instanceof Json) {
                            Json entryJson = (Json)entry;
                            if (entryJson.isArray()) {
                                JSONArray newJsonArray = new JSONArray();
                                jsonList.add(entryJson);
                                objects.add((JSONObject)newJsonArray);
                                objectArray.put((Object)newJsonArray);
                            } else {
                                JSONObject newJsonObject = new JSONObject();
                                jsonList.add(entryJson);
                                objects.add(newJsonObject);
                                objectArray.put((Object)newJsonObject);
                            }
                        } else {
                            objectArray.put(entry);
                        }
                    });
                    continue;
                }
                JSONObject objectJson = (JSONObject)currentObject;
                currentJson.forEach((Object key, Object value) -> {
                    if (value instanceof Json) {
                        Json valueJson = (Json)value;
                        if (valueJson.isArray()) {
                            JSONArray newJsonArray = new JSONArray();
                            jsonList.add(valueJson);
                            objects.add((JSONObject)newJsonArray);
                            objectJson.put(key.toString(), (Object)newJsonArray);
                        } else {
                            JSONObject newJsonObject = new JSONObject();
                            jsonList.add(valueJson);
                            objects.add(newJsonObject);
                            objectJson.put(key.toString(), (Object)newJsonObject);
                        }
                    } else {
                        objectJson.put(key.toString(), value);
                    }
                });
            }
        }
        return rtrn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void chainAct(Json target, String prefix, Object value, JsonAction action) {
        List<String> chain = Json.toChain(prefix);
        String key = chain.remove(chain.size() - 1).replaceAll("\\\\\\.", ".");
        for (String id : chain) {
            Object found;
            if ((id = id.replaceAll("\\\\\\.", ".")).isEmpty()) continue;
            if (!target.has(id)) {
                Json json = target;
                synchronized (json) {
                    if (!target.has(id)) {
                        target.set(id, new Json());
                    }
                }
            }
            if (!((found = target.get(id)) instanceof Json)) {
                Json json = target;
                synchronized (json) {
                    if (!(found instanceof Json)) {
                        Object existing = found;
                        target.set(id, new Json());
                        target.getJson(id).add(existing);
                    }
                }
            }
            target = target.getJson(id);
        }
        action.accept(target, key, value);
    }

    public static void chainAdd(Json target, String prefix, Object value) {
        Json.chainAct(target, prefix, value, ADD_ACTION);
    }

    public static void chainMerge(Json target, String prefix, Object value) {
        Json.chainAct(target, prefix, value, MERGE_ACTION);
    }

    public static void chainSet(Json target, String prefix, Object value) {
        Json.chainAct(target, prefix, value, SET_ACTION);
    }

    public static Json fromYamlFile(String path) {
        try {
            String content = Files.lines(Paths.get(path, new String[0])).collect(Collectors.joining("\n"));
            return Json.fromYaml(content);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Json();
        }
    }

    public static Json fromYaml(String yamlContent) {
        Json rtrn = new Json();
        Yaml yaml = new Yaml();
        List<Object> loaded = StreamSupport.stream(yaml.loadAll(yamlContent).spliterator(), false).collect(Collectors.toList());
        if (loaded.size() == 1) {
            if (loaded.get(0) instanceof Map) {
                rtrn = Json.fromMap((Map)loaded.get(0));
            } else if (loaded.get(0) instanceof Collection) {
                rtrn = Json.fromCollection((Collection)loaded.get(0));
            }
        } else {
            Json ref = rtrn;
            loaded.forEach((? super T entry) -> {
                if (entry instanceof Map) {
                    ref.add(Json.fromMap((Map)entry));
                } else if (entry instanceof Collection) {
                    ref.add(Json.fromCollection((Collection)entry));
                }
            });
        }
        return rtrn;
    }

    public static Json fromMap(Map map) {
        Json rtrn = new Json(false);
        if (map == null) {
            return rtrn;
        }
        map.forEach((? super K key, ? super V value) -> {
            if (value == null) {
                rtrn.set(key, value);
            } else if (value instanceof Map) {
                rtrn.set(key, Json.fromMap((Map)value));
            } else if (value instanceof Collection) {
                rtrn.set(key, Json.fromCollection((Collection)value));
            } else {
                rtrn.set(key, value);
            }
        });
        return rtrn;
    }

    public static String prettyPrintWithJackson(JsonNode node, int indent) {
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        DefaultIndenter indenter = new DefaultIndenter(String.format("%" + indent + "s", ""), DefaultIndenter.SYS_LF);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        try {
            String json = mapper.writer((PrettyPrinter)printer).writeValueAsString((Object)node);
            return json;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Json fromCollection(Collection collection) {
        Json rtrn = new Json(true);
        collection.forEach((? super T value) -> {
            if (value instanceof Map) {
                rtrn.add(Json.fromMap((Map)value));
            } else if (value instanceof Collection) {
                rtrn.add(Json.fromCollection((Collection)value));
            } else {
                rtrn.add(value);
            }
        });
        return rtrn;
    }

    public static Json fromJacksonString(String content) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(content);
            return Json.fromJsonNode(node);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return new Json(false);
        }
    }

    public static Json fromJacksonFile(String path) {
        block8: {
            Json json;
            ObjectMapper mapper = new ObjectMapper();
            FileReader reader = new FileReader(path);
            try {
                JsonNode node = mapper.readTree((Reader)reader);
                json = Json.fromJsonNode(node);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    break block8;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return json;
        }
        return new Json(false);
    }

    private static Object convertJsonNode(JsonNode node) {
        if (node.isObject() || node.isArray()) {
            return Json.fromJsonNode(node);
        }
        if (node.isDouble() || node.isFloat()) {
            return node.doubleValue();
        }
        if (node.isLong() || node.isInt()) {
            return node.longValue();
        }
        if (node.isNull()) {
            return "";
        }
        return node.textValue();
    }

    public static JsonNode toJsonNode(Json json) {
        ArrayNode rtrn;
        JsonNodeFactory factory = JsonNodeFactory.instance;
        if (json.isArray()) {
            ArrayNode arrayNode;
            rtrn = arrayNode = new ArrayNode(factory);
            json.forEach((Object value) -> {
                if (value instanceof Json) {
                    value = Json.toJsonNode((Json)value);
                    arrayNode.add((JsonNode)value);
                } else {
                    ObjectMapper mapper = new ObjectMapper();
                    arrayNode.add((JsonNode)mapper.convertValue(value, JsonNode.class));
                }
            });
        } else {
            ObjectNode objectNode = new ObjectNode(factory);
            rtrn = objectNode;
            json.forEach((Object key, Object value) -> {
                if (value instanceof Json) {
                    objectNode.set(key.toString(), Json.toJsonNode((Json)value));
                } else {
                    ObjectMapper mapper = new ObjectMapper();
                    objectNode.set(key.toString(), (JsonNode)mapper.convertValue(value, JsonNode.class));
                }
            });
        }
        return rtrn;
    }

    public static Json fromJsonNode(JsonNode node) {
        Json rtrn = new Json();
        if (node.isArray()) {
            node.fields().forEachRemaining(entry -> {
                JsonNode value = (JsonNode)entry.getValue();
                rtrn.add(Json.convertJsonNode(value));
            });
        } else if (node.isObject()) {
            node.fields().forEachRemaining(entry -> {
                JsonNode value = (JsonNode)entry.getValue();
                rtrn.set(entry.getKey(), Json.convertJsonNode(value));
            });
        }
        return rtrn;
    }

    public static Json fromFile(String path) {
        String content = FileUtility.readFile(path);
        return Json.fromString(content);
    }

    public static Json fromThrowable(Throwable e) {
        Json rtrn = new Json();
        Json.fromThrowable(e, rtrn);
        return rtrn;
    }

    public static void fromThrowable(Throwable e, Json target) {
        if (e != null) {
            target.set("class", e.getClass().toString());
            if (e.getMessage() != null) {
                target.set("message", e.getMessage());
            }
            if (e.getStackTrace() != null) {
                target.set("stack", new Json());
                Arrays.asList(e.getStackTrace()).forEach((? super T ste) -> {
                    Json frame = new Json();
                    frame.set("class", ste.getClassName());
                    frame.set("method", ste.getMethodName());
                    frame.set("line", ste.getLineNumber());
                    frame.set("file", ste.getFileName());
                    target.getJson("stack").add(frame);
                });
            }
            if (e.getCause() != null) {
                Json causedBy = new Json();
                target.set("causedBy", causedBy);
                Json.fromThrowable(e.getCause(), causedBy);
            }
        }
    }

    public static Json fromGraalvm(Value value) {
        return ValueConverter.convertMapping(value);
    }

    public static Json fromString(String json) {
        return Json.fromString(json, null);
    }

    public static Json fromString(String json, Json defaultValue) {
        return Json.fromString(json, defaultValue, false);
    }

    public static Json fromString(String json, Json defaultValue, boolean debug) {
        Json rtrn;
        block7: {
            rtrn = defaultValue;
            if (json == null) {
                return rtrn;
            }
            json = json.trim();
            try {
                if (json.startsWith("[")) {
                    JSONArray jsonArray = new JSONArray(json);
                    rtrn = Json.fromJSONArray(jsonArray);
                } else if (json.startsWith("{")) {
                    JSONObject jsonObject = new JSONObject(json);
                    rtrn = Json.fromJSONObject(jsonObject);
                } else {
                    rtrn = defaultValue;
                }
            }
            catch (JSONException e) {
                if (!debug) break block7;
                e.printStackTrace();
            }
        }
        return rtrn;
    }

    public static Optional<Json> optional(String json) {
        if (Json.isJsonLike(json)) {
            try {
                Json created = Json.fromString(json);
                return Optional.ofNullable(created);
            }
            catch (RuntimeException e) {
                return Optional.ofNullable(null);
            }
        }
        return Optional.ofNullable(null);
    }

    public static boolean isJsonLike(String input) {
        if (input == null || input.trim().isEmpty()) {
            return false;
        }
        char firstChar = input.trim().charAt(0);
        char lastChar = input.trim().charAt(input.trim().length() - 1);
        switch (firstChar) {
            case '{': {
                return lastChar == '}';
            }
            case '[': {
                return lastChar == ']';
            }
        }
        return false;
    }

    public static Json fromJSONArray(JSONArray json) {
        Json rtrn = new Json(true);
        for (int i = 0; i < json.length(); ++i) {
            Object obj = json.get(i);
            if (obj instanceof JSONArray) {
                rtrn.add(Json.fromJSONArray((JSONArray)obj));
                continue;
            }
            if (obj instanceof JSONObject) {
                rtrn.add(Json.fromJSONObject((JSONObject)obj));
                continue;
            }
            rtrn.add(obj);
        }
        return rtrn;
    }

    public static Json fromJSONObject(JSONObject json) {
        Json rtrn = new Json(false);
        LinkedList<Json> jsonList = new LinkedList<Json>();
        jsonList.add(rtrn);
        LinkedList<Object> objects = new LinkedList<Object>();
        objects.add(json);
        while (!jsonList.isEmpty()) {
            Json currentJson = (Json)jsonList.poll();
            Object currentObject = objects.poll();
            if (currentObject instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)currentObject;
                jsonObject.keySet().forEach((? super T key) -> {
                    Object keyValue = jsonObject.get(key);
                    if (keyValue instanceof JSONObject || keyValue instanceof JSONArray) {
                        Json newJson = new Json(keyValue instanceof JSONArray);
                        currentJson.add(key, newJson);
                        jsonList.add(newJson);
                        objects.add(keyValue);
                    } else if (keyValue == JSONObject.NULL) {
                        currentJson.add(key, null);
                    } else {
                        currentJson.add(key, keyValue);
                    }
                });
                continue;
            }
            if (!(currentObject instanceof JSONArray)) continue;
            JSONArray jsonArray = (JSONArray)currentObject;
            for (int i = 0; i < jsonArray.length(); ++i) {
                Object arrayEntry = jsonArray.get(i);
                if (arrayEntry instanceof JSONObject || arrayEntry instanceof JSONArray) {
                    Json newJson = new Json(arrayEntry instanceof JSONArray);
                    currentJson.add(newJson);
                    jsonList.add(newJson);
                    objects.add(arrayEntry);
                    continue;
                }
                currentJson.add(arrayEntry);
            }
        }
        return rtrn;
    }

    public static Json fromBindings(Bindings bindings) {
        Json rtrn = new Json();
        LinkedList<Json> targets = new LinkedList<Json>();
        LinkedList<Bindings> todo = new LinkedList<Bindings>();
        todo.add(bindings);
        targets.add(rtrn);
        while (!todo.isEmpty()) {
            Json js = (Json)targets.remove();
            Bindings bs = (Bindings)todo.remove();
            boolean isArray = bs.keySet().stream().allMatch(s -> s.matches("\\d+"));
            for (String key : bs.keySet()) {
                Object value = bs.get(key);
                if (value instanceof Bindings) {
                    Json newTarget = new Json();
                    js.set(isArray ? Integer.valueOf(Integer.parseInt(key)) : key, newTarget);
                    targets.add(newTarget);
                    todo.add((Bindings)value);
                    continue;
                }
                js.set(isArray ? Integer.valueOf(Integer.parseInt(key)) : key, value);
            }
        }
        return rtrn;
    }

    public static Json fromJbossCli(String output) {
        boolean wrap = false;
        StringBuilder sb = new StringBuilder();
        Matcher address = Pattern.compile("(?<spacing>\\s*)\\(\"(?<key>[^\"]+)\"\\s+=>\\s+\"(?<value>[^\"]+)\"\\)(?<suffix>[,]?)").matcher("");
        Matcher L = Pattern.compile("(?<spacing>\\s*)\"(?<key>[^\"]+)\"\\s+=>\\s+(?<value>\\d+)L(?<suffix>[,]?)").matcher("");
        String previousLine = "";
        for (String line : output.split("\r?\n")) {
            if (address.reset(line).matches()) {
                sb.append(address.group("spacing"));
                sb.append("{\"key\":\"");
                sb.append(address.group("key"));
                sb.append("\",\"value\":\"");
                sb.append(address.group("value"));
                sb.append("\"}");
                sb.append(address.group("suffix"));
            } else if (L.reset(line).matches()) {
                sb.append(L.group("spacing"));
                sb.append("\"");
                sb.append(L.group("key"));
                sb.append("\":");
                sb.append(L.group("value"));
                sb.append(L.group("suffix"));
            } else {
                if (line.startsWith("{") && previousLine.endsWith("}")) {
                    sb.append(",");
                    wrap = true;
                }
                sb.append(line.replaceAll("=> ", ":"));
            }
            sb.append(System.lineSeparator());
            previousLine = line;
        }
        String toParse = (wrap ? "[" : "") + sb.toString() + (wrap ? "]" : "");
        return Json.fromString(toParse);
    }

    public static Json fromJs(String ... js) {
        return Json.fromJs(Arrays.asList(js).stream().collect(Collectors.joining("\n")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Json fromJs(String js) {
        Json rtrn = new Json();
        try (Engine engine = Engine.newBuilder().option("engine.WarnInterpreterOnly", "false").build();
             Context context = Context.newBuilder((String[])new String[]{"js"}).engine(engine).allowAllAccess(true).allowHostAccess(true).build();){
            context.enter();
            try {
                Value obj = context.eval("js", (CharSequence)("const walker = (parent,key,value)=>{\nif( value === undefined){ parent[key]=null }\nelse if (value === null){ parent[key]=null }\nelse if( Array.isArray(value) ){ value.forEach((entry,index)=>walker(value,index,entry)) }\nelse if (typeof value === 'function'){ parent[key]=value.toString() }\nelse if (value instanceof Date){ parent[key]=value.toISOString() }\nelse if (typeof value === 'object'){ Object.keys(value).forEach(k=>walker(value,k,value[k])) }\nelse{ }\n};\nconst walk = (obj)=>{\n  if( Array.isArray(obj) ){ obj.forEach((entry,index)=>walker(obj,index,entry)) }\n  else{ Object.keys(obj).forEach(k=>{ walker(obj,k,obj[k]); return obj; }) }\n  return obj;\n};\nwalk( (()=>(" + js + "))() )"));
                Object converted = ValueConverter.convert(obj);
                if (converted instanceof Json) {
                    rtrn = (Json)converted;
                }
            }
            finally {
                context.leave();
            }
        }
        catch (IllegalArgumentException e) {
            rtrn = null;
        }
        return rtrn;
    }

    public static Json loadTypeStructure(Json typeStructure) {
        Json rtrn = typeStructure.isArray() ? new HashArray() : new HashJson();
        typeStructure.forEach((Object key, Object value) -> {
            if (value instanceof Json) {
                Json valueAsTypeStructure = Json.loadTypeStructure((Json)value);
                rtrn.add(key, valueAsTypeStructure);
            } else {
                rtrn.add(key, value);
            }
        });
        return rtrn;
    }

    public static Json typeStructure(Json target) {
        Json rtrn = target.isArray() ? new HashArray() : new HashJson();
        target.forEach((Object key, Object value) -> {
            if (value == null) {
                if (rtrn.has(key)) {
                    rtrn.add(key, "null");
                } else {
                    rtrn.set(key, "null");
                }
            } else if (value instanceof Json) {
                Json valueStructure = Json.typeStructure((Json)value);
                rtrn.add(key, valueStructure);
            } else if (value instanceof Number) {
                if (value instanceof Long || value instanceof Integer) {
                    if (!rtrn.has(key) || !"number".equals(rtrn.get(key))) {
                        rtrn.add(key, "integer");
                    }
                } else if (rtrn.has(key) && "integer".equals(rtrn.get(key))) {
                    rtrn.set(key, "number");
                } else {
                    rtrn.add(key, "number");
                }
            } else {
                rtrn.add(key, value.getClass().getSimpleName().toLowerCase());
            }
        });
        return rtrn;
    }

    private static void mergeStructure(Json to, Json from) {
        if (to.isArray()) {
            if (from.isArray()) {
                from.values().forEach(to::add);
            } else {
                to.add(from);
            }
        } else {
            if (from.isArray()) {
                return;
            }
            from.forEach((Object key, Object value) -> {
                if (!to.has(key)) {
                    to.set(key, value);
                    return;
                }
                Object toValue = to.get(key);
                if (!(toValue instanceof Json)) {
                    to.add(key, value);
                    return;
                }
                Json toValueJson = (Json)toValue;
                if (toValueJson.isArray()) {
                    if (value instanceof Json) {
                        Json jsonValue = (Json)value;
                        if (jsonValue.isArray()) {
                            jsonValue.forEach(toValueJson::add);
                        } else {
                            toValueJson.add(value);
                        }
                    } else {
                        toValueJson.add(value);
                    }
                } else if (value instanceof Json) {
                    Json fromValueJson = (Json)value;
                    if (fromValueJson.isArray()) {
                        logger.error("mergeStructure: what to do?\n  to[" + key + "] = " + toValueJson + "\n  from[" + key + "]=" + value);
                    } else {
                        Json.mergeStructure(toValueJson, fromValueJson);
                    }
                }
            });
        }
    }

    private static void keyId(Json target, StringBuilder sb) {
        sb.append("[ ");
        target.keys().stream().sorted().forEach((? super T key) -> {
            Object value = target.get(key);
            sb.append(key);
            sb.append(" ");
            if (value instanceof Json) {
                Json.keyId((Json)value, sb);
            }
        });
        sb.append("]");
    }

    public static boolean isJsonSearchPath(String path) {
        return path.contains("[?(") || path.contains("..") && !path.contains("...");
    }

    public static String getPreSearchPath(String path) {
        if (path.startsWith("$.")) {
            path = path.substring("$.".length());
        }
        if (path.startsWith("$")) {
            path = path.substring("$".length());
        }
        while (Json.isJsonSearchPath(path)) {
            if (path.contains("[?(")) {
                path = path.substring(0, path.indexOf("[?("));
            }
            if (!path.contains("..")) continue;
            path = path.substring(0, path.indexOf(".."));
        }
        return path;
    }

    public static Object find(Json input, String jsonPath) {
        return Json.find(input, jsonPath, null);
    }

    public static Object find(Json input, String jsonPath, Object defaultValue) {
        DocumentContext ctx = JsonPath.parse((Object)input, (Configuration)yaup);
        Object results = null;
        try {
            JsonPath path = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
            results = ctx.read(path);
            if ((jsonPath.contains("..") || jsonPath.contains("?(")) && results != null && results instanceof Json) {
                Json resultJson = (Json)results;
                if (resultJson.isArray() && resultJson.size() == 1) {
                    results = resultJson.get(0);
                } else if (resultJson.size() == 0) {
                    results = null;
                }
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        return results == null ? defaultValue : results;
    }

    public static List<String> dotChain(String path) {
        return new ArrayList<String>(Arrays.asList(path.split("\\.(?<!\\\\\\.)")).stream().map(s -> s.replaceAll("\\\\\\.", ".")).collect(Collectors.toList()));
    }

    public static List<String> toChain(String keys) {
        if (keys == null || keys.trim().isEmpty()) {
            return new ArrayList<String>();
        }
        if (!keys.contains(".") && !keys.contains("[")) {
            ArrayList<String> rtrn = new ArrayList<String>();
            rtrn.add(keys);
            return rtrn;
        }
        int flushed = 0;
        char quote = 'X';
        boolean inQuote = false;
        boolean inBracket = false;
        ArrayList<String> rtrn = new ArrayList<String>();
        block6: for (int i = 0; i < keys.length(); ++i) {
            char c = keys.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (inQuote) {
                        if (quote != c || i != 0 && keys.charAt(i - 1) == '\\') continue block6;
                        inQuote = false;
                        continue block6;
                    }
                    quote = c;
                    inQuote = true;
                    continue block6;
                }
                case '[': {
                    if (inQuote) continue block6;
                    if (flushed < i) {
                        rtrn.add(StringUtil.removeQuotes(keys.substring(flushed, i)));
                        flushed = i + 1;
                    }
                    inBracket = true;
                    continue block6;
                }
                case ']': {
                    if (inQuote || !inBracket) continue block6;
                    inBracket = false;
                    if (flushed >= i) continue block6;
                    rtrn.add(StringUtil.removeQuotes(keys.substring(flushed, i)));
                    flushed = i + 1;
                    continue block6;
                }
                case '.': {
                    if (inQuote || inBracket || i != 0 && keys.charAt(i - 1) == '\\') continue block6;
                    if (flushed < i) {
                        rtrn.add(StringUtil.removeQuotes(keys.substring(flushed, i)));
                        flushed = i + 1;
                        continue block6;
                    }
                    if (i <= 0 || keys.charAt(i - 1) != ']') continue block6;
                    flushed = i + 1;
                }
            }
        }
        if (flushed < keys.length()) {
            rtrn.add(StringUtil.removeQuotes(keys.substring(flushed, keys.length())));
        }
        return rtrn;
    }

    public Json() {
        this(true);
    }

    public Json(boolean isArray) {
        this.isArray = isArray;
    }

    public String toString(int indent) {
        if (this.isArray) {
            return Json.toJSONArray(this).toString(indent);
        }
        return Json.toJSONObject(this).toString(indent);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Json) {
            Set<Object> otherKeySet;
            Json other = (Json)obj;
            Set<Object> thisKeySet = this.keySet();
            if (thisKeySet.containsAll(otherKeySet = other.keySet()) && otherKeySet.containsAll(thisKeySet)) {
                for (Object key : thisKeySet) {
                    if (this.get(key).equals(other.get(key))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void merge(Json toMerge) {
        this.merge(toMerge, false);
    }

    public void merge(Json toMerge, boolean override) {
        if (toMerge == null) {
            return;
        }
        toMerge.forEach((Object key, Object value) -> {
            if (override || !this.has(key)) {
                this.set(key, value);
            } else if (this.has(key)) {
                if (this.get(key) instanceof Json) {
                    Json keyJson = this.getJson(key);
                    if (keyJson.isArray()) {
                        if (value instanceof Json && ((Json)value).isArray()) {
                            ((Json)value).forEach((Object v) -> keyJson.add(v));
                        } else {
                            keyJson.add(value);
                        }
                    } else if (value instanceof Json && !((Json)value).isArray()) {
                        keyJson.merge((Json)value, override);
                    } else {
                        keyJson.add(value);
                    }
                }
                if (this.get(key) instanceof Json && value instanceof Json) {
                    ((Json)this.get(key)).merge((Json)value, override);
                }
            }
        });
    }

    public Json clone() {
        Json rtrn = new Json(this.isArray);
        for (Object key : this.data.keySet()) {
            Object value = this.data.get(key);
            if (value instanceof Json) {
                rtrn.set(key, ((Json)value).clone());
                continue;
            }
            rtrn.set(key, value);
        }
        return rtrn;
    }

    public String toString() {
        StringBuilder rtrn = new StringBuilder();
        if (this.isArray) {
            rtrn.append("[");
            for (int i = 0; i < this.data.size(); ++i) {
                Object value = this.data.get(i);
                if (i > 0) {
                    rtrn.append(",");
                }
                if (value instanceof String) {
                    rtrn.append(this.escape(value));
                    continue;
                }
                rtrn.append(this.escape(value));
            }
            rtrn.append("]");
        } else {
            rtrn.append("{");
            boolean first = true;
            for (Object key : this.data.keySet()) {
                Object value = this.data.get(key);
                if (!first) {
                    rtrn.append(",");
                }
                first = false;
                rtrn.append(this.escape(key, true));
                rtrn.append(":");
                if (value instanceof String) {
                    rtrn.append(this.escape(value));
                    continue;
                }
                rtrn.append(this.escape(value));
            }
            rtrn.append("}");
        }
        return rtrn.toString();
    }

    private String escape(Object o) {
        return this.escape(o, false);
    }

    private String escape(Object o, boolean force) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Json) {
            return ((Json)o).toString();
        }
        if (o instanceof String || force) {
            return JSONObject.quote((String)o.toString());
        }
        return o.toString();
    }

    public void clear() {
        this.data.clear();
    }

    public void remove(Object key) {
        key = this.box(key);
        if (this.isArray() && (key instanceof Integer || key instanceof Long)) {
            int index = ((Number)key).intValue();
            int size = this.size();
            for (int i = index; i < size - 1; ++i) {
                this.set(i, this.get(i + 1));
            }
            this.data.remove(size - 1);
        } else {
            this.data.remove(key);
        }
    }

    public void set(Object key, Object value) {
        if ((key = this.box(key)) instanceof Integer || key instanceof Long) {
            key = ((Number)key).intValue();
        } else {
            this.isArray = false;
        }
        this.checkKeyType(key);
        this.data.put(key, value);
    }

    private void checkKeyType(Object key) {
        if (!(key instanceof Integer) && !(key instanceof Long)) {
            this.isArray = false;
        } else if (Integer.parseInt(key.toString()) > this.size()) {
            this.isArray = false;
        } else if (this.isEmpty()) {
            this.isArray = true;
        }
    }

    public int size() {
        return this.data.size();
    }

    public boolean has(Object key) {
        key = this.box(key);
        return this.data.containsKey(key);
    }

    public Json chain(String ... keys) {
        return this.chain(Arrays.asList(keys));
    }

    public Json chain(List<String> keys) {
        Json rtrn = this;
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            if (key.isEmpty()) continue;
            if (!rtrn.has(key)) {
                rtrn.set(key, new Json());
            }
            if (!(rtrn.get(key) instanceof Json)) {
                Object existing = rtrn.get(key);
                rtrn.set(key, new Json());
                rtrn.getJson(key).add(existing);
            }
            rtrn = rtrn.getJson(key);
        }
        return rtrn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object value) {
        LinkedHashMap<Object, Object> linkedHashMap = this.data;
        synchronized (linkedHashMap) {
            this.add(this.data.size(), value, false);
        }
    }

    public void add(Object key, Object value) {
        this.add(key, value, false);
    }

    public void add(Object key, Object value, boolean forceArray) {
        key = this.box(key);
        if (value instanceof Integer) {
            value = new Long(((Integer)value).longValue());
        }
        this.checkKeyType(key);
        if (this.has(key)) {
            Object existing = this.get(key);
            if (existing instanceof Json && ((Json)existing).isArray()) {
                Json existingJson = (Json)existing;
                existingJson.add(value);
            } else {
                Json newArray = new Json();
                newArray.add(existing);
                newArray.add(value);
                this.data.put(key, newArray);
            }
        } else if (forceArray) {
            Json arry = new Json();
            arry.add(value);
            this.data.put(key, arry);
        } else {
            this.data.put(key, value);
        }
    }

    public boolean isEmpty() {
        return this.data.size() == 0;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public Object get(Object key) {
        return this.data.get(this.box(key));
    }

    private Object box(Object key) {
        if (key instanceof Integer || key instanceof Long) {
            return ((Number)key).intValue();
        }
        if (key.toString().matches("\\d+")) {
            return Integer.parseInt(key.toString());
        }
        return key;
    }

    public boolean getBoolean(Object key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(Object key, boolean defaultValue) {
        return this.has(key = this.box(key)) ? (this.data.get(key) instanceof Boolean ? (Boolean)this.data.get(key) : Boolean.parseBoolean(this.data.get(key).toString())) : defaultValue;
    }

    public Optional<Boolean> optBoolean(Object key) {
        return Optional.ofNullable(this.getBoolean(key));
    }

    public String getString(Object key) {
        return this.getString(key, null);
    }

    public String getString(Object key, String defaultValue) {
        if (this.has(key = this.box(key))) {
            Object value = this.data.get(key);
            return value == null ? null : value.toString();
        }
        return defaultValue;
    }

    public Optional<String> optString(Object key) {
        return Optional.ofNullable(this.getString(key));
    }

    public Json getJson(Object key) {
        return this.getJson(key, null);
    }

    public Json getJson(Object key, Json defaultValue) {
        return this.has(key = this.box(key)) && this.data.get(key) instanceof Json ? (Json)this.data.get(key) : defaultValue;
    }

    public Optional<Json> optJson(Object key) {
        return Optional.ofNullable(this.getJson(key));
    }

    public long getLong(Object key) {
        return this.getLong(key, 0L);
    }

    public long getLong(Object key, long defaultValue) {
        return this.has(key) && this.data.get(key) instanceof Number ? ((Number)this.data.get(key)).longValue() : defaultValue;
    }

    public Optional<Long> optLong(Object key) {
        return Optional.ofNullable(this.has(key) && this.get(key) instanceof Long ? Long.valueOf(this.getLong(key)) : null);
    }

    public double getDouble(Object key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(Object key, double defaultValue) {
        if (this.has(key)) {
            Object value = this.get(key);
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Long) {
                return 1.0 * (double)((Long)value).longValue();
            }
            if (value instanceof String && ((String)value).matches("-?\\d+\\.?\\d*")) {
                return Double.parseDouble((String)value);
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public Optional<Double> optDouble(Object key) {
        return Optional.ofNullable(this.has(key) && this.get(key) instanceof Double ? Double.valueOf(this.getDouble(key)) : null);
    }

    public Set<Object> keySet() {
        return this.data.keySet();
    }

    public Stream<Map.Entry<Object, Object>> stream() {
        return this.data.entrySet().stream();
    }

    public void forEach(Consumer<Object> consumer) {
        this.data.values().forEach(consumer);
    }

    public void forEach(BiConsumer<Object, Object> consumer) {
        this.data.entrySet().forEach((? super T entry) -> consumer.accept(entry.getKey(), entry.getValue()));
    }

    public Collection<Object> values() {
        return this.data.values();
    }

    public Set<Object> keys() {
        return this.data.keySet();
    }

    public static class MapBuilder {
        private final Json json = new Json();

        public MapBuilder set(String key, Object value) {
            this.json.set(key, value);
            return this;
        }

        public MapBuilder add(String key, Object value) {
            this.json.add(key, value);
            return this;
        }

        public Json build() {
            return this.json;
        }
    }

    public static class ArrayBuilder {
        private final Json json = new Json();

        public ArrayBuilder add(Object obj) {
            this.json.add(obj);
            return this;
        }

        public Json build() {
            return this.json;
        }
    }

    public static interface JsonAction {
        public void accept(Json var1, String var2, Object var3);
    }

    public static class HashArray
    extends Json {
        HashMap<String, Json> seen = new HashMap();

        @Override
        public void add(Object object) {
            Json jsonObject;
            if (object == null) {
                return;
            }
            String key = object.toString();
            if (object instanceof Json && !(jsonObject = (Json)object).isArray()) {
                StringBuilder sb = new StringBuilder();
                Json.keyId(jsonObject, sb);
                key = sb.toString();
            }
            if (!this.seen.containsKey(key)) {
                this.seen.put(key, object instanceof Json ? (Json)object : null);
                super.add(object);
            } else if (object instanceof Json && this.seen.get(key) != null) {
                Json.mergeStructure(this.seen.get(key), (Json)object);
            }
        }

        @Override
        public void set(Object key, Object value) {
        }

        @Override
        public void add(Object key, Object value) {
            this.add(value);
        }
    }

    public static class HashJson
    extends Json {
        public HashJson() {
            super(false);
        }

        @Override
        public void add(Object key, Object value) {
            if (value == null) {
                return;
            }
            if (this.has(key)) {
                if (!(this.get(key).equals(value) || "integer".equals(value) && "number".equals(this.get(key)))) {
                    if ("number".equals(value) && "integer".equals(this.get(key))) {
                        super.set(key, value);
                    } else if (!(this.get(key) instanceof HashArray)) {
                        HashArray newEntry = new HashArray();
                        newEntry.add(this.get(key));
                        newEntry.add(value);
                        super.set(key, newEntry);
                    } else if (this.get(key) instanceof Json) {
                        // empty if block
                    }
                }
            } else {
                super.add(key, value);
            }
        }

        @Override
        public void add(Object value) {
        }
    }
}

