/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.json;

import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.json.Json;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class JsonComparison {
    static final XLogger logger = XLoggerFactory.getXLogger(MethodHandles.lookup().lookupClass());
    private boolean ordered = true;
    private LinkedHashMap<String, Json> rootJson = new LinkedHashMap();
    private LinkedHashMap<String, Integer> criteria = new LinkedHashMap();

    public void addCriteria(String path, int editDistance) {
        this.criteria.put(path, editDistance);
    }

    public int jsonCount() {
        return this.rootJson.size();
    }

    public Set<String> jsonNames() {
        return this.rootJson.keySet();
    }

    public void load(String name, Json json) {
        this.rootJson.put(name, json);
    }

    public int criteriaCount() {
        return this.criteria.size();
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    private void diff(String path, List<Entry> diffs, Map<String, Json> jsons) {
        if (this.isEmtpy(jsons)) {
            return;
        }
        if (this.hasNull(jsons)) {
            logger.error("THIS SHOULD BE CAUGHT BEFORE THIS POINT FOR ALL SUB_CALLS");
            Entry newEntry = new Entry(path);
            jsons.forEach((name, json) -> newEntry.put((String)name, json.toString(2)));
        } else if (this.allArrays(jsons)) {
            if (this.ordered) {
                Set<Object> allKeys = this.allKeys(jsons);
                allKeys.forEach(key -> {
                    String currentPath = path + "[" + key + "]";
                    this.compareKey(currentPath, diffs, key, jsons);
                });
            }
        } else if (this.allObjects(jsons)) {
            Set<Object> allKeys = this.allKeys(jsons);
            allKeys.forEach(key -> {
                String currentPath = path + "." + key;
                this.compareKey(currentPath, diffs, key, jsons);
            });
        }
    }

    public List<Entry> getDiffs() {
        if (this.rootJson.size() <= 1) {
            return Collections.emptyList();
        }
        LinkedList<Entry> rtrn = new LinkedList<Entry>();
        this.diff("$", rtrn, this.rootJson);
        return rtrn;
    }

    private int getScore(Json base, Json other) {
        int rtrn = 0;
        for (String path : this.criteria.keySet()) {
            int limit = this.criteria.get(path);
            Object baseFound = Json.find(base, path, null);
            Object otherFound = Json.find(other, path, null);
            if (baseFound == null && otherFound == null) continue;
            if (baseFound == null || otherFound == null) {
                return Integer.MAX_VALUE;
            }
            int editDistance = StringUtil.editDistance(baseFound.toString(), otherFound.toString());
            if (editDistance > limit) {
                return Integer.MAX_VALUE;
            }
            rtrn += editDistance;
        }
        HashSet<Object> allKeys = new HashSet<Object>(base.keys());
        allKeys.addAll(other.keys());
        LongAdder adder = new LongAdder();
        allKeys.forEach(key -> {
            Object baseValue = base.get(key);
            Object otherValue = other.get(key);
            if (base == null) {
                adder.add(otherValue.toString().length());
            } else if (other == null) {
                adder.add(baseValue.toString().length());
            } else {
                adder.add(StringUtil.editDistance(baseValue.toString(), otherValue.toString()));
            }
        });
        return rtrn += adder.intValue();
    }

    private void compareKey(String path, List<Entry> diffs, Object key, Map<String, Json> jsons) {
        if (!this.allHave(key, jsons)) {
            Entry newDiff = new Entry(path);
            jsons.forEach((name, json) -> {
                if (json.has(key)) {
                    newDiff.put((String)name, json.get(key).toString());
                }
            });
            diffs.add(newDiff);
        } else if (this.allJson(key, jsons)) {
            HashMap<String, Json> keyJsons = new HashMap<String, Json>();
            jsons.forEach((name, json) -> keyJsons.put((String)name, json.getJson(key)));
            this.diff(path, diffs, keyJsons);
        } else {
            HashMap<String, Object> values = new HashMap<String, Object>();
            HashSet uniqueValues = new HashSet();
            jsons.forEach((name, json) -> {
                Object jsonValue = json.get(key);
                values.put((String)name, jsonValue);
                uniqueValues.add(jsonValue);
            });
            if (uniqueValues.size() > 1) {
                Entry newDiff = new Entry(path);
                values.forEach((name, value) -> newDiff.put((String)name, value.toString()));
                diffs.add(newDiff);
            }
        }
    }

    private boolean allJson(Object key, Map<String, Json> jsons) {
        return jsons.values().stream().filter(json -> !(json.get(key) instanceof Json)).findAny().orElse(null) == null;
    }

    private boolean allHave(Object key, Map<String, Json> jsons) {
        return jsons.values().stream().filter(json -> !json.has(key)).findAny().orElse(null) == null;
    }

    private Set<Object> allKeys(Map<String, Json> jsons) {
        LinkedHashSet<Object> rtrn = new LinkedHashSet<Object>();
        jsons.values().forEach(json -> rtrn.addAll(json.keys()));
        return rtrn;
    }

    private boolean allArrays(Map<String, Json> jsons) {
        return jsons.values().stream().filter(v -> !v.isArray()).findAny().orElse(null) == null;
    }

    private boolean allObjects(Map<String, Json> jsons) {
        return jsons.values().stream().filter(v -> v.isArray()).findAny().orElse(null) == null;
    }

    private boolean isEmtpy(Map<String, Json> jsons) {
        return jsons.values().stream().map(json -> json == null || json.isEmpty()).reduce(Boolean::logicalAnd).orElse(false);
    }

    private boolean hasNull(Map<String, Json> jsons) {
        boolean rtrn = false;
        for (Json json : jsons.values()) {
            if (json != null && !json.isEmpty()) continue;
            rtrn = true;
            return true;
        }
        return rtrn;
    }

    public static class Entry {
        private String path;
        private LinkedHashMap<String, String> values;

        public Entry(String path) {
            this.path = path;
            this.values = new LinkedHashMap();
        }

        private void put(String name, String value) {
            this.values.put(name, value);
        }

        public String getPath() {
            return this.path;
        }

        public Set<String> keys() {
            return this.values.keySet();
        }

        public String value(String key) {
            return this.values.get(key);
        }

        public void forEach(BiConsumer<String, String> consumer) {
            this.values.forEach(consumer);
        }
    }
}

