/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.json.graaljs;

import io.hyperfoil.tools.yaup.json.Json;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.SourceSection;

public class JsException
extends RuntimeException {
    private String js;
    private int lineStart;
    private int lineEnd;
    private int columnStart;
    private int columnEnd;
    private Json context;

    public JsException(String message) {
        this(message, "", null, -1, -1, -1, -1);
    }

    public JsException(String message, String js, int lineStart, int lineEnd, int columnStart, int columnEnd) {
        this(message, js, null, lineStart, lineEnd, columnStart, columnEnd);
        this.context = new Json(false);
    }

    public JsException(String message, String js) {
        this(message, js, null);
        this.context = new Json(false);
    }

    public Json getContext() {
        return this.context;
    }

    public JsException(String message, PolyglotException pe) {
        super(message, (Throwable)pe);
        this.context = new Json(false);
        SourceSection sourceSection = pe.getSourceLocation();
        if (sourceSection != null) {
            Source source = sourceSection.getSource();
            this.js = source != null ? (source.hasCharacters() ? source.getCharacters().toString() : new String(source.getBytes().toByteArray())) : "unknown";
            this.lineStart = sourceSection.getStartLine();
            this.lineEnd = sourceSection.getEndLine();
            this.columnStart = sourceSection.getStartColumn();
            this.columnEnd = sourceSection.getEndColumn();
        } else {
            this.js = "unknown";
            this.lineStart = -1;
            this.lineEnd = -1;
            this.columnStart = -1;
            this.columnEnd = -1;
        }
    }

    public void addArgs(Object ... args) {
        if (!this.getContext().has("args")) {
            this.getContext().set("args", new Json(true));
        }
        Arrays.stream(args).forEach(arg -> this.getContext().getJson("args").add(arg));
    }

    public JsException(String message, String js, Throwable throwable) {
        super(message, throwable);
        this.js = js;
        this.context = new Json(false);
        if (throwable != null && throwable instanceof PolyglotException) {
            PolyglotException pe = (PolyglotException)throwable;
            SourceSection sourceSection = pe.getSourceLocation();
            if (sourceSection != null) {
                PolyglotException.StackFrame sf;
                SourceSection ss;
                Iterable iterator;
                Iterator iter;
                Source source = sourceSection.getSource();
                this.lineStart = sourceSection.getStartLine();
                this.lineEnd = sourceSection.getEndLine();
                this.columnStart = sourceSection.getStartColumn();
                this.columnEnd = sourceSection.getEndColumn();
                if (this.columnStart == this.columnEnd && this.columnStart == 1 && (iter = (iterator = pe.getPolyglotStackTrace()).iterator()).hasNext() && (ss = (sf = (PolyglotException.StackFrame)iter.next()).getSourceLocation()) != null) {
                    this.lineStart = ss.getStartLine();
                    this.lineEnd = ss.getEndLine();
                    this.columnStart = ss.getStartColumn();
                    this.columnEnd = ss.getEndColumn();
                }
            }
        } else {
            this.lineStart = -1;
            this.lineEnd = -1;
            this.columnStart = -1;
            this.columnEnd = -1;
        }
    }

    public JsException(String message, String js, Throwable throwable, int lineStart, int lineEnd, int columnStart, int columnEnd) {
        super(message, throwable);
        this.js = js;
        this.context = new Json(false);
        this.lineStart = lineStart;
        this.lineEnd = lineEnd;
        this.columnStart = columnStart;
        this.columnEnd = columnEnd;
    }

    public boolean hasSource() {
        return this.js != null;
    }

    public boolean hasErrorLocation() {
        return this.columnStart > -1 && this.columnEnd > -1 && this.lineStart > -1 && this.lineEnd > -1;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public int getLineEnd() {
        return this.lineEnd;
    }

    public int getColumnStart() {
        return this.columnStart;
    }

    public int getColumnEnd() {
        return this.columnEnd;
    }

    public String getJs() {
        return this.js;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessage());
        String[] split = this.js.split(System.lineSeparator());
        for (int i = 0; i < split.length; ++i) {
            sb.append(System.lineSeparator());
            sb.append(split[i]);
            if (i + 1 != this.lineStart) continue;
            sb.append(System.lineSeparator());
            if (this.columnEnd == this.columnStart) {
                sb.append(String.format("%" + this.columnStart + "s", "^"));
                continue;
            }
            sb.append(String.format("%" + this.columnStart + "s", "^") + String.format("%" + (this.columnEnd - this.columnStart) + "s", "^").replaceAll(" ", "-"));
        }
        if (!this.getContext().isEmpty()) {
            sb.append(System.lineSeparator());
            sb.append(this.getContext().toString());
        }
        return sb.toString();
    }
}

