/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.json.graaljs;

import io.hyperfoil.tools.yaup.json.Json;
import io.hyperfoil.tools.yaup.json.ValueConverter;
import io.hyperfoil.tools.yaup.json.graaljs.JsonProxy;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.graalvm.polyglot.proxy.ProxyObject;

public class JsonProxyObject
implements ProxyObject {
    private Json json;

    JsonProxyObject(Json json) {
        this.json = json;
    }

    public Json getJson() {
        return this.json;
    }

    public Object getMember(String key) {
        Object rtrn;
        Object object = rtrn = this.json.isArray() && key.matches("\\d+") ? this.json.get(Integer.parseInt(key)) : this.json.get(key);
        if (rtrn instanceof Json) {
            rtrn = JsonProxy.create((Json)rtrn);
        }
        return rtrn;
    }

    public Object getMemberKeys() {
        return this.json.keys().stream().map(o -> o.toString()).toArray();
    }

    public boolean hasMember(String key) {
        if (this.json.isArray() && key.matches("\\d+")) {
            return this.json.has(Integer.parseInt(key));
        }
        return this.json.has(key);
    }

    public void putMember(String key, Value value) {
        if (this.json.isArray() && key.matches("\\d+")) {
            this.json.set(Integer.parseInt(key), ValueConverter.convert(value));
        } else {
            this.json.set(key, ValueConverter.convert(value));
        }
    }

    public boolean removeMember(String key) {
        boolean rtrn = this.json.has(key);
        if (this.json.isArray() && key.matches("\\d+")) {
            Integer intKey = Integer.parseInt(key);
            rtrn = this.json.has(intKey);
            this.json.remove(intKey);
        } else {
            this.json.remove(key);
        }
        return rtrn;
    }

    public String toString() {
        return this.json.toString(0);
    }

    public static class InstanceCheck
    implements ProxyExecutable {
        public Object execute(Value ... args) {
            if (args.length < 1) {
                return false;
            }
            Value obj = args[0];
            return obj.isProxyObject() && obj.asProxyObject() instanceof JsonProxyObject || ValueConverter.convert(obj) instanceof Json;
        }
    }
}

