/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.yaml;

import io.hyperfoil.tools.yaup.yaml.Defer;
import io.hyperfoil.tools.yaup.yaml.Mapping;
import io.hyperfoil.tools.yaup.yaml.WithDefer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public class MapRepresenter
extends Representer
implements Defer {
    private final Map<Class, Function<Object, Object>> encoders = new LinkedHashMap<Class, Function<Object, Object>>();

    @Override
    public Object deferAs(Object obj, Class<?> clazz) {
        Object rtrn = null;
        if (clazz != null && this.encoders.containsKey(clazz)) {
            rtrn = this.encoders.get(clazz).apply(obj);
        } else {
            Function encoder = this.encoders.keySet().stream().filter(e -> e.isInstance(obj)).map(e -> this.encoders.get(e)).findFirst().orElse(null);
            if (encoder != null) {
                rtrn = encoder.apply(obj);
            }
        }
        return rtrn;
    }

    public boolean hasEncoder(Class clazz) {
        return this.encoders.containsKey(clazz);
    }

    public Function<Object, Object> getEncoder(Class clazz) {
        return this.encoders.get(clazz);
    }

    @Override
    public Object defer(Object obj) {
        return this.deferAs(obj, null);
    }

    public void addMapping(Class<?> clazz, Mapping mapping) {
        this.encoders.putIfAbsent(clazz, o -> mapping.getMap(o));
        if (mapping instanceof WithDefer) {
            ((WithDefer)((Object)mapping)).setDefer(this);
        }
        this.addRepresent(clazz, new MapWrapper(mapping));
    }

    public <T> void addEncoding(Class<T> clazz, Function<T, Object> encoder) {
        if (encoder instanceof WithDefer) {
            ((WithDefer)((Object)encoder)).setDefer(this);
        }
        this.encoders.putIfAbsent(clazz, o -> encoder.apply(o));
        this.addRepresent(clazz, new ObjectWrapper<T>(encoder));
    }

    public MapRepresenter() {
        this(new DumperOptions());
    }

    public MapRepresenter(DumperOptions options) {
        super(options);
    }

    protected void addRepresent(Class<?> clazz, Represent represent) {
        this.representers.putIfAbsent(clazz, represent);
    }

    public class MapWrapper
    implements Represent {
        private final Mapping mapping;

        MapWrapper(Mapping mapping) {
            this.mapping = mapping;
        }

        public final Node representData(Object data) {
            Map<Object, Object> map = this.mapping.getMap(data);
            if (map != null) {
                Node rtrn = MapRepresenter.this.representMapping(Tag.MAP, map, DumperOptions.FlowStyle.BLOCK);
                return rtrn;
            }
            throw new RuntimeException("failed to map " + data);
        }
    }

    public class ObjectWrapper<T>
    implements Represent {
        private final Function<T, Object> encoder;

        public ObjectWrapper(Function<T, Object> encoder) {
            this.encoder = encoder;
        }

        public Node representData(Object data) {
            try {
                Object encoded = this.encoder.apply(data);
                if (encoded instanceof Map) {
                    return MapRepresenter.this.representMapping(Tag.MAP, (Map)encoded, DumperOptions.FlowStyle.BLOCK);
                }
                if (encoded instanceof List) {
                    return MapRepresenter.this.representSequence(Tag.SEQ, (List)encoded, DumperOptions.FlowStyle.BLOCK);
                }
                if (encoded instanceof String) {
                    return MapRepresenter.this.representScalar(Tag.STR, (String)encoded);
                }
                if (encoded instanceof Integer || encoded instanceof Long) {
                    return MapRepresenter.this.representScalar(Tag.INT, encoded.toString());
                }
                if (encoded instanceof Float || encoded instanceof Double) {
                    return MapRepresenter.this.representScalar(Tag.FLOAT, encoded.toString());
                }
                if (encoded instanceof Boolean) {
                    return MapRepresenter.this.representScalar(Tag.BOOL, encoded.toString());
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            throw new YAMLException("Encoding failed for " + data);
        }
    }
}

