/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.yaml;

import io.hyperfoil.tools.yaup.Sets;
import io.hyperfoil.tools.yaup.json.Json;
import io.hyperfoil.tools.yaup.yaml.DeferableConstruct;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class OverloadConstructor
extends Constructor {
    boolean exactMatchOnly = true;
    Map<String, Tag> valueTags;
    Map<String, Tag> targetTags;
    Map<String, Tag> stringOverrides;
    SortedMap<Set<String>, Tag> keySets;
    SortedMap<Json, Tag> typeStructures;

    public static Object fromScalar(ScalarNode node) {
        if (Tag.BOOL.equals((Object)node.getTag())) {
            return Boolean.parseBoolean(node.getValue());
        }
        if (Tag.INT.equals((Object)node.getTag())) {
            return Integer.parseInt(node.getValue());
        }
        if (Tag.FLOAT.equals((Object)node.getTag())) {
            return Float.valueOf(Float.parseFloat(node.getValue()));
        }
        return node.getValue();
    }

    public static Json json(Node node) {
        Json rtrn = new Json(node instanceof SequenceNode);
        if (node instanceof MappingNode) {
            MappingNode mappingNode = (MappingNode)node;
            mappingNode.getValue().forEach(nodeTuple -> {
                String key = ((ScalarNode)nodeTuple.getKeyNode()).getValue();
                Node value = nodeTuple.getValueNode();
                if (value instanceof ScalarNode) {
                    rtrn.add(key, OverloadConstructor.fromScalar((ScalarNode)value));
                } else {
                    rtrn.add(key, OverloadConstructor.json(value));
                }
            });
        } else if (node instanceof SequenceNode) {
            SequenceNode sequenceNode = (SequenceNode)node;
            sequenceNode.getValue().forEach(value -> {
                if (value instanceof ScalarNode) {
                    rtrn.add(OverloadConstructor.fromScalar((ScalarNode)value));
                } else {
                    rtrn.add(OverloadConstructor.json(value));
                }
            });
        } else if (node instanceof ScalarNode) {
            ScalarNode scalarNode = (ScalarNode)node;
        }
        return rtrn;
    }

    public static Set<String> keys(MappingNode node) {
        return node.getValue().stream().map(nodeTuple -> ((ScalarNode)nodeTuple.getKeyNode()).getValue()).collect(Collectors.toSet());
    }

    public OverloadConstructor() {
        this(new LoaderOptions());
    }

    public OverloadConstructor(LoaderOptions loaderOptions) {
        super(loaderOptions);
        this.yamlConstructors.put(Tag.MAP, new MapOverride((Construct)this.yamlConstructors.get(Tag.MAP)));
        this.yamlConstructors.put(Tag.STR, new StrOverride((Construct)this.yamlConstructors.get(Tag.STR)));
        this.keySets = new TreeMap<Set<String>, Tag>((a, b) -> {
            int rtrn = b.size() - a.size();
            if (rtrn == 0) {
                rtrn = b.hashCode() - a.hashCode();
            }
            return rtrn;
        });
        this.typeStructures = new TreeMap<Json, Tag>((a, b) -> {
            int rtrn = b.size() - a.size();
            if (rtrn == 0) {
                rtrn = b.hashCode() - a.hashCode();
            }
            return rtrn;
        });
        this.targetTags = new HashMap<String, Tag>();
        this.valueTags = new HashMap<String, Tag>();
        this.stringOverrides = new HashMap<String, Tag>();
    }

    public void setComposer(Composer composer) {
        super.setComposer(composer);
    }

    public boolean isExactMatchOnly() {
        return this.exactMatchOnly;
    }

    public void setExactMatchOnly(boolean exactMatchOnly) {
        this.exactMatchOnly = exactMatchOnly;
    }

    public String dump() {
        return this.keySets.entrySet().stream().map(entry -> ((Set)entry.getKey()).toString() + " [" + ((Set)entry.getKey()).hashCode() + "] -> " + ((Tag)entry.getValue()).toString()).collect(Collectors.joining("\n"));
    }

    public Object retryAs(Node node, Tag newTag) {
        if (newTag != null && !newTag.equals((Object)node.getTag())) {
            node.setTag(newTag);
            Mark fakeMark = new Mark("fake", 0, 0, 0, "fake".toCharArray(), 0);
            Object throwaway = this.constructDocument((Node)new ScalarNode(Tag.STR, "throwaway", fakeMark, fakeMark, DumperOptions.ScalarStyle.DOUBLE_QUOTED));
            return this.constructObject(node);
        }
        throw new YAMLException("Already tried to load " + newTag.getValue() + " from " + node.getStartMark());
    }

    public Object constructObject(Node node) {
        return super.constructObject(node);
    }

    public Tag getBestMatch(Set<String> keys) {
        Set<String> targetMatch = Sets.getOverlap(keys, this.targetTags.keySet());
        if (targetMatch.size() == 1) {
            return this.targetTags.get(targetMatch.iterator().next());
        }
        Set bestMatch = this.keySets.keySet().stream().filter(required -> keys.containsAll((Collection<?>)required)).findFirst().orElse(null);
        return bestMatch != null ? (Tag)this.keySets.get(bestMatch) : null;
    }

    public boolean hasConstruct(Tag tag) {
        return this.yamlConstructors.containsKey(tag);
    }

    public Construct getConstruct(Tag tag) {
        return (Construct)this.yamlConstructors.get(tag);
    }

    public void addConstruct(Tag tag, Construct construct) {
        if (construct instanceof DeferableConstruct) {
            ((DeferableConstruct)construct).setOverloadConstructor(this);
        }
        this.yamlConstructors.putIfAbsent(tag, construct);
    }

    public void addValueTag(Tag tag, String key) {
        this.valueTags.put(key, tag);
    }

    public void addStringTag(Tag tag, String pattern) {
        this.stringOverrides.put(pattern, tag);
    }

    public void addTargetTag(Tag tag, String key) {
        this.targetTags.put(key, tag);
    }

    public boolean addMapKeys(Tag tag, Set<String> requiredKeys) {
        boolean added = this.keySets.put(requiredKeys, tag) == null;
        return added;
    }

    public boolean addMapStructure(Tag tag, Json structure) {
        return false;
    }

    private class MapOverride
    extends AbstractConstruct {
        private final Construct parentConstruct;

        public MapOverride(Construct construct) {
            this.parentConstruct = construct;
        }

        public Object construct(Node node) {
            if (node instanceof MappingNode) {
                Tag targetTag;
                MappingNode mappingNode = (MappingNode)node;
                Set<String> keys = OverloadConstructor.keys(mappingNode);
                if (OverloadConstructor.this.keySets.containsKey(keys)) {
                    Tag tag = (Tag)OverloadConstructor.this.keySets.get(keys);
                    if (OverloadConstructor.this.hasConstruct(tag)) {
                        return OverloadConstructor.this.getConstruct(tag).construct(node);
                    }
                    return OverloadConstructor.this.retryAs(node, tag);
                }
                if (!OverloadConstructor.this.exactMatchOnly && (targetTag = OverloadConstructor.this.getBestMatch(keys)) != null) {
                    return OverloadConstructor.this.getConstruct(targetTag).construct(node);
                }
                LinkedHashMap rtrn = new LinkedHashMap();
                mappingNode.getValue().forEach(nodeTuple -> {
                    Object keyObject = OverloadConstructor.this.constructObject(nodeTuple.getKeyNode());
                    Node valueNode = nodeTuple.getValueNode();
                    if (!OverloadConstructor.this.valueTags.isEmpty() && keyObject instanceof String && OverloadConstructor.this.valueTags.containsKey(keyObject)) {
                        Tag valueTag = OverloadConstructor.this.valueTags.get(keyObject);
                        valueNode.setTag(valueTag);
                    }
                    Object valueObject = OverloadConstructor.this.constructObject(valueNode);
                    rtrn.put(keyObject, valueObject);
                });
                return rtrn;
            }
            throw new YAMLException("MapOverride requires MappingNode not " + node.getClass().getSimpleName() + " " + node.getStartMark());
        }
    }

    private class StrOverride
    extends AbstractConstruct {
        private final Construct parentConstruct;

        public StrOverride(Construct construct) {
            this.parentConstruct = construct;
        }

        public Object construct(Node node) {
            if (node instanceof ScalarNode) {
                ScalarNode scalarNode = (ScalarNode)node;
                String value = scalarNode.getValue();
                Tag scalarTag = scalarNode.getTag();
                if (Tag.STR.equals((Object)scalarTag) && !OverloadConstructor.this.stringOverrides.isEmpty()) {
                    for (String pattern : OverloadConstructor.this.stringOverrides.keySet()) {
                        Tag newTag = OverloadConstructor.this.stringOverrides.get(pattern);
                        if (!value.contains(pattern) && !value.matches(pattern)) continue;
                        return OverloadConstructor.this.retryAs((Node)scalarNode, newTag);
                    }
                }
                return this.parentConstruct.construct(node);
            }
            throw new YAMLException("StrOverride requires ScalarNode not " + node.getClass().getSimpleName() + " " + node.getStartMark());
        }
    }
}

