/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.yaml;

import io.hyperfoil.tools.yaup.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Scanner;
import org.yaml.snakeyaml.scanner.ScannerImpl;
import org.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.Token;

public class PatternScanner
implements Scanner {
    private StreamReader reader;
    private ScannerImpl scanner;
    private List<Token> stolenTokens = new ArrayList<Token>();

    public PatternScanner(StreamReader reader, LoaderOptions options) {
        this.reader = reader;
        this.scanner = new ScannerImpl(reader, options);
    }

    public String combineTokens(List<Token> tokens, int start, int end) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean deferQuote = false;
        char quoteChar = ' ';
        block10: for (int i = start; i < end; ++i) {
            Token t = tokens.get(i);
            switch (t.getTokenId()) {
                case Scalar: {
                    ScalarToken sc = (ScalarToken)t;
                    if ("$".equals(sc.getValue()) && i == start) {
                        if (DumperOptions.ScalarStyle.DOUBLE_QUOTED.equals((Object)sc.getStyle()) || DumperOptions.ScalarStyle.SINGLE_QUOTED.equals((Object)sc.getStyle())) {
                            deferQuote = true;
                            quoteChar = sc.getStyle().getChar().charValue();
                            stringBuilder.append(quoteChar);
                        }
                        stringBuilder.append("$");
                        continue block10;
                    }
                    if (DumperOptions.ScalarStyle.DOUBLE_QUOTED.equals((Object)sc.getStyle())) {
                        stringBuilder.append(StringUtil.quote(sc.getValue(), "\""));
                        continue block10;
                    }
                    if (DumperOptions.ScalarStyle.SINGLE_QUOTED.equals((Object)sc.getStyle())) {
                        stringBuilder.append(StringUtil.quote(sc.getValue(), "'"));
                        continue block10;
                    }
                    stringBuilder.append(sc.getValue());
                    continue block10;
                }
                case FlowMappingStart: {
                    stringBuilder.append("{");
                    continue block10;
                }
                case FlowMappingEnd: {
                    stringBuilder.append("}");
                    continue block10;
                }
                case FlowSequenceStart: {
                    stringBuilder.append("[");
                    continue block10;
                }
                case FlowSequenceEnd: {
                    stringBuilder.append("]");
                    continue block10;
                }
                case FlowEntry: {
                    stringBuilder.append(",");
                    continue block10;
                }
                case Value: {
                    stringBuilder.append(":");
                    continue block10;
                }
                case Key: {
                    continue block10;
                }
                default: {
                    System.err.println("PatternScanner missing conversion for " + t.getTokenId().name() + " " + t);
                }
            }
        }
        if (deferQuote) {
            stringBuilder.append(quoteChar);
        }
        return stringBuilder.toString();
    }

    public void stealTokens() {
        this.scanner.checkToken(new Token.ID[]{Token.ID.Comment});
        boolean stolen = false;
        try {
            while (true) {
                Token t = this.scanner.getToken();
                stolen = true;
                this.stolenTokens.add(t);
            }
        }
        catch (IndexOutOfBoundsException t) {
            if (stolen) {
                int patternStartDepth = -1;
                int patternStart = -1;
                int patternDepth = 0;
                for (int i = 0; i < this.stolenTokens.size(); ++i) {
                    Token t2 = this.stolenTokens.get(i);
                    Token.ID id = t2.getTokenId();
                    if (t2 instanceof ScalarToken && ((ScalarToken)t2).getValue().endsWith("$") && this.stolenTokens.size() > i + 2 && this.stolenTokens.get(i + 1) instanceof FlowMappingStartToken && this.stolenTokens.get(i + 2) instanceof FlowMappingStartToken) {
                        if (patternStart < 0) {
                            patternStart = i;
                        }
                        ++patternDepth;
                        i += 2;
                        continue;
                    }
                    if (!(t2 instanceof FlowMappingEndToken) || this.stolenTokens.size() <= i + 1 || !(this.stolenTokens.get(i + 1) instanceof FlowMappingEndToken)) continue;
                    ++i;
                    if (--patternDepth != 0) continue;
                    String combined = this.combineTokens(this.stolenTokens, patternStart, i + 1);
                    Token firstDropped = this.stolenTokens.get(patternStart);
                    Token lastDropped = this.stolenTokens.get(i + 1);
                    for (int k = 0; k <= i - patternStart; ++k) {
                        this.stolenTokens.remove(patternStart);
                    }
                    i = patternStart;
                    ScalarToken newToken = new ScalarToken(combined, true, firstDropped.getStartMark(), lastDropped.getEndMark(), combined.startsWith("\"") ? DumperOptions.ScalarStyle.DOUBLE_QUOTED : (combined.startsWith("'") ? DumperOptions.ScalarStyle.SINGLE_QUOTED : DumperOptions.ScalarStyle.PLAIN));
                    this.stolenTokens.add(patternStart, (Token)newToken);
                    patternStart = -1;
                }
            }
            return;
        }
    }

    public boolean checkToken(Token.ID ... ids) {
        this.stealTokens();
        if (!this.stolenTokens.isEmpty()) {
            if (ids.length == 0) {
                return true;
            }
            Token.ID t = this.stolenTokens.get(0).getTokenId();
            for (int i = 0; i < ids.length; ++i) {
                if (t != ids[i]) continue;
                return true;
            }
        }
        return false;
    }

    public Token peekToken() {
        this.stealTokens();
        return this.stolenTokens.get(0);
    }

    public Token getToken() {
        this.stealTokens();
        Token rtrn = this.stolenTokens.remove(0);
        return rtrn;
    }

    public void resetDocumentIndex() {
        this.scanner.resetDocumentIndex();
    }
}

