/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.tools.yaup.yaml;

import io.hyperfoil.tools.yaup.StringUtil;
import io.hyperfoil.tools.yaup.yaml.DeferableConstruct;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class PatternTemplate {
    private String prefix;
    private String suffix;
    private String javascriptPrefix;
    private String separator;
    private String template;
    private boolean isQuoted = false;

    public PatternTemplate(String template) {
        this(template, "${{", "}}", ":", "=");
    }

    public PatternTemplate(String template, String prefix, String suffix, String separator, String javascriptPrefix) {
        this.template = StringUtil.removeQuotes(template);
        this.isQuoted = StringUtil.isQuoted(template);
        this.prefix = prefix;
        this.suffix = suffix;
        this.separator = separator;
        this.javascriptPrefix = javascriptPrefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getJavascriptPrefix() {
        return this.javascriptPrefix;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getTemplate() {
        return this.template;
    }

    public String toString() {
        return this.template;
    }

    public static class Construct
    extends DeferableConstruct {
        public Object construct(Node node) {
            if (node instanceof ScalarNode) {
                ScalarNode scalarNode = (ScalarNode)node;
                String value = scalarNode.getScalarStyle().equals((Object)DumperOptions.ScalarStyle.DOUBLE_QUOTED) ? StringUtil.quote(scalarNode.getValue(), "\"") : (scalarNode.getScalarStyle().equals((Object)DumperOptions.ScalarStyle.SINGLE_QUOTED) ? StringUtil.quote(scalarNode.getValue(), "'") : scalarNode.getValue());
                return new PatternTemplate(value);
            }
            throw new YAMLException("patterns require scalar value " + node.getStartMark());
        }
    }
}

