/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.id;

import io.hypersistence.tsid.TSID;
import io.hypersistence.utils.hibernate.util.ReflectionUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class TsidGenerator
implements IdentifierGenerator,
Configurable {
    private TSID.Factory DEFAULT_TSID_FACTORY;
    public static final String TSID_FACTORY_SUPPLIER_PARAM = "tsid_factory_supplier";
    private TSID.Factory tsidFactory;
    private AttributeType idType;

    public TsidGenerator() {
        this.tsidFactory = this.DEFAULT_TSID_FACTORY = TSID.Factory.builder().withRandomFunction(TSID.Factory.THREAD_LOCAL_RANDOM_FUNCTION).build();
    }

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        this.idType = AttributeType.valueOf(type.getReturnedClass());
        String tsidSupplierClass = ConfigurationHelper.getString((String)TSID_FACTORY_SUPPLIER_PARAM, (Map)params);
        if (tsidSupplierClass != null) {
            Supplier factorySupplier = (Supplier)ReflectionUtils.newInstance(tsidSupplierClass);
            this.tsidFactory = (TSID.Factory)factorySupplier.get();
        }
    }

    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        return this.idType.cast(this.tsidFactory.generate());
    }

    static enum AttributeType {
        LONG{

            @Override
            public Serializable cast(TSID tsid) {
                return Long.valueOf(tsid.toLong());
            }
        }
        ,
        STRING{

            @Override
            public Serializable cast(TSID tsid) {
                return tsid.toString();
            }
        }
        ,
        TSID{

            @Override
            public Serializable cast(TSID tsid) {
                return tsid;
            }
        };


        public abstract Serializable cast(TSID var1);

        static AttributeType valueOf(Class clazz) {
            if (Long.class.isAssignableFrom(clazz)) {
                return LONG;
            }
            if (String.class.isAssignableFrom(clazz)) {
                return STRING;
            }
            if (TSID.class.isAssignableFrom(clazz)) {
                return TSID;
            }
            throw new HibernateException(String.format("The @Tsid annotation on [%s] can only be placed on a Long or String entity attribute!", clazz));
        }
    }
}

