/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic.internal;

import io.hypersistence.utils.hibernate.type.util.ParameterTypeUtils;
import io.hypersistence.utils.hibernate.util.StringUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.IntegerTypeDescriptor;
import org.hibernate.type.descriptor.sql.SmallIntTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.TinyIntTypeDescriptor;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.ParameterizedType;

public class NumberSqlTypeDescriptor
implements SqlTypeDescriptor,
ParameterizedType {
    public static final NumberSqlTypeDescriptor INSTANCE = new NumberSqlTypeDescriptor();
    private volatile SqlTypeDescriptor jdbcTypeDescriptor;
    private volatile Properties properties;

    public NumberSqlTypeDescriptor() {
    }

    public NumberSqlTypeDescriptor(Properties properties) {
        this.properties = properties;
    }

    public int getSqlType() {
        return this.jdbcTypeDescriptor != null ? this.jdbcTypeDescriptor.getSqlType() : 4;
    }

    public boolean canBeRemapped() {
        return true;
    }

    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return NumberSqlTypeDescriptor.this.sqlTypeDescriptor().getExtractor(javaTypeDescriptor).extract(rs, name, options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return NumberSqlTypeDescriptor.this.sqlTypeDescriptor().getExtractor(javaTypeDescriptor).extract(statement, index, options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return NumberSqlTypeDescriptor.this.sqlTypeDescriptor().getExtractor(javaTypeDescriptor).extract(statement, new String[]{name}, options);
            }
        };
    }

    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                NumberSqlTypeDescriptor.this.sqlTypeDescriptor().getBinder(javaTypeDescriptor).bind(st, value, index, options);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                NumberSqlTypeDescriptor.this.sqlTypeDescriptor().getBinder(javaTypeDescriptor).bind(st, value, name, options);
            }
        };
    }

    private SqlTypeDescriptor sqlTypeDescriptor() {
        if (this.jdbcTypeDescriptor == null) {
            this.jdbcTypeDescriptor = this.resolveJdbcTypeDescriptor();
        }
        return this.jdbcTypeDescriptor;
    }

    private SqlTypeDescriptor resolveJdbcTypeDescriptor() {
        String columnType;
        DynamicParameterizedType.ParameterType parameterType = ParameterTypeUtils.resolve(this.properties);
        if (parameterType != null && !StringUtils.isBlank(columnType = ParameterTypeUtils.getColumnType(parameterType))) {
            switch (columnType) {
                case "tinyint": {
                    return TinyIntTypeDescriptor.INSTANCE;
                }
                case "smallint": {
                    return SmallIntTypeDescriptor.INSTANCE;
                }
            }
        }
        return IntegerTypeDescriptor.INSTANCE;
    }

    public void setParameterValues(Properties parameters) {
        if (this.properties == null) {
            this.properties = parameters;
        } else {
            this.properties.putAll((Map<?, ?>)parameters);
        }
    }
}

