/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.spring.aop;

import io.hypersistence.utils.spring.annotation.Retry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RetryAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryAspect.class);

    @Around(value="@annotation(io.hypersistence.utils.spring.annotation.Retry)")
    public Object retry(ProceedingJoinPoint pjp) throws Throwable {
        Retry retryAnnotation = this.getAnnotation(pjp, Retry.class);
        return retryAnnotation != null ? this.proceed(pjp, retryAnnotation) : this.proceed(pjp);
    }

    private Object proceed(ProceedingJoinPoint pjp) throws Throwable {
        return pjp.proceed();
    }

    private Object proceed(ProceedingJoinPoint pjp, Retry retryAnnotation) throws Throwable {
        int times = retryAnnotation.times();
        Object[] retryOn = retryAnnotation.on();
        if (times <= 0) {
            throw new IllegalArgumentException("@Retry{times} should be greater than 0!");
        }
        if (retryOn.length <= 0) {
            throw new IllegalArgumentException("@Retry{on} should have at least one Throwable!");
        }
        LOGGER.trace("Proceed with {} retries on {}", (Object)times, (Object)Arrays.toString(retryOn));
        return this.tryProceeding(pjp, times, (Class<? extends Throwable>[])retryOn);
    }

    private Object tryProceeding(ProceedingJoinPoint pjp, int times, Class<? extends Throwable>[] retryOn) throws Throwable {
        try {
            return this.proceed(pjp);
        }
        catch (Throwable throwable) {
            if (this.isRetryThrowable(throwable, retryOn) && times-- > 0) {
                LOGGER.info("Retryable failure was caught, {} remaining retr{} on {}", new Object[]{times, times == 1 ? "y" : "ies", Arrays.toString(retryOn)});
                return this.tryProceeding(pjp, times, retryOn);
            }
            throw throwable;
        }
    }

    private boolean isRetryThrowable(Throwable throwable, Class<? extends Throwable>[] retryOn) {
        Throwable cause = throwable;
        while (true) {
            for (Class<? extends Throwable> retryThrowable : retryOn) {
                if (!retryThrowable.isAssignableFrom(cause.getClass())) continue;
                return true;
            }
            if (cause.getCause() == null || cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }

    private <T extends Annotation> T getAnnotation(ProceedingJoinPoint pjp, Class<T> annotationClass) throws NoSuchMethodException {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        Annotation annotation = AnnotationUtils.findAnnotation((Method)method, annotationClass);
        if (annotation != null) {
            return (T)annotation;
        }
        method = pjp.getTarget().getClass().getMethod(pjp.getSignature().getName(), signature.getParameterTypes());
        return (T)AnnotationUtils.findAnnotation((Method)method, annotationClass);
    }
}

