/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.hypersistence.utils.hibernate.type.util.JsonSerializer;
import io.hypersistence.utils.hibernate.type.util.JsonSerializerSupplier;
import io.hypersistence.utils.hibernate.type.util.ObjectMapperSupplier;
import io.hypersistence.utils.hibernate.type.util.ObjectMapperWrapper;
import io.hypersistence.utils.hibernate.util.ClassLoaderUtils;
import io.hypersistence.utils.hibernate.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.hibernate.cfg.Environment;

public class Configuration
implements Serializable {
    public static final Configuration INSTANCE = new Configuration();
    @Deprecated
    public static final String DEPRECATED_PROPERTIES_FILE_PATH = "hibernate-types.properties.path";
    @Deprecated
    public static final String DEPRECATED_PROPERTIES_FILE_NAME = "hibernate-types.properties";
    public static final String PROPERTIES_FILE_PATH = "hypersistence-utils.properties.path";
    public static final String PROPERTIES_FILE_NAME = "hypersistence-utils.properties";
    public static final String APPLICATION_PROPERTIES_FILE_NAME = "application.properties";
    private final ObjectMapperWrapper objectMapperWrapper;
    private final Properties properties = Environment.getProperties();

    private Configuration() {
        this(null);
    }

    public Configuration(Map<String, Object> settings) {
        Object jsonSerializerPropertyInstance;
        this.load();
        if (settings != null) {
            this.properties.putAll(settings);
        }
        Object objectMapperPropertyInstance = this.instantiateClass(PropertyKey.JACKSON_OBJECT_MAPPER);
        ObjectMapperWrapper objectMapperWrapper = null;
        if (objectMapperPropertyInstance != null) {
            Object objectMapperSupplier;
            if (objectMapperPropertyInstance instanceof ObjectMapperSupplier) {
                objectMapperSupplier = (ObjectMapperSupplier)objectMapperPropertyInstance;
                objectMapperWrapper = new ObjectMapperWrapper((ObjectMapperSupplier)objectMapperSupplier);
            } else if (objectMapperPropertyInstance instanceof Supplier) {
                objectMapperSupplier = (Supplier)objectMapperPropertyInstance;
                objectMapperWrapper = new ObjectMapperWrapper(() -> Configuration.lambda$new$63ef27e3$1((Supplier)objectMapperSupplier));
            } else if (objectMapperPropertyInstance instanceof ObjectMapper) {
                ObjectMapper objectMapper = (ObjectMapper)objectMapperPropertyInstance;
                objectMapperWrapper = new ObjectMapperWrapper(objectMapper);
            }
        }
        if (objectMapperWrapper == null) {
            objectMapperWrapper = new ObjectMapperWrapper();
        }
        if ((jsonSerializerPropertyInstance = this.instantiateClass(PropertyKey.JSON_SERIALIZER)) != null) {
            JsonSerializer jsonSerializer = null;
            if (jsonSerializerPropertyInstance instanceof JsonSerializerSupplier) {
                jsonSerializer = ((JsonSerializerSupplier)jsonSerializerPropertyInstance).get();
            } else if (jsonSerializerPropertyInstance instanceof Supplier) {
                Supplier jsonSerializerSupplier = (Supplier)jsonSerializerPropertyInstance;
                jsonSerializer = (JsonSerializer)jsonSerializerSupplier.get();
            } else if (jsonSerializerPropertyInstance instanceof JsonSerializer) {
                jsonSerializer = (JsonSerializer)jsonSerializerPropertyInstance;
            }
            if (jsonSerializer != null) {
                objectMapperWrapper.setJsonSerializer(jsonSerializer);
            }
        }
        this.objectMapperWrapper = objectMapperWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        String[] propertiesFilePaths;
        String customPropertiesFilePath = System.getProperty(DEPRECATED_PROPERTIES_FILE_PATH);
        if (customPropertiesFilePath != null) {
            LogUtils.LOGGER.warn("The [{}] System property is deprecated. Use [{}] instead.", (Object)DEPRECATED_PROPERTIES_FILE_PATH, (Object)PROPERTIES_FILE_PATH);
        } else {
            customPropertiesFilePath = System.getProperty(PROPERTIES_FILE_PATH);
        }
        for (String propertiesFilePath : propertiesFilePaths = new String[]{APPLICATION_PROPERTIES_FILE_NAME, DEPRECATED_PROPERTIES_FILE_NAME, PROPERTIES_FILE_NAME, customPropertiesFilePath}) {
            if (propertiesFilePath == null) continue;
            InputStream propertiesInputStream = null;
            try {
                propertiesInputStream = this.propertiesInputStream(propertiesFilePath);
                if (propertiesInputStream == null) continue;
                this.properties.load(propertiesInputStream);
                if (!DEPRECATED_PROPERTIES_FILE_NAME.equals(propertiesFilePath)) continue;
                LogUtils.LOGGER.warn("The [{}] property file is deprecated. Use [{}] instead.", (Object)DEPRECATED_PROPERTIES_FILE_NAME, (Object)PROPERTIES_FILE_NAME);
            }
            catch (IOException e) {
                LogUtils.LOGGER.error("Can't load properties", (Throwable)e);
            }
            finally {
                try {
                    if (propertiesInputStream != null) {
                        propertiesInputStream.close();
                    }
                }
                catch (IOException e) {
                    LogUtils.LOGGER.error("Can't close the properties InputStream", (Throwable)e);
                }
            }
        }
    }

    private InputStream propertiesInputStream(String propertiesFilePath) throws IOException {
        if (propertiesFilePath != null) {
            URL propertiesFileUrl;
            block6: {
                try {
                    propertiesFileUrl = new URL(propertiesFilePath);
                }
                catch (MalformedURLException ignore) {
                    File f;
                    propertiesFileUrl = ClassLoaderUtils.getResource(propertiesFilePath);
                    if (propertiesFileUrl != null || !(f = new File(propertiesFilePath)).exists() || !f.isFile()) break block6;
                    try {
                        propertiesFileUrl = f.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        LogUtils.LOGGER.error("The property " + propertiesFilePath + " can't be resolved to either a URL, a classpath resource or a File");
                    }
                }
            }
            if (propertiesFileUrl != null) {
                return propertiesFileUrl.openStream();
            }
        }
        return ClassLoaderUtils.getResourceAsStream(propertiesFilePath);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ObjectMapperWrapper getObjectMapperWrapper() {
        return this.objectMapperWrapper;
    }

    public Integer integerProperty(PropertyKey propertyKey) {
        Integer value = null;
        String property = propertyKey.resolve(this.properties);
        if (property != null) {
            value = Integer.valueOf(property);
        }
        return value;
    }

    public Long longProperty(PropertyKey propertyKey) {
        Long value = null;
        String property = propertyKey.resolve(this.properties);
        if (property != null) {
            value = Long.valueOf(property);
        }
        return value;
    }

    public Boolean booleanProperty(PropertyKey propertyKey) {
        Boolean value = null;
        String property = propertyKey.resolve(this.properties);
        if (property != null) {
            value = Boolean.valueOf(property);
        }
        return value;
    }

    public <T> Class<T> classProperty(PropertyKey propertyKey) {
        Class<T> clazz = null;
        String property = propertyKey.resolve(this.properties);
        if (property != null) {
            try {
                return ClassLoaderUtils.loadClass(property);
            }
            catch (ClassNotFoundException e) {
                LogUtils.LOGGER.error("Couldn't load the " + property + " class given by the " + propertyKey + " property", (Throwable)e);
            }
        }
        return clazz;
    }

    private <T> T instantiateClass(PropertyKey propertyKey) {
        T object = null;
        String property = propertyKey.resolve(this.properties);
        if (property != null) {
            try {
                Class clazz = ClassLoaderUtils.loadClass(property);
                LogUtils.LOGGER.debug("Instantiate {}", clazz);
                object = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                LogUtils.LOGGER.error("Couldn't load the " + property + " class given by the " + propertyKey + " property", (Throwable)e);
            }
            catch (InstantiationException e) {
                LogUtils.LOGGER.error("Couldn't instantiate the " + property + " class given by the " + propertyKey + " property", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LogUtils.LOGGER.error("Couldn't access the " + property + " class given by the " + propertyKey + " property", (Throwable)e);
            }
        }
        return object;
    }

    private static /* synthetic */ ObjectMapper lambda$new$63ef27e3$1(Supplier objectMapperSupplier) {
        return (ObjectMapper)objectMapperSupplier.get();
    }

    public static enum PropertyKey {
        JACKSON_OBJECT_MAPPER("hypersistence.utils.jackson.object.mapper", "hibernate.types.jackson.object.mapper"),
        JSON_SERIALIZER("hypersistence.utils.json.serializer", "hibernate.types.json.serializer"),
        PRINT_BANNER("hypersistence.utils.print.banner", "hibernate.types.print.banner");

        private final String key;
        @Deprecated
        private final String deprecatedKey;

        private PropertyKey(String key, String deprecatedKey) {
            this.key = key;
            this.deprecatedKey = deprecatedKey;
        }

        public String resolve(Properties properties) {
            String value = properties.getProperty(this.key);
            if (value == null && (value = properties.getProperty(this.deprecatedKey)) != null) {
                LogUtils.LOGGER.warn("The [{}] configuration property is deprecated. Use [{}] instead.", (Object)this.deprecatedKey, (Object)this.key);
            }
            return value;
        }
    }
}

