/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array.internal;

import io.hypersistence.utils.hibernate.type.array.internal.ArrayUtil;
import java.sql.Array;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.DynamicParameterizedType;

public abstract class AbstractArrayTypeDescriptor<T>
extends AbstractClassJavaType<T>
implements DynamicParameterizedType,
BasicPluralJavaType {
    private Class<T> arrayObjectClass;
    private String sqlArrayType;

    public AbstractArrayTypeDescriptor(Class<T> arrayObjectClass) {
        this(arrayObjectClass, (MutabilityPlan<T>)new MutableMutabilityPlan<Object>(){

            protected T deepCopyNotNull(Object value) {
                return ArrayUtil.deepCopy(value);
            }
        });
    }

    protected AbstractArrayTypeDescriptor(Class<T> arrayObjectClass, MutabilityPlan<T> mutableMutabilityPlan) {
        super(arrayObjectClass, mutableMutabilityPlan);
        this.arrayObjectClass = arrayObjectClass;
    }

    public Class<T> getArrayObjectClass() {
        return this.arrayObjectClass;
    }

    public void setArrayObjectClass(Class<T> arrayObjectClass) {
        this.arrayObjectClass = arrayObjectClass;
    }

    public void setParameterValues(Properties parameters) {
        if (parameters.containsKey("org.hibernate.type.ParameterType")) {
            this.arrayObjectClass = ((DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType")).getReturnedClass();
        }
        this.sqlArrayType = parameters.getProperty("sql_array_type");
    }

    public boolean areEqual(T one, T another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return ArrayUtil.isEquals(one, another);
    }

    public String toString(T value) {
        return Arrays.deepToString(ArrayUtil.wrapArray(value));
    }

    public String extractLoggableRepresentation(T value) {
        return value == null ? "null" : this.toString(value);
    }

    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        return (X)ArrayUtil.wrapArray(value);
    }

    public <X> T wrap(X value, WrapperOptions options) {
        if (value instanceof Array) {
            Array array = (Array)value;
            try {
                return ArrayUtil.unwrapArray((Object[])array.getArray(), this.arrayObjectClass);
            }
            catch (SQLException e) {
                throw new HibernateException((Throwable)new IllegalArgumentException(e));
            }
        }
        return (T)value;
    }

    public JavaType getElementJavaType() {
        return this;
    }

    public BasicType<?> resolveType(TypeConfiguration typeConfiguration, Dialect dialect, BasicType elementType, ColumnTypeInformation columnTypeInformation) {
        return typeConfiguration.standardBasicTypeForJavaType(this.arrayObjectClass);
    }

    protected String getSqlArrayType() {
        return this.sqlArrayType;
    }
}

