/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.test.providers;

import io.hypersistence.utils.test.providers.DataSourceProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import javax.sql.DataSource;
import org.testcontainers.containers.JdbcDatabaseContainer;

public abstract class AbstractContainerDataSourceProvider
implements DataSourceProvider {
    private JdbcDatabaseContainer container;

    public JdbcDatabaseContainer getContainer() {
        return this.container;
    }

    public void initContainer(String username, String password) {
        this.container = (JdbcDatabaseContainer)this.newJdbcDatabaseContainer().withReuse(true).withEnv(Collections.singletonMap("ACCEPT_EULA", "Y")).withTmpFs(Collections.singletonMap("/testtmpfs", "rw"));
        if (this.supportsDatabaseName()) {
            this.container.withDatabaseName("high-performance-java-persistence");
        }
        if (this.supportsCredentials()) {
            this.container.withUsername(username).withPassword(password);
        }
        this.container.start();
    }

    @Override
    public DataSource dataSource() {
        DataSource dataSource;
        block9: {
            DataSource dataSource2 = this.newDataSource();
            Connection connection = dataSource2.getConnection();
            try {
                dataSource = dataSource2;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    if (this.container == null) {
                        this.initContainer(this.username(), this.password());
                    }
                    return this.newDataSource();
                }
            }
            connection.close();
        }
        return dataSource;
    }

    @Override
    public String url() {
        return this.container != null ? this.container.getJdbcUrl() : this.defaultJdbcUrl();
    }

    protected abstract String defaultJdbcUrl();

    protected abstract DataSource newDataSource();
}

