package io.hypersistence.utils.hibernate.query;

import jdk.jfr.Category;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;
import org.hibernate.resource.jdbc.spi.StatementInspector;

/**
 * The {@link JfrQueryLogger} allows you to log a given SQL, including its stack trace,
 * using JDK Flight Recorder.
 * <p>
 * This only works with HotSpot based JVMs and requires at least Java 11.
 *
 * @author Philippe Marschall
 * @since 3.6.0
 */
public final class JfrQueryLogger implements StatementInspector {

    @Override
    public String inspect(String sql) {
        QueryEvent event = new QueryEvent();
        event.setSql(sql);
        event.commit();
        return null;
    }

    @Category("Hibernate")
    @Label("Query")
    static class QueryEvent extends Event {

        @Label("SQL")
        @Description("The SQL query generated by Hibernate")
        private String sql;

        String getSql() {
            return sql;
        }

        void setSql(String sql) {
            this.sql = sql;
        }
    }
}
